/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.StandardOpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jodd.io.IOUtil;
import jodd.util.StringUtil;

public class NetUtil {
    public static final String LOCAL_HOST = "localhost";
    public static final String LOCAL_IP = "127.0.0.1";
    public static final String DEFAULT_MASK = "255.255.255.0";
    public static final int INT_VALUE_127_0_0_1 = 2130706433;
    private static final Pattern ip4RegExp = Pattern.compile("^((?:1?[1-9]?\\d|2(?:[0-4]\\d|5[0-5]))\\.){4}$");

    public static String resolveIpAddress(String hostname) {
        try {
            InetAddress netAddress = hostname == null || hostname.equalsIgnoreCase(LOCAL_HOST) ? InetAddress.getLocalHost() : Inet4Address.getByName(hostname);
            return netAddress.getHostAddress();
        }
        catch (UnknownHostException ignore) {
            return null;
        }
    }

    public static int getIpAsInt(String ipAddress) {
        String[] tokens;
        int ipIntValue = 0;
        for (String token : tokens = StringUtil.splitc(ipAddress, '.')) {
            if (ipIntValue > 0) {
                ipIntValue <<= 8;
            }
            ipIntValue += Integer.parseInt(token);
        }
        return ipIntValue;
    }

    public static int getMaskAsInt(String mask) {
        if (!NetUtil.validateIPv4(mask)) {
            mask = DEFAULT_MASK;
        }
        return NetUtil.getIpAsInt(mask);
    }

    public static boolean isSocketAccessAllowed(int localIp, int socketIp, int mask) {
        boolean _retVal = false;
        if (socketIp == 2130706433 || (localIp & mask) == (socketIp & mask)) {
            _retVal = true;
        }
        return _retVal;
    }

    public static boolean validateIPv4(String input) {
        Matcher m = ip4RegExp.matcher(input + '.');
        return m.matches();
    }

    public static String resolveHostName(byte[] ip) {
        try {
            InetAddress address = InetAddress.getByAddress(ip);
            return address.getHostName();
        }
        catch (UnknownHostException ignore) {
            return null;
        }
    }

    public static byte[] downloadBytes(String url) throws IOException {
        try (InputStream inputStream = new URL(url).openStream();){
            byte[] byArray = IOUtil.readBytes(inputStream);
            return byArray;
        }
    }

    public static String downloadString(String url, Charset encoding) throws IOException {
        try (InputStream inputStream = new URL(url).openStream();){
            String string = new String(IOUtil.readChars(inputStream, encoding));
            return string;
        }
    }

    public static String downloadString(String url) throws IOException {
        try (InputStream inputStream = new URL(url).openStream();){
            String string = new String(IOUtil.readChars(inputStream));
            return string;
        }
    }

    public static void downloadFile(String url, File file) throws IOException {
        try (InputStream inputStream = new URL(url).openStream();
             ReadableByteChannel rbc = Channels.newChannel(inputStream);
             FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            fileChannel.transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRemoteFileSize(String url) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            long l = connection.getContentLengthLong();
            return l;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

