/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HouseKeeperService;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.AcidCompactionHistoryService;
import org.apache.hadoop.hive.ql.txn.AcidOpenTxnsCounterService;
import org.apache.hadoop.hive.ql.txn.compactor.Cleaner;
import org.apache.hadoop.hive.ql.txn.compactor.Initiator;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnCommands2 {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnCommands2.class);
    protected static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands2.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    protected static final String TEST_WAREHOUSE_DIR = TEST_DATA_DIR + "/warehouse";
    protected static int BUCKET_COUNT = 2;
    @Rule
    public TestName testName = new TestName();
    protected HiveConf hiveConf;
    protected Driver d;

    @Before
    public void setUp() throws Exception {
        this.setUpWithTableProperties("'transactional'='true'");
    }

    protected void setUpWithTableProperties(String tableProperties) throws Exception {
        this.hiveConf = new HiveConf(this.getClass());
        this.hiveConf.set("fs.default.name", "file:///");
        this.hiveConf.set(HiveConf.ConfVars.PREEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.POSTEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, TEST_WAREHOUSE_DIR);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEINPUTFORMAT, HiveInputFormat.class.getName());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK, true);
        TxnDbUtil.setConfValues((HiveConf)this.hiveConf);
        TxnDbUtil.prepDb((HiveConf)this.hiveConf);
        File f = new File(TEST_WAREHOUSE_DIR);
        if (f.exists()) {
            FileUtil.fullyDelete((File)f);
        }
        if (!new File(TEST_WAREHOUSE_DIR).mkdirs()) {
            throw new RuntimeException("Could not create " + TEST_WAREHOUSE_DIR);
        }
        SessionState.start((SessionState)new SessionState(this.hiveConf));
        this.d = new Driver(this.hiveConf);
        this.d.setMaxRows(10000);
        this.dropTables();
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBL) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES (" + tableProperties + ")");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBLPART) + "(a int, b int) partitioned by (p string) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES (" + tableProperties + ")");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDPART) + "(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDPART2) + "(a2 int, b2 int) partitioned by (p2 string) stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDNESTEDPART) + "(a int, b int) partitioned by (p int, q int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES (" + tableProperties + ")");
    }

    protected void dropTables() throws Exception {
        for (Table t : Table.values()) {
            this.runStatementOnDriver("drop table if exists " + (Object)((Object)t));
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.d != null) {
                this.dropTables();
                this.d.destroy();
                this.d.close();
                this.d = null;
            }
            TxnDbUtil.cleanDb((HiveConf)this.hiveConf);
        }
        finally {
            FileUtils.deleteDirectory((File)new File(TEST_DATA_DIR));
        }
    }

    @Test
    public void testOrcPPD() throws Exception {
        this.testOrcPPD(true);
    }

    @Test
    public void testOrcNoPPD() throws Exception {
        this.testOrcPPD(false);
    }

    private void testOrcPPD(boolean enablePPD) throws Exception {
        List<String> explain;
        boolean originalPpd = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER, enablePPD);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(new int[][]{{1, 2}, {3, 4}}));
        String query = "update " + (Object)((Object)Table.ACIDTBL) + " set b = 5 where a = 3";
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain " + query);
            TestTxnCommands2.assertExplainHasString("filterExpr: (a = 3)", explain, "PPD wasn't pushed");
        }
        this.runStatementOnDriver(query);
        query = "select a,b from " + (Object)((Object)Table.ACIDTBL) + " where b = 4 order by a,b";
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain " + query);
            TestTxnCommands2.assertExplainHasString("filterExpr: (b = 4)", explain, "PPD wasn't pushed");
        }
        List<String> rs0 = this.runStatementOnDriver(query);
        Assert.assertEquals((String)"Read failed", (long)0L, (long)rs0.size());
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'MAJOR'");
        Worker t = new Worker();
        t.setThreadId((int)t.getId());
        t.setHiveConf(this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean();
        AtomicBoolean looped = new AtomicBoolean();
        stop.set(true);
        t.init(stop, looped);
        t.run();
        int[][] tableData2 = new int[][]{{1, 7}, {5, 6}, {7, 8}, {9, 10}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData2));
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain delete from " + (Object)((Object)Table.ACIDTBL) + " where a=7 and b=8");
            TestTxnCommands2.assertExplainHasString("filterExpr: ((a = 7) and (b = 8))", explain, "PPD wasn't pushed");
        }
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a=7 and b=8");
        query = "select a,b from " + (Object)((Object)Table.ACIDTBL) + " where a > 1 order by a,b";
        if (enablePPD) {
            explain = this.runStatementOnDriver("explain " + query);
            TestTxnCommands2.assertExplainHasString("filterExpr: (a > 1)", explain, "PPD wasn't pushed");
        }
        List<String> rs1 = this.runStatementOnDriver(query);
        int[][] resultData = new int[][]{{3, 5}, {5, 6}, {9, 10}};
        Assert.assertEquals((String)"Update failed", TestTxnCommands2.stringifyValues(resultData), rs1);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER, originalPpd);
    }

    static void assertExplainHasString(String string, List<String> queryPlan, String errMsg) {
        for (String line : queryPlan) {
            if (line == null || !line.contains(string)) continue;
            return;
        }
        Assert.assertFalse((String)errMsg, (boolean)true);
    }

    @Test
    public void testAlterTable() throws Exception {
        int[][] tableData = new int[][]{{1, 2}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'MAJOR'");
        Worker t = new Worker();
        t.setThreadId((int)t.getId());
        t.setHiveConf(this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean();
        AtomicBoolean looped = new AtomicBoolean();
        stop.set(true);
        t.init(stop, looped);
        t.run();
        int[][] tableData2 = new int[][]{{5, 6}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " where b > 0 order by a,b");
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " add columns(c int)");
        int[][] moreTableData = new int[][]{{7, 8, 9}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b,c) " + this.makeValuesClause(moreTableData));
        List<String> rs0 = this.runStatementOnDriver("select a,b,c from " + (Object)((Object)Table.ACIDTBL) + " where a > 0 order by a,b,c");
    }

    @Test
    public void testNonAcidInsert() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(2,3)");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
    }

    @Test
    public void testOriginalFileReaderWhenNonAcidConvertedToAcid() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2),(3,4),(5,6),(7,8),(9,10)");
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " SET TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("update " + (Object)((Object)Table.NONACIDORCTBL) + " set b = b*2 where b in (4,10)");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.NONACIDORCTBL) + " where a = 7");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL) + " order by a,b");
        int[][] resultData = new int[][]{{1, 2}, {3, 8}, {5, 6}, {9, 20}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.NONACIDORCTBL) + " where a = 1");
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL) + " order by a,b");
        resultData = new int[][]{{3, 8}, {5, 6}, {9, 20}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
    }

    @Test
    public void testBICompactedNoStripes() throws Exception {
        this.hiveConf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "BI");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((long)0L, (long)rs.size());
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(3,4)");
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        resultData = new int[][]{{3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((long)0L, (long)rs.size());
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(3,4)");
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        resultData = new int[][]{{3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((long)0L, (long)rs.size());
        this.hiveConf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "HYBRID");
    }

    @Test
    public void testETLCompactedNoStripes() throws Exception {
        this.hiveConf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "ETL");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((long)0L, (long)rs.size());
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(3,4)");
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        resultData = new int[][]{{3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((long)0L, (long)rs.size());
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)1L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertTrue((boolean)((ShowCompactResponseElement)resp.getCompacts().get(0)).getHadoopJobId().startsWith("job_local"));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(3,4)");
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        resultData = new int[][]{{3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((long)0L, (long)rs.size());
        this.hiveConf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "HYBRID");
    }

    @Ignore
    public void testNonAcidToAcidConversion02() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2),(1,3)");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(0,12),(0,13),(1,4),(1,5)");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,6)");
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " SET TBLPROPERTIES ('transactional'='true')");
        List<String> rs1 = this.runStatementOnDriver("describe " + (Object)((Object)Table.NONACIDORCTBL));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(0,15),(1,16)");
        this.runStatementOnDriver("update " + (Object)((Object)Table.NONACIDORCTBL) + " set b = 120 where a = 0 and b = 12");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(0,17)");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.NONACIDORCTBL) + " where a = 1 and b = 3");
        List<String> rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from " + (Object)((Object)Table.NONACIDORCTBL) + " order by a,b");
        LOG.warn("before compact");
        for (String s : rs) {
            LOG.warn(s);
        }
        String[][] expected = new String[][]{{"{\"transactionid\":0,\"bucketid\":0,\"rowid\":0}\t0\t13", "bucket_00000"}, {"{\"transactionid\":1,\"bucketid\":0,\"rowid\":0}\t0\t15", "bucket_00000"}, {"{\"transactionid\":3,\"bucketid\":0,\"rowid\":0}\t0\t17", "bucket_00000"}, {"{\"transactionid\":0,\"bucketid\":0,\"rowid\":1}\t0\t120", "bucket_00000"}, {"{\"transactionid\":0,\"bucketid\":1,\"rowid\":1}\t1\t2", "bucket_00001"}, {"{\"transactionid\":0,\"bucketid\":1,\"rowid\":3}\t1\t4", "bucket_00001"}, {"{\"transactionid\":0,\"bucketid\":1,\"rowid\":2}\t1\t5", "bucket_00001"}, {"{\"transactionid\":0,\"bucketid\":1,\"rowid\":4}\t1\t6", "bucket_00001"}, {"{\"transactionid\":1,\"bucketid\":1,\"rowid\":0}\t1\t16", "bucket_00001"}};
        Assert.assertEquals((String)"Unexpected row count before compaction", (long)expected.length, (long)rs.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((String)("Actual line " + i + " bc: " + rs.get(i)), (boolean)rs.get(i).startsWith(expected[i][0]));
        }
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        rs = this.runStatementOnDriver("select ROW__ID, a, b, INPUT__FILE__NAME from " + (Object)((Object)Table.NONACIDORCTBL) + " order by a,b");
        LOG.warn("after compact");
        for (String s : rs) {
            LOG.warn(s);
        }
        Assert.assertEquals((String)"Unexpected row count after compaction", (long)expected.length, (long)rs.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertTrue((String)("Actual line " + i + " ac: " + rs.get(i)), (boolean)rs.get(i).startsWith(expected[i][0]));
            Assert.assertTrue((String)("Actual line(bucket) " + i + " ac: " + rs.get(i)), (boolean)rs.get(i).endsWith(expected[i][1]));
        }
    }

    @Test
    public void testNonAcidToAcidConversion1() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        FileStatus[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " SET TBLPROPERTIES ('transactional'='true')");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(3,4)");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < status.length; ++i) {
            if (status[i].getPath().getName().matches("delta_.*")) {
                sawNewDelta = true;
                FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Assert.assertEquals((long)BUCKET_COUNT, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
                continue;
            }
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        Assert.assertTrue((boolean)sawNewDelta);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)BUCKET_COUNT, (long)buckets.length);
            Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
            Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        String fakeFile0 = TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase() + "/subdir/000000_0";
        String fakeFile1 = TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase() + "/subdir/000000_1";
        fs.create(new Path(fakeFile0));
        fs.create(new Path(fakeFile1));
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)5L, (long)status.length);
        TestTxnCommands2.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
        FileStatus[] buckets = fs.listStatus(status[0].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)buckets.length);
        Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
        Assert.assertTrue((boolean)buckets[1].getPath().getName().matches("bucket_0000[01]"));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    @Test
    public void testNonAcidToAcidConversion2() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        FileStatus[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " SET TBLPROPERTIES ('transactional'='true')");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("update " + (Object)((Object)Table.NONACIDORCTBL) + " set b=3 where a=1");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < status.length; ++i) {
            if (status[i].getPath().getName().matches("delta_.*")) {
                sawNewDelta = true;
                FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                continue;
            }
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        Assert.assertTrue((boolean)sawNewDelta);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
            Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00001"));
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        TestTxnCommands2.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
        FileStatus[] buckets = fs.listStatus(status[0].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
        Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00001"));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    @Test
    public void testNonAcidToAcidConversion3() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        Object[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " SET TBLPROPERTIES ('transactional'='true')");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            Assert.assertEquals((Object)"base_-9223372036854775808", (Object)status[i].getPath().getName());
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
            Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("update " + (Object)((Object)Table.NONACIDORCTBL) + " set b=3 where a=1");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(3,4)");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Arrays.sort(status);
        Assert.assertEquals((long)5L, (long)status.length);
        int numDelta = 0;
        sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            Object[] buckets;
            if (status[i].getPath().getName().matches("delta_.*")) {
                buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Arrays.sort(buckets);
                if (++numDelta == 1) {
                    Assert.assertEquals((Object)"delta_0000001_0000001_0000", (Object)status[i].getPath().getName());
                    Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
                    Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                    continue;
                }
                if (numDelta != 2) continue;
                Assert.assertEquals((Object)"delta_0000002_0000002_0000", (Object)status[i].getPath().getName());
                Assert.assertEquals((long)BUCKET_COUNT, (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00000", (Object)buckets[0].getPath().getName());
                Assert.assertEquals((Object)"bucket_00001", (Object)buckets[1].getPath().getName());
                continue;
            }
            if (status[i].getPath().getName().matches("base_.*")) {
                Assert.assertEquals((Object)"base_-9223372036854775808", (Object)status[i].getPath().getName());
                sawNewBase = true;
                buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                continue;
            }
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        Assert.assertEquals((long)2L, (long)numDelta);
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.NONACIDORCTBL) + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Arrays.sort(status);
        Assert.assertEquals((long)6L, (long)status.length);
        int numBase = 0;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            Object[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
            Arrays.sort(buckets);
            if (++numBase == 1) {
                Assert.assertEquals((Object)"base_-9223372036854775808", (Object)status[i].getPath().getName());
                Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                continue;
            }
            if (numBase != 2) continue;
            Assert.assertEquals((Object)"base_0000002", (Object)status[i].getPath().getName());
            Assert.assertEquals((long)BUCKET_COUNT, (long)buckets.length);
            Assert.assertEquals((Object)"bucket_00000", (Object)buckets[0].getPath().getName());
            Assert.assertEquals((Object)"bucket_00001", (Object)buckets[1].getPath().getName());
        }
        Assert.assertEquals((long)2L, (long)numBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)6L, (long)status.length);
        TestTxnCommands2.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertEquals((Object)"base_0000002", (Object)status[0].getPath().getName());
        Object[] buckets = fs.listStatus(status[0].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
        Arrays.sort(buckets);
        Assert.assertEquals((long)BUCKET_COUNT, (long)buckets.length);
        Assert.assertEquals((Object)"bucket_00000", (Object)buckets[0].getPath().getName());
        Assert.assertEquals((Object)"bucket_00001", (Object)buckets[1].getPath().getName());
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    @Test
    public void testValidTxnsBookkeeping() throws Exception {
        this.runStatementOnDriver("select * from " + (Object)((Object)Table.NONACIDORCTBL));
        String value = this.hiveConf.get("hive.txn.valid.txns");
        Assert.assertNull((String)"The entry should be null for query that doesn't involve ACID tables", (Object)value);
        this.runStatementOnDriver("select * from " + (Object)((Object)Table.ACIDTBL));
        value = this.hiveConf.get("hive.txn.valid.txns");
        Assert.assertNotNull((String)"The entry shouldn't be null for query that involves ACID tables", (Object)value);
    }

    @Test
    public void testSimpleRead() throws Exception {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEFETCHTASKCONVERSION, "more");
        int[][] tableData = new int[][]{{1, 2}, {3, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(tableData));
        int[][] tableData2 = new int[][]{{5, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(tableData2));
        this.hiveConf.set("hive.txn.valid.txns", "0:");
        List<String> rs = this.runStatementOnDriver("select * from " + (Object)((Object)Table.ACIDTBL));
        Assert.assertEquals((String)"Missing data", (long)3L, (long)rs.size());
    }

    @Test
    public void testUpdateMixedCase() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set B = 7 where A=1");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 3}, {5, 3}};
        Assert.assertEquals((String)"Update failed", TestTxnCommands2.stringifyValues(updatedData), rs);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set B = B + 1 where A=1");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData2 = new int[][]{{1, 8}, {3, 3}, {5, 3}};
        Assert.assertEquals((String)"Update failed", TestTxnCommands2.stringifyValues(updatedData2), rs2);
    }

    @Test
    public void testDeleteIn() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 2}, {5, 2}, {1, 3}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,7),(3,7)");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a in(select a from " + (Object)((Object)Table.NONACIDORCTBL) + ")");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 7}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update failed", TestTxnCommands2.stringifyValues(updatedData), rs);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set b=19 where b in(select b from " + (Object)((Object)Table.NONACIDORCTBL) + " where a = 3)");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData2 = new int[][]{{1, 19}, {3, 19}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update2 failed", TestTxnCommands2.stringifyValues(updatedData2), rs2);
    }

    @Test
    public void updateDeletePartitioned() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " partition(p=1) (a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " partition(p=2) (a,b) " + this.makeValuesClause(tableData));
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.hiveConf);
        txnHandler.compact(new CompactionRequest("default", Table.ACIDTBLPART.name(), CompactionType.MAJOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBLPART) + " set b = b + 1 where a = 3");
        txnHandler.compact(new CompactionRequest("default", Table.ACIDTBLPART.toString(), CompactionType.MAJOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        List<String> rs = this.runStatementOnDriver("select p,a,b from " + (Object)((Object)Table.ACIDTBLPART) + " order by p, a, b");
        int[][] expectedData = new int[][]{{1, 1, 2}, {1, 3, 5}, {1, 5, 6}, {2, 1, 2}, {2, 3, 5}, {2, 5, 6}};
        Assert.assertEquals((String)("Update " + (Object)((Object)Table.ACIDTBLPART) + " didn't match:"), TestTxnCommands2.stringifyValues(expectedData), rs);
    }

    @Test
    public void testBucketizedInputFormat() throws Exception {
        int[][] tableData = new int[][]{{1, 2}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " partition(p=1) (a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) select a,b from " + (Object)((Object)Table.ACIDTBLPART) + " where p = 1");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL));
        Assert.assertEquals((String)("Insert into " + (Object)((Object)Table.ACIDTBL) + " didn't match:"), TestTxnCommands2.stringifyValues(tableData), rs);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) select a,b from " + (Object)((Object)Table.ACIDTBLPART) + " where p = 1");
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        Assert.assertEquals((String)("Insert into " + (Object)((Object)Table.NONACIDORCTBL) + " didn't match:"), TestTxnCommands2.stringifyValues(tableData), rs2);
    }

    @Test
    public void testInsertOverwriteWithSelfJoin() throws Exception {
        int[][] part1Data = new int[][]{{1, 7}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) " + this.makeValuesClause(part1Data));
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)Table.NONACIDORCTBL) + " select 2, 9 from " + (Object)((Object)Table.NONACIDORCTBL) + " T inner join " + (Object)((Object)Table.NONACIDORCTBL) + " S on T.a=S.a");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL) + " order by a,b");
        int[][] joinData = new int[][]{{2, 9}};
        Assert.assertEquals((String)"Self join non-part insert overwrite failed", TestTxnCommands2.stringifyValues(joinData), rs);
        int[][] part2Data = new int[][]{{1, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART) + " partition(p=1) (a,b) " + this.makeValuesClause(part1Data));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART) + " partition(p=2) (a,b) " + this.makeValuesClause(part2Data));
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)Table.NONACIDPART) + " partition(p=1) select a,b from " + (Object)((Object)Table.NONACIDPART));
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDPART) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {1, 8}, {1, 8}};
        Assert.assertEquals((String)"Insert overwrite partition failed", TestTxnCommands2.stringifyValues(updatedData), rs2);
    }

    private static void checkCompactionState(CompactionsByState expected, CompactionsByState actual) {
        Assert.assertEquals((String)"attempted", (long)expected.attempted, (long)actual.attempted);
        Assert.assertEquals((String)"failed", (long)expected.failed, (long)actual.failed);
        Assert.assertEquals((String)"initiated", (long)expected.initiated, (long)actual.initiated);
        Assert.assertEquals((String)"ready for cleaning", (long)expected.readyToClean, (long)actual.readyToClean);
        Assert.assertEquals((String)"succeeded", (long)expected.succeeded, (long)actual.succeeded);
        Assert.assertEquals((String)"working", (long)expected.working, (long)actual.working);
        Assert.assertEquals((String)"total", (long)expected.total, (long)actual.total);
    }

    @Test
    public void testInitiatorWithMultipleFailedCompactions() throws Exception {
        this.testInitiatorWithMultipleFailedCompactionsForVariousTblProperties("'transactional'='true'");
    }

    void testInitiatorWithMultipleFailedCompactionsForVariousTblProperties(String tblProperties) throws Exception {
        String tblName = "hive12353";
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING)  CLUSTERED BY(a) INTO 1 BUCKETS STORED AS ORC  TBLPROPERTIES ( " + tblProperties + " )");
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELTA_NUM_THRESHOLD, 4);
        for (int i = 0; i < 5; ++i) {
            this.runStatementOnDriver("insert into " + tblName + " values(" + (i + 1) + ", 'foo'),(" + (i + 2) + ", 'bar'),(" + (i + 3) + ", 'baz')");
        }
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION, true);
        int numFailedCompactions = this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean(true);
        for (int i = 0; i < numFailedCompactions; ++i) {
            txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
            TestTxnCommands2.runWorker(this.hiveConf);
        }
        Initiator init = new Initiator();
        init.setThreadId((int)init.getId());
        init.setHiveConf(this.hiveConf);
        init.init(stop, new AtomicBoolean());
        init.run();
        int numAttemptedCompactions = 1;
        TestTxnCommands2.checkCompactionState(new CompactionsByState(numAttemptedCompactions, numFailedCompactions, 0, 0, 0, 0, numFailedCompactions + numAttemptedCompactions), TestTxnCommands2.countCompacts(txnHandler));
        this.hiveConf.setTimeVar(HiveConf.ConfVars.COMPACTOR_HISTORY_REAPER_INTERVAL, 10L, TimeUnit.MILLISECONDS);
        AcidCompactionHistoryService compactionHistoryService = new AcidCompactionHistoryService();
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)compactionHistoryService, this.hiveConf);
        TestTxnCommands2.checkCompactionState(new CompactionsByState(numAttemptedCompactions, numFailedCompactions, 0, 0, 0, 0, numFailedCompactions + numAttemptedCompactions), TestTxnCommands2.countCompacts(txnHandler));
        txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MAJOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
        TestTxnCommands2.runWorker(this.hiveConf);
        init.run();
        ++numAttemptedCompactions;
        init.run();
        TestTxnCommands2.checkCompactionState(new CompactionsByState(++numAttemptedCompactions, numFailedCompactions + 2, 0, 0, 0, 0, numFailedCompactions + 2 + numAttemptedCompactions), TestTxnCommands2.countCompacts(txnHandler));
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)compactionHistoryService, this.hiveConf);
        TestTxnCommands2.checkCompactionState(new CompactionsByState(this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_ATTEMPTED), this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), 0, 0, 0, 0, this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_ATTEMPTED)), TestTxnCommands2.countCompacts(txnHandler));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION, false);
        txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
        TestTxnCommands2.checkCompactionState(new CompactionsByState(this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_ATTEMPTED), this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), 1, 0, 0, 0, this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_ATTEMPTED) + 1), TestTxnCommands2.countCompacts(txnHandler));
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.checkCompactionState(new CompactionsByState(this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_ATTEMPTED), this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), 0, 1, 0, 0, this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_ATTEMPTED) + 1), TestTxnCommands2.countCompacts(txnHandler));
        TestTxnCommands2.runCleaner(this.hiveConf);
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)compactionHistoryService, this.hiveConf);
        TestTxnCommands2.checkCompactionState(new CompactionsByState(this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_ATTEMPTED), this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED), 0, 0, 1, 0, this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + this.hiveConf.getIntVar(HiveConf.ConfVars.COMPACTOR_HISTORY_RETENTION_ATTEMPTED) + 1), TestTxnCommands2.countCompacts(txnHandler));
    }

    @Test
    public void testFileSystemUnCaching() throws Exception {
        int cacheSizeBefore = this.getFileSystemCacheSize();
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'major'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        int cacheSizeAfter = this.getFileSystemCacheSize();
        Assert.assertEquals((long)cacheSizeBefore, (long)cacheSizeAfter);
    }

    private int getFileSystemCacheSize() throws Exception {
        try {
            Field cache = FileSystem.class.getDeclaredField("CACHE");
            cache.setAccessible(true);
            Object o = cache.get(null);
            Field mapField = o.getClass().getDeclaredField("map");
            mapField.setAccessible(true);
            HashMap map = (HashMap)mapField.get(o);
            return map.size();
        }
        catch (NoSuchFieldException e) {
            System.out.println(e);
            return 0;
        }
    }

    private static CompactionsByState countCompacts(TxnStore txnHandler) throws MetaException {
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        CompactionsByState compactionsByState = new CompactionsByState();
        compactionsByState.total = resp.getCompactsSize();
        for (ShowCompactResponseElement compact : resp.getCompacts()) {
            if ("failed".equals(compact.getState())) {
                compactionsByState.failed++;
                continue;
            }
            if ("ready for cleaning".equals(compact.getState())) {
                compactionsByState.readyToClean++;
                continue;
            }
            if ("initiated".equals(compact.getState())) {
                compactionsByState.initiated++;
                continue;
            }
            if ("succeeded".equals(compact.getState())) {
                compactionsByState.succeeded++;
                continue;
            }
            if ("working".equals(compact.getState())) {
                compactionsByState.working++;
                continue;
            }
            if ("attempted".equals(compact.getState())) {
                compactionsByState.attempted++;
                continue;
            }
            throw new IllegalStateException("Unexpected state: " + compact.getState());
        }
        return compactionsByState;
    }

    public static void runWorker(HiveConf hiveConf) throws MetaException {
        AtomicBoolean stop = new AtomicBoolean(true);
        Worker t = new Worker();
        t.setThreadId((int)t.getId());
        t.setHiveConf(hiveConf);
        AtomicBoolean looped = new AtomicBoolean();
        t.init(stop, looped);
        t.run();
    }

    public static void runCleaner(HiveConf hiveConf) throws MetaException {
        AtomicBoolean stop = new AtomicBoolean(true);
        Cleaner t = new Cleaner();
        t.setThreadId((int)t.getId());
        t.setHiveConf(hiveConf);
        AtomicBoolean looped = new AtomicBoolean();
        t.init(stop, looped);
        t.run();
    }

    public static void runHouseKeeperService(HouseKeeperService houseKeeperService, HiveConf conf) throws Exception {
        int lastCount = houseKeeperService.getIsAliveCounter();
        houseKeeperService.start(conf);
        int maxIter = 10;
        int iterCount = 0;
        while (houseKeeperService.getIsAliveCounter() <= lastCount) {
            if (iterCount++ >= maxIter) {
                throw new IllegalStateException("HouseKeeper didn't run after " + (iterCount - 1) + " waits");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        houseKeeperService.stop();
    }

    @Test
    public void writeBetweenWorkerAndCleaner() throws Exception {
        this.writeBetweenWorkerAndCleanerForVariousTblProperties("'transactional'='true'");
    }

    protected void writeBetweenWorkerAndCleanerForVariousTblProperties(String tblProperties) throws Exception {
        String tblName = "hive12352";
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING)  CLUSTERED BY(a) INTO 1 BUCKETS STORED AS ORC  TBLPROPERTIES ( " + tblProperties + " )");
        this.runStatementOnDriver("insert into " + tblName + " values(1, 'foo'),(2, 'bar'),(3, 'baz')");
        this.runStatementOnDriver("update " + tblName + " set b = 'blah' where a = 3");
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.hiveConf);
        txnHandler.compact(new CompactionRequest("default", tblName, CompactionType.MINOR));
        Worker t = new Worker();
        t.setThreadId((int)t.getId());
        t.setHiveConf(this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean(true);
        AtomicBoolean looped = new AtomicBoolean();
        t.init(stop, looped);
        t.run();
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, true);
        this.runStatementOnDriver("delete from " + tblName + " where a = 1");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, false);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1\tfoo");
        expected.add("2\tbar");
        expected.add("3\tblah");
        Assert.assertEquals((String)"", expected, this.runStatementOnDriver("select a,b from " + tblName + " order by a"));
        Cleaner c = new Cleaner();
        c.setThreadId((int)c.getId());
        c.setHiveConf(this.hiveConf);
        c.init(stop, new AtomicBoolean());
        c.run();
        Initiator i = new Initiator();
        i.setThreadId((int)i.getId());
        i.setHiveConf(this.hiveConf);
        i.init(stop, new AtomicBoolean());
        i.run();
        Assert.assertEquals((String)"", expected, this.runStatementOnDriver("select a,b from " + tblName + " order by a"));
    }

    @Test
    public void testFailHeartbeater() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILHEARTBEATER, true);
        RuntimeException exception = null;
        try {
            this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(new int[][]{{1, 2}, {3, 4}}));
        }
        catch (RuntimeException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        Assert.assertTrue((boolean)exception.getMessage().contains("HIVETESTMODEFAILHEARTBEATER=true"));
    }

    @Test
    public void testOpenTxnsCounter() throws Exception {
        this.hiveConf.setIntVar(HiveConf.ConfVars.HIVE_MAX_OPEN_TXNS, 3);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_COUNT_OPEN_TXNS_INTERVAL, 10L, TimeUnit.MILLISECONDS);
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.hiveConf);
        OpenTxnsResponse openTxnsResponse = txnHandler.openTxns(new OpenTxnRequest(3, "me", "localhost"));
        AcidOpenTxnsCounterService openTxnsCounterService = new AcidOpenTxnsCounterService();
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)openTxnsCounterService, this.hiveConf);
        MetaException exception = null;
        try {
            txnHandler.openTxns(new OpenTxnRequest(1, "you", "localhost"));
        }
        catch (MetaException e) {
            exception = e;
        }
        Assert.assertNotNull((String)"Opening new transaction shouldn't be allowed", (Object)((Object)exception));
        Assert.assertTrue((boolean)exception.getMessage().equals("Maximum allowed number of open transactions has been reached. See hive.max.open.txns."));
        Iterator e = openTxnsResponse.getTxn_ids().iterator();
        while (e.hasNext()) {
            long txnid = (Long)e.next();
            txnHandler.commitTxn(new CommitTxnRequest(txnid));
        }
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)openTxnsCounterService, this.hiveConf);
        exception = null;
        try {
            txnHandler.openTxns(new OpenTxnRequest(1, "him", "localhost"));
        }
        catch (MetaException e2) {
            exception = e2;
        }
        Assert.assertNull((Object)((Object)exception));
    }

    @Test
    public void testCompactWithDelete() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'MAJOR'");
        Worker t = new Worker();
        t.setThreadId((int)t.getId());
        t.setHiveConf(this.hiveConf);
        AtomicBoolean stop = new AtomicBoolean();
        AtomicBoolean looped = new AtomicBoolean();
        stop.set(true);
        t.init(stop, looped);
        t.run();
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where b = 4");
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set b = -2 where b = 2");
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'MINOR'");
        t.run();
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.hiveConf);
        ShowCompactResponse resp = txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)"Unexpected number of compactions in history", (long)2L, (long)resp.getCompactsSize());
        Assert.assertEquals((String)"Unexpected 0 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(0)).getState());
        Assert.assertEquals((String)"Unexpected 1 compaction state", (Object)"ready for cleaning", (Object)((ShowCompactResponseElement)resp.getCompacts().get(1)).getState());
    }

    @Test
    public void testNoHistory() throws Exception {
        int[][] tableData = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, true);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, false);
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.ACIDTBL));
    }

    @Test
    public void testACIDwithSchemaEvolutionAndCompaction() throws Exception {
        this.testACIDwithSchemaEvolutionForVariousTblProperties("'transactional'='true'");
    }

    protected void testACIDwithSchemaEvolutionForVariousTblProperties(String tblProperties) throws Exception {
        String tblName = "acidWithSchemaEvol";
        int numBuckets = 1;
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING)  CLUSTERED BY(a) INTO " + numBuckets + " BUCKETS STORED AS ORC  TBLPROPERTIES ( " + tblProperties + " )");
        this.runStatementOnDriver("insert into " + tblName + " values(1, 'foo'),(2, 'bar'),(3, 'baz')");
        this.runStatementOnDriver("update " + tblName + " set b = 'blah' where a = 3");
        this.runStatementOnDriver("alter table " + tblName + " add columns(c int, d string)");
        this.runStatementOnDriver("insert into " + tblName + " values(4, 'acid', 100, 'orc'),(5, 'llap', 200, 'tez')");
        this.runStatementOnDriver("update " + tblName + " set d = 'hive' where a <= 3");
        this.runStatementOnDriver("update " + tblName + " set c = 999 where a <= 3");
        List<String> rs = this.runStatementOnDriver("select * from " + tblName + " order by a");
        String[] expectedResult = new String[]{"1\tfoo\t999\thive", "2\tbar\t999\thive", "3\tblah\t999\thive", "4\tacid\t100\torc", "5\tllap\t200\ttez"};
        Assert.assertEquals(Arrays.asList(expectedResult), rs);
        this.runStatementOnDriver("alter table " + tblName + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        TestTxnCommands2.runCleaner(this.hiveConf);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + tblName.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)numBuckets, (long)buckets.length);
            Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00000"));
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select * from " + tblName + " order by a");
        Assert.assertEquals(Arrays.asList(expectedResult), rs);
    }

    @Test
    public void testETLSplitStrategyForACID() throws Exception {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY, "ETL");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVEOPTINDEXFILTER, true);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " values(1,2)");
        this.runStatementOnDriver("alter table " + (Object)((Object)Table.ACIDTBL) + " compact 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        List<String> rs = this.runStatementOnDriver("select * from " + (Object)((Object)Table.ACIDTBL) + " where a = 1");
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(resultData), rs);
    }

    @Test
    public void testAcidWithSchemaEvolution() throws Exception {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY, "ETL");
        String tblName = "acidTblWithSchemaEvol";
        this.runStatementOnDriver("drop table if exists " + tblName);
        this.runStatementOnDriver("CREATE TABLE " + tblName + "(a INT, b STRING)  CLUSTERED BY(a) INTO 2 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("INSERT INTO " + tblName + " VALUES (1, 'foo'), (2, 'bar')");
        this.runStatementOnDriver("ALTER TABLE " + tblName + " COMPACT 'MAJOR'");
        TestTxnCommands2.runWorker(this.hiveConf);
        this.runStatementOnDriver("ALTER TABLE " + tblName + " ADD COLUMNS(c int)");
        List<String> rs = this.runStatementOnDriver("SELECT * FROM " + tblName + " ORDER BY a");
        String[] expectedResult = new String[]{"1\tfoo\tNULL", "2\tbar\tNULL"};
        Assert.assertEquals(Arrays.asList(expectedResult), rs);
    }

    @Test
    public void testMultiInsertStatement() throws Exception {
        int[][] sourceValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] sourceValsEven = new int[][]{{2, 2}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART2) + " PARTITION(p2='odd') " + this.makeValuesClause(sourceValsOdd));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART2) + " PARTITION(p2='even') " + this.makeValuesClause(sourceValsEven));
        int[][] targetValsOdd = new int[][]{{5, 6}, {7, 8}};
        int[][] targetValsEven = new int[][]{{2, 1}, {4, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " PARTITION(p='odd') " + this.makeValuesClause(targetValsOdd));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " PARTITION(p='even') " + this.makeValuesClause(targetValsEven));
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBLPART) + " order by a,b");
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(targetVals), r);
        String s = "from " + (Object)((Object)Table.ACIDTBLPART) + "  target right outer join " + (Object)((Object)Table.NONACIDPART2) + " source on target.a = source.a2  INSERT INTO TABLE " + (Object)((Object)Table.ACIDTBLPART) + " PARTITION(p='even') select source.a2, source.b2 where source.a2=target.a  insert into table " + (Object)((Object)Table.ACIDTBLPART) + " PARTITION(p='odd') select source.a2,source.b2 where target.a is null";
        this.runStatementOnDriver(s);
        r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBLPART) + " where p='even' order by a,b");
        int[][] rExpected = new int[][]{{2, 1}, {2, 2}, {4, 3}, {5, 5}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
        r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBLPART) + " where p='odd' order by a,b");
        int[][] rExpected2 = new int[][]{{5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected2), r);
    }

    private void logResuts(List<String> r, String header, String prefix) {
        LOG.info(prefix + " " + header);
        StringBuilder sb = new StringBuilder();
        int numLines = 0;
        for (String line : r) {
            ++numLines;
            sb.append(prefix).append(line).append("\n");
        }
        LOG.info(sb.toString());
        LOG.info(prefix + " Printed " + numLines + " lines");
    }

    @Test
    public void testMerge() throws Exception {
        int[][] baseValsOdd = new int[][]{{5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART2) + " PARTITION(p2='odd') " + this.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(vals));
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(vals), r);
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " using " + (Object)((Object)Table.NONACIDPART2) + " source ON " + (Object)((Object)Table.ACIDTBL) + ".a = a2 and b + 1 = source.b2 + 1 WHEN MATCHED THEN UPDATE set b = source.b2 WHEN NOT MATCHED THEN INSERT VALUES(source.a2, source.b2)";
        this.runStatementOnDriver(query);
        r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{2, 1}, {4, 3}, {5, 5}, {5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeWithPredicate() throws Exception {
        int[][] baseValsOdd = new int[][]{{2, 2}, {5, 5}, {8, 8}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART2) + " PARTITION(p2='odd') " + this.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(vals));
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(vals), r);
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " t using " + (Object)((Object)Table.NONACIDPART2) + " s ON t.a = s.a2 WHEN MATCHED AND t.b between 1 and 3 THEN UPDATE set b = s.b2 WHEN NOT MATCHED and s.b2 >= 11 THEN INSERT VALUES(s.a2, s.b2)";
        this.runStatementOnDriver(query);
        r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{2, 2}, {4, 3}, {5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    @Test
    public void testMerge2() throws Exception {
        int[][] baseValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] baseValsEven = new int[][]{{2, 2}, {4, 44}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART2) + " PARTITION(p2='odd') " + this.makeValuesClause(baseValsOdd));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART2) + " PARTITION(p2='even') " + this.makeValuesClause(baseValsEven));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(vals));
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(vals), r);
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " using " + (Object)((Object)Table.NONACIDPART2) + " source ON " + (Object)((Object)Table.ACIDTBL) + ".a = source.a2 WHEN MATCHED THEN UPDATE set b = source.b2 WHEN NOT MATCHED THEN INSERT VALUES(source.a2, source.b2) ";
        r = this.runStatementOnDriver(query);
        r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{2, 2}, {4, 44}, {5, 5}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    @Test
    public void testMerge3() throws Exception {
        int[][] baseValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] baseValsEven = new int[][]{{2, 2}, {4, 44}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART2) + " PARTITION(p2='odd') " + this.makeValuesClause(baseValsOdd));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDPART2) + " PARTITION(p2='even') " + this.makeValuesClause(baseValsEven));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(vals));
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(vals), r);
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " using " + (Object)((Object)Table.NONACIDPART2) + " source ON " + (Object)((Object)Table.ACIDTBL) + ".a = source.a2 WHEN MATCHED THEN DELETE WHEN NOT MATCHED THEN INSERT VALUES(source.a2, source.b2) ";
        this.runStatementOnDriver(query);
        r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    @Ignore
    @Test
    public void testMultiInsert() throws Exception {
        this.runStatementOnDriver("create table if not exists  srcpart (a int, b int, c int) partitioned by (z int) clustered by (a) into 2 buckets stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("create temporary table if not exists data1 (x int)");
        this.runStatementOnDriver("insert into data1 values (1),(2),(3)");
        this.d.destroy();
        this.hiveConf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        this.d = new Driver(this.hiveConf);
        List<String> r = this.runStatementOnDriver(" from data1 insert into srcpart partition(z) select 0,0,1,x  insert into srcpart partition(z=1) select 0,0,1");
    }

    @Test
    @Ignore
    public void testDynamicPartitions() throws Exception {
        this.d.destroy();
        this.hiveConf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1'),(4,4,'p2')");
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.ACIDTBLPART));
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " partition(p) select * from " + (Object)((Object)Table.ACIDTBLPART) + " where p='p1'");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " partition(p='p2') select a,b from " + (Object)((Object)Table.ACIDTBLPART) + " where p='p1'");
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBLPART) + " set b = 1");
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBLPART) + " set b = 1 where p='p1'");
    }

    @Test
    public void testDynamicPartitionsMerge() throws Exception {
        this.d.destroy();
        this.hiveConf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1'),(4,4,'p2')");
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.ACIDTBLPART));
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        int[][] sourceVals = new int[][]{{2, 15}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + " " + this.makeValuesClause(sourceVals));
        this.runStatementOnDriver("merge into " + (Object)((Object)Table.ACIDTBLPART) + " using " + (Object)((Object)Table.NONACIDORCTBL) + " as s ON " + (Object)((Object)Table.ACIDTBLPART) + ".a = s.a when matched then update set b = s.b when not matched then insert values(s.a, s.b, 'new part')");
        r1 = this.runStatementOnDriver("select p,a,b from " + (Object)((Object)Table.ACIDTBLPART) + " order by p, a, b");
        String result = r1.toString();
        Assert.assertEquals((Object)"[new part\t5\t5, new part\t11\t11, p1\t1\t1, p1\t2\t15, p1\t3\t3, p2\t4\t44]", (Object)result);
    }

    @Test
    public void testDynamicPartitionsMerge2() throws Exception {
        this.d.destroy();
        this.hiveConf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        int[][] targetVals = new int[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 1}, {4, 4, 2}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDNESTEDPART) + " partition(p=1,q) " + this.makeValuesClause(targetVals));
        List<String> r1 = this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.ACIDNESTEDPART));
        Assert.assertEquals((Object)"4", (Object)r1.get(0));
        int[][] sourceVals = new int[][]{{2, 15}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + " " + this.makeValuesClause(sourceVals));
        this.runStatementOnDriver("merge into " + (Object)((Object)Table.ACIDNESTEDPART) + " using " + (Object)((Object)Table.NONACIDORCTBL) + " as s ON " + (Object)((Object)Table.ACIDNESTEDPART) + ".a = s.a when matched then update set b = s.b when not matched then insert values(s.a, s.b, 3,4)");
        r1 = this.runStatementOnDriver("select p,q,a,b from " + (Object)((Object)Table.ACIDNESTEDPART) + " order by p,q, a, b");
        Assert.assertEquals(TestTxnCommands2.stringifyValues(new int[][]{{1, 1, 1, 1}, {1, 1, 3, 3}, {1, 2, 2, 15}, {1, 2, 4, 44}, {3, 4, 5, 5}, {3, 4, 11, 11}}), r1);
    }

    @Ignore(value="Covered elsewhere")
    @Test
    public void testMergeAliasedTarget() throws Exception {
        int[][] baseValsOdd = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + " " + this.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(vals));
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " as target using " + (Object)((Object)Table.NONACIDORCTBL) + " source ON target.a = source.a WHEN MATCHED THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(source.a, source.b) ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{2, 0}, {4, 0}, {5, 0}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    @Test
    @Ignore(value="Values clause with table constructor not yet supported")
    public void testValuesSource() throws Exception {
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(targetVals));
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " as t using (select * from (values (2,2),(4,44),(5,5),(11,11)) as F(a,b)) s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(TestTxnCommands2.stringifyValues(rExpected), r);
    }

    static List<String> stringifyValues(int[][] rowsIn) {
        assert (rowsIn.length > 0);
        int[][] rows = (int[][])rowsIn.clone();
        Arrays.sort(rows, new RowComp());
        ArrayList<String> rs = new ArrayList<String>();
        for (int[] row : rows) {
            assert (row.length > 0);
            StringBuilder sb = new StringBuilder();
            for (int value : row) {
                sb.append(value).append("\t");
            }
            sb.setLength(sb.length() - 1);
            rs.add(sb.toString());
        }
        return rs;
    }

    String makeValuesClause(int[][] rows) {
        assert (rows.length > 0);
        StringBuilder sb = new StringBuilder("values");
        for (int[] row : rows) {
            assert (row.length > 0);
            if (row.length > 1) {
                sb.append("(");
            }
            for (int value : row) {
                sb.append(value).append(",");
            }
            sb.setLength(sb.length() - 1);
            if (row.length > 1) {
                sb.append(")");
            }
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    protected List<String> runStatementOnDriver(String stmt) throws Exception {
        LOG.info("+runStatementOnDriver(" + stmt + ")");
        CommandProcessorResponse cpr = this.d.run(stmt);
        if (cpr.getResponseCode() != 0) {
            throw new RuntimeException(stmt + " failed: " + cpr);
        }
        ArrayList<String> rs = new ArrayList<String>();
        this.d.getResults(rs);
        return rs;
    }

    private static final class RowComp
    implements Comparator<int[]> {
        private RowComp() {
        }

        @Override
        public int compare(int[] row1, int[] row2) {
            assert (row1 != null && row2 != null && row1.length == row2.length);
            for (int i = 0; i < row1.length; ++i) {
                int comp = Integer.compare(row1[i], row2[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    private static class CompactionsByState {
        private int attempted;
        private int failed;
        private int initiated;
        private int readyToClean;
        private int succeeded;
        private int working;
        private int total;

        CompactionsByState() {
            this(0, 0, 0, 0, 0, 0, 0);
        }

        CompactionsByState(int attempted, int failed, int initiated, int readyToClean, int succeeded, int working, int total) {
            this.attempted = attempted;
            this.failed = failed;
            this.initiated = initiated;
            this.readyToClean = readyToClean;
            this.succeeded = succeeded;
            this.working = working;
            this.total = total;
        }
    }

    protected static enum Table {
        ACIDTBL("acidTbl"),
        ACIDTBLPART("acidTblPart"),
        NONACIDORCTBL("nonAcidOrcTbl"),
        NONACIDPART("nonAcidPart"),
        NONACIDPART2("nonAcidPart2"),
        ACIDNESTEDPART("acidNestedPart");

        private final String name;

        public String toString() {
            return this.name;
        }

        private Table(String name) {
            this.name = name;
        }
    }
}

