/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class CastStringToLong
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    int inputColumn;
    int outputColumn;
    private transient boolean integerPrimitiveCategoryKnown = false;
    protected transient PrimitiveObjectInspector.PrimitiveCategory integerPrimitiveCategory;

    public CastStringToLong(int inputColumn, int outputColumn) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
    }

    public CastStringToLong() {
    }

    /*
     * Unable to fully structure code
     */
    protected void func(LongColumnVector outV, BytesColumnVector inV, int batchIndex) {
        bytes = inV.vector[batchIndex];
        start = inV.start[batchIndex];
        length = inV.length[batchIndex];
        try {
            switch (1.$SwitchMap$org$apache$hadoop$hive$serde2$objectinspector$PrimitiveObjectInspector$PrimitiveCategory[this.integerPrimitiveCategory.ordinal()]) {
                case 1: {
                    i = start;
                    if (length != 4) ** GOTO lbl15
                    if (bytes[i] != 84 && bytes[i] != 116 || bytes[i + 1] != 82 && bytes[i + 1] != 114 || bytes[i + 2] != 85 && bytes[i + 2] != 117 || bytes[i + 3] != 69 && bytes[i + 3] != 101) ** GOTO lbl12
                    booleanValue = true;
                    ** GOTO lbl36
lbl12:
                    // 1 sources

                    outV.noNulls = false;
                    outV.isNull[batchIndex] = true;
                    return;
lbl15:
                    // 1 sources

                    if (length != 5) ** GOTO lbl22
                    if (bytes[i] != 70 && bytes[i] != 102 || bytes[i + 1] != 65 && bytes[i + 1] != 97 || bytes[i + 2] != 76 && bytes[i + 2] != 108 || bytes[i + 3] != 83 && bytes[i + 3] != 115 || bytes[i + 4] != 69 && bytes[i + 4] != 101) ** GOTO lbl19
                    booleanValue = false;
                    ** GOTO lbl36
lbl19:
                    // 1 sources

                    outV.noNulls = false;
                    outV.isNull[batchIndex] = true;
                    return;
lbl22:
                    // 1 sources

                    if (length != 1) ** GOTO lbl33
                    b = bytes[start];
                    if (b == 49 || b == 116 || b == 84) {
                        booleanValue = true;
                    } else if (b == 48 || b == 102 || b == 70) {
                        booleanValue = false;
                    } else {
                        outV.noNulls = false;
                        outV.isNull[batchIndex] = true;
                        return;
lbl33:
                        // 1 sources

                        outV.noNulls = false;
                        outV.isNull[batchIndex] = true;
                        return;
                    }
lbl36:
                    // 4 sources

                    outV.vector[batchIndex] = booleanValue != false ? 1 : 0;
                    break;
                }
                case 2: {
                    if (!LazyUtils.isNumberMaybe((byte[])bytes, (int)start, (int)length)) {
                        outV.noNulls = false;
                        outV.isNull[batchIndex] = true;
                        return;
                    }
                    outV.vector[batchIndex] = LazyByte.parseByte((byte[])bytes, (int)start, (int)length, (int)10);
                    break;
                }
                case 3: {
                    if (!LazyUtils.isNumberMaybe((byte[])bytes, (int)start, (int)length)) {
                        outV.noNulls = false;
                        outV.isNull[batchIndex] = true;
                        return;
                    }
                    outV.vector[batchIndex] = LazyShort.parseShort((byte[])bytes, (int)start, (int)length, (int)10);
                    break;
                }
                case 4: {
                    if (!LazyUtils.isNumberMaybe((byte[])bytes, (int)start, (int)length)) {
                        outV.noNulls = false;
                        outV.isNull[batchIndex] = true;
                        return;
                    }
                    outV.vector[batchIndex] = LazyInteger.parseInt((byte[])bytes, (int)start, (int)length, (int)10);
                    break;
                }
                case 5: {
                    if (!LazyUtils.isNumberMaybe((byte[])bytes, (int)start, (int)length)) {
                        outV.noNulls = false;
                        outV.isNull[batchIndex] = true;
                        return;
                    }
                    outV.vector[batchIndex] = LazyLong.parseLong((byte[])bytes, (int)start, (int)length, (int)10);
                    break;
                }
                default: {
                    throw new Error("Unexpected primitive category " + this.integerPrimitiveCategory);
                }
            }
        }
        catch (Exception e) {
            outV.noNulls = false;
            outV.isNull[batchIndex] = true;
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (!this.integerPrimitiveCategoryKnown) {
            String typeName = this.getOutputType().toLowerCase();
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
            this.integerPrimitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
            this.integerPrimitiveCategoryKnown = true;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inV = (BytesColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        boolean[] inputIsNull = inV.isNull;
        boolean[] outputIsNull = outV.isNull;
        if (n == 0) {
            return;
        }
        outV.isRepeating = false;
        if (inV.isRepeating) {
            if (inV.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.func(outV, inV, 0);
            } else {
                outputIsNull[0] = true;
                outV.noNulls = false;
            }
            outV.isRepeating = true;
            return;
        }
        if (inV.noNulls) {
            if (batch.selectedInUse) {
                if (!outV.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.func(outV, inV, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.func(outV, inV, i);
                    }
                }
            } else {
                if (!outV.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outV.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.func(outV, inV, i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inV.isNull[i]) {
                    outV.isNull[i] = false;
                    this.func(outV, inV, i);
                    continue;
                }
                outV.isNull[i] = true;
                outV.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inV.isNull[i]) {
                    outV.isNull[i] = false;
                    this.func(outV, inV, i);
                    continue;
                }
                outV.isNull[i] = true;
                outV.noNulls = false;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getInputColumn() {
        return this.inputColumn;
    }

    public void setInputColumn(int inputColumn) {
        this.inputColumn = inputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

