/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.BasePartitionEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestGenericUDAFEvaluator {
    @Mock(answer=Answers.CALLS_REAL_METHODS)
    private GenericUDAFEvaluator udafEvaluator;
    @Mock
    private WindowFrameDef winFrame;
    @Mock
    private PTFPartition partition1;
    @Mock
    private ObjectInspector outputOI;
    private List<PTFExpressionDef> parameters = Collections.emptyList();

    @Test
    public void testGetPartitionWindowingEvaluatorWithoutInitCall() {
        BasePartitionEvaluator partition1Evaluator1 = this.udafEvaluator.getPartitionWindowingEvaluator(this.winFrame, this.partition1, this.parameters, this.outputOI);
        BasePartitionEvaluator partition1Evaluator2 = this.udafEvaluator.getPartitionWindowingEvaluator(this.winFrame, this.partition1, this.parameters, this.outputOI);
        Assert.assertEquals((Object)partition1Evaluator1, (Object)partition1Evaluator2);
    }

    @Test
    public void testGetPartitionWindowingEvaluatorWithInitCall() throws HiveException {
        BasePartitionEvaluator partition1Evaluator1 = this.udafEvaluator.getPartitionWindowingEvaluator(this.winFrame, this.partition1, this.parameters, this.outputOI);
        this.udafEvaluator.init(GenericUDAFEvaluator.Mode.COMPLETE, null);
        BasePartitionEvaluator newPartitionEvaluator = this.udafEvaluator.getPartitionWindowingEvaluator(this.winFrame, this.partition1, this.parameters, this.outputOI);
        Assert.assertNotEquals((Object)partition1Evaluator1, (Object)newPartitionEvaluator);
    }
}

