/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.HadoopDefaultMetastoreAuthenticator;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;
import org.apache.hadoop.hive.ql.security.authorization.StorageBasedAuthorizationProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestStorageBasedAuthorizationProviderWarehouse {
    @Test
    public void testWarehouseUpdate() throws HiveException {
        String testWarehouseDir = System.getProperty("test.warehouse.dir");
        HiveConf.ConfVars warehouse = HiveConf.ConfVars.METASTOREWAREHOUSE;
        StorageBasedAuthorizationProvider sbap = new StorageBasedAuthorizationProvider();
        HiveConf metastoreConf = new HiveConf();
        sbap.setConf((Configuration)metastoreConf);
        sbap.setAuthenticator((HiveAuthenticationProvider)new HadoopDefaultMetastoreAuthenticator());
        Privilege[] privileges = new Privilege[1];
        Privilege privilege = new Privilege();
        privilege.setPriv(PrivilegeType.SELECT);
        privileges[0] = privilege;
        Database db = new Database();
        db.setName("default");
        HiveConf.setVar((Configuration)metastoreConf, (HiveConf.ConfVars)warehouse, (String)(testWarehouseDir + "/test1"));
        sbap.authorize(privileges, privileges);
        MatcherAssert.assertThat((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(sbap.getDbLocation(db).toString()), (Matcher)CoreMatchers.is((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(HiveConf.getVar((Configuration)metastoreConf, (HiveConf.ConfVars)warehouse))));
        HiveConf.setVar((Configuration)metastoreConf, (HiveConf.ConfVars)warehouse, (String)(testWarehouseDir + "/test2"));
        sbap.authorize(privileges, privileges);
        MatcherAssert.assertThat((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(sbap.getDbLocation(db).toString()), (Matcher)CoreMatchers.is((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(HiveConf.getVar((Configuration)metastoreConf, (HiveConf.ConfVars)warehouse))));
        HiveConf.setVar((Configuration)metastoreConf, (HiveConf.ConfVars)warehouse, (String)(testWarehouseDir + "/test3"));
        sbap.authorize(privileges, privileges);
        MatcherAssert.assertThat((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(sbap.getDbLocation(db).toString()), (Matcher)CoreMatchers.is((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(HiveConf.getVar((Configuration)metastoreConf, (HiveConf.ConfVars)warehouse))));
    }

    private static String normalize(String path) {
        return path.replace("///", "/").replace("//", "/");
    }
}

