/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.junit.Assert;
import org.junit.Test;

public class TestSplitSample {
    private static final int SEED_NUM = 123;
    private static final double PERCENT = 2.0;
    private static final long TOTAL_LENGTH = 1000L;
    private static final int ROW_COUNT = 5;
    private SplitSample splitSample;

    @Test
    public void testGetTargetSizeTotalLength() {
        this.splitSample = new SplitSample(1000L, 123);
        Assert.assertEquals((long)1000L, (long)this.splitSample.getTargetSize(1000L));
        Assert.assertEquals((long)1000L, (long)this.splitSample.getTargetSize(100L));
    }

    @Test
    public void testGetTargetSizePercent() {
        this.splitSample = new SplitSample(2.0, 123);
        Assert.assertEquals((long)20L, (long)this.splitSample.getTargetSize(1000L));
    }

    @Test
    public void testEstimateSourceSizeTotalLength() {
        this.splitSample = new SplitSample(1000L, 123);
        Assert.assertEquals((long)10L, (long)this.splitSample.estimateSourceSize(10L));
    }

    @Test
    public void testEstimateSourceSizeRowCount() {
        this.splitSample = new SplitSample(5);
        Assert.assertEquals((long)123L, (long)this.splitSample.estimateSourceSize(123L));
    }

    @Test
    public void testEstimateSourceSizePercent() {
        this.splitSample = new SplitSample(2.0, 123);
        Assert.assertEquals((long)500L, (long)this.splitSample.estimateSourceSize(10L));
    }
}

