/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.sql.Date;
import java.util.HashMap;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestSemanticAnalyzer {
    @Test
    public void testNormalizeColSpec() throws Exception {
        this.checkNormalization("date", "2010-01-01", "2010-01-01", Date.valueOf("2010-01-01"));
        this.checkNormalization("date", "2010-1-01", "2010-01-01", Date.valueOf("2010-01-01"));
        this.checkNormalization("date", "2010-1-1", "2010-01-01", Date.valueOf("2010-01-01"));
        this.checkNormalization("string", "2010-1-1", "2010-1-1", "2010-1-1");
        try {
            this.checkNormalization("date", "foo", "", "foo");
            Assert.fail((String)"should throw");
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        try {
            this.checkNormalization("date", "2010-01-01", "2010-01-01", "2010-01-01");
            Assert.fail((String)"should throw");
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    public void checkNormalization(String colType, String originalColSpec, String result, Object colValue) throws SemanticException {
        String colName = "col";
        HashMap<String, String> partSpec = new HashMap<String, String>();
        partSpec.put("col", originalColSpec);
        BaseSemanticAnalyzer.normalizeColSpec(partSpec, (String)"col", (String)colType, (String)originalColSpec, (Object)colValue);
        Assert.assertEquals((Object)result, partSpec.get("col"));
        if (colValue instanceof Date) {
            DateWritable dw = new DateWritable((Date)colValue);
            BaseSemanticAnalyzer.normalizeColSpec(partSpec, (String)"col", (String)colType, (String)originalColSpec, (Object)dw);
            Assert.assertEquals((Object)result, partSpec.get("col"));
        }
    }

    @Test
    public void testUnescapeSQLString() {
        Assert.assertEquals((Object)"abcdefg", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"abcdefg\""));
        Assert.assertEquals((Object)"C0FFEE", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'C0FFEE'"));
        Assert.assertEquals((Object)"\u0000", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\0'"));
        Assert.assertEquals((Object)"'", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\'\""));
        Assert.assertEquals((Object)"\"", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\\"'"));
        Assert.assertEquals((Object)"\b", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\b\""));
        Assert.assertEquals((Object)"\n", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\n'"));
        Assert.assertEquals((Object)"\r", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\r\""));
        Assert.assertEquals((Object)"\t", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\t'"));
        Assert.assertEquals((Object)"\u001a", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\Z\""));
        Assert.assertEquals((Object)"\\", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\\\'"));
        Assert.assertEquals((Object)"\\%", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\%\""));
        Assert.assertEquals((Object)"\\_", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\_'"));
        Assert.assertEquals((Object)"3 + 5 = 8", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'3 + 5 = \\070'"));
        Assert.assertEquals((Object)"\u0000", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\000\""));
        Assert.assertEquals((Object)"256", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\256\""));
        Assert.assertEquals((Object)"How cute \u732b are", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"How cute \\u732B are\""));
        Assert.assertEquals((Object)"\ud867\ude3d is a fish", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\uD867\ude3d is a fish\""));
    }
}

