/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.Arrays;
import java.util.Properties;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestGenMapRedUtilsUsePartitionColumnsPositive {
    @Parameterized.Parameter(value=0)
    public String inPartColNames;
    @Parameterized.Parameter(value=1)
    public String inPartColTypes;
    @Parameterized.Parameter(value=2)
    public String partNamesToRetain;
    @Parameterized.Parameter(value=3)
    public String expectedPartColNames;
    @Parameterized.Parameter(value=4)
    public String expectedPartColTypes;

    @Parameterized.Parameters(name="{index}: updatePartitions({2})")
    public static Iterable<Object[]> testCases() {
        return Arrays.asList({"p1/p2/p3", "t1:t2:t3", "p2", "p2", "t2"}, {"p1/p2/p3", "t1:t2:t3", "p2,p3", "p2/p3", "t2:t3"}, {"p1/p2/p3", "t1:t2:t3", "p1,p2,p3", "p1/p2/p3", "t1:t2:t3"}, {"p1/p2/p3", "t1:t2:t3", "p1,p3", "p1/p3", "t1:t3"}, {"p1", "t1", "p1", "p1", "t1"}, {"p1/p2/p3", "t1:t2:t3", "p3,p2,p1", "p3/p2/p1", "t3:t2:t1"});
    }

    @Test
    public void testUsePartitionColumns() {
        Properties p = new Properties();
        p.setProperty("partition_columns", this.inPartColNames);
        p.setProperty("partition_columns.types", this.inPartColTypes);
        GenMapRedUtils.usePartitionColumns((Properties)p, Arrays.asList(this.partNamesToRetain.split(",")));
        String actualNames = p.getProperty("partition_columns");
        String actualTypes = p.getProperty("partition_columns.types");
        Assert.assertEquals((Object)this.expectedPartColNames, (Object)actualNames);
        Assert.assertEquals((Object)this.expectedPartColTypes, (Object)actualTypes);
    }
}

