/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.MoveTask;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestGenMapRedUtilsCreateConditionalTask {
    private static HiveConf hiveConf;
    private Task dummyMRTask;

    @BeforeClass
    public static void initializeSessionState() {
        hiveConf = new HiveConf();
    }

    @Before
    public void setUp() {
        this.dummyMRTask = new MapRedTask();
    }

    @Test
    public void testMovePathsThatCannotBeMerged() {
        Path condInputPath = new Path("s3a://bucket/scratch/-ext-10000");
        Path condOutputPath = new Path("s3a://bucket/scratch/-ext-10002");
        MoveWork mockWork = (MoveWork)Mockito.mock(MoveWork.class);
        Assert.assertFalse((String)"A MoveWork null object cannot be merged.", (boolean)GenMapRedUtils.shouldMergeMovePaths((HiveConf)hiveConf, (Path)condInputPath, (Path)condOutputPath, null));
        hiveConf.set(HiveConf.ConfVars.HIVE_BLOBSTORE_OPTIMIZATIONS_ENABLED.varname, "false");
        Assert.assertFalse((String)"Merging paths is not allowed when BlobStorage optimizations are disabled.", (boolean)GenMapRedUtils.shouldMergeMovePaths((HiveConf)hiveConf, (Path)condInputPath, (Path)condOutputPath, (MoveWork)mockWork));
        hiveConf.set(HiveConf.ConfVars.HIVE_BLOBSTORE_OPTIMIZATIONS_ENABLED.varname, "true");
        Mockito.reset((Object[])new MoveWork[]{mockWork});
        Mockito.when((Object)mockWork.getLoadMultiFilesWork()).thenReturn((Object)new LoadMultiFilesDesc());
        Assert.assertFalse((String)"Merging paths is not allowed when MultiFileWork is found in the MoveWork object.", (boolean)GenMapRedUtils.shouldMergeMovePaths((HiveConf)hiveConf, (Path)condInputPath, (Path)condOutputPath, (MoveWork)mockWork));
        Mockito.reset((Object[])new MoveWork[]{mockWork});
        Mockito.when((Object)mockWork.getLoadFileWork()).thenReturn(Mockito.mock(LoadFileDesc.class));
        Mockito.when((Object)mockWork.getLoadTableWork()).thenReturn(Mockito.mock(LoadTableDesc.class));
        Assert.assertFalse((String)"Merging paths is not allowed when both LoadFileWork & LoadTableWork are found in the MoveWork object.", (boolean)GenMapRedUtils.shouldMergeMovePaths((HiveConf)hiveConf, (Path)condInputPath, (Path)condOutputPath, (MoveWork)mockWork));
        Mockito.reset((Object[])new MoveWork[]{mockWork});
        Mockito.when((Object)mockWork.getLoadFileWork()).thenReturn((Object)new LoadFileDesc(condInputPath, condOutputPath, false, "", ""));
        Assert.assertFalse((String)"Merging paths is not allowed when both conditional output path is not equals to MoveWork input path.", (boolean)GenMapRedUtils.shouldMergeMovePaths((HiveConf)hiveConf, (Path)condInputPath, (Path)condOutputPath, (MoveWork)mockWork));
        Mockito.reset((Object[])new MoveWork[]{mockWork});
        Mockito.when((Object)mockWork.getLoadFileWork()).thenReturn((Object)new LoadFileDesc(condOutputPath, new Path("unused"), false, "", ""));
        Assert.assertFalse((String)"Merging paths is not allowed when conditional input path is not a BlobStore path.", (boolean)GenMapRedUtils.shouldMergeMovePaths((HiveConf)hiveConf, (Path)new Path("hdfs://hdfs-path"), (Path)condOutputPath, (MoveWork)mockWork));
        Mockito.reset((Object[])new MoveWork[]{mockWork});
        Mockito.when((Object)mockWork.getLoadFileWork()).thenReturn((Object)new LoadFileDesc(condOutputPath, new Path("hdfs://hdfs-path"), false, "", ""));
        Assert.assertFalse((String)"Merging paths is not allowed when MoveWork output path is not a BlobStore path.", (boolean)GenMapRedUtils.shouldMergeMovePaths((HiveConf)hiveConf, (Path)condInputPath, (Path)condOutputPath, (MoveWork)mockWork));
    }

    @Test
    public void testMovePathsThatCanBeMerged() {
        Path condInputPath = new Path("s3a://bucket/scratch/-ext-10000");
        Path condOutputPath = new Path("s3a://bucket/scratch/-ext-10002");
        Path targetMoveWorkPath = new Path("s3a://bucket/scratch/-ext-10003");
        MoveWork mockWork = (MoveWork)Mockito.mock(MoveWork.class);
        Mockito.when((Object)mockWork.getLoadFileWork()).thenReturn((Object)new LoadFileDesc(condOutputPath, targetMoveWorkPath, false, "", ""));
        Assert.assertTrue((String)"Merging BlobStore paths should be allowed.", (boolean)GenMapRedUtils.shouldMergeMovePaths((HiveConf)hiveConf, (Path)condInputPath, (Path)condOutputPath, (MoveWork)mockWork));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMergePathWithInvalidMoveWorkThrowsException() {
        Path condInputPath = new Path("s3a://bucket/scratch/-ext-10000");
        MoveWork mockWork = (MoveWork)Mockito.mock(MoveWork.class);
        Mockito.when((Object)mockWork.getLoadMultiFilesWork()).thenReturn((Object)new LoadMultiFilesDesc());
        GenMapRedUtils.mergeMovePaths((Path)condInputPath, (MoveWork)mockWork);
    }

    @Test
    public void testMergePathValidMoveWorkReturnsNewMoveWork() {
        Path condInputPath = new Path("s3a://bucket/scratch/-ext-10000");
        Path condOutputPath = new Path("s3a://bucket/scratch/-ext-10002");
        Path targetMoveWorkPath = new Path("s3a://bucket/scratch/-ext-10003");
        MoveWork mockWork = (MoveWork)Mockito.mock(MoveWork.class);
        Mockito.when((Object)mockWork.getLoadFileWork()).thenReturn((Object)new LoadFileDesc(condOutputPath, targetMoveWorkPath, false, "", ""));
        MoveWork newWork = GenMapRedUtils.mergeMovePaths((Path)condInputPath, (MoveWork)mockWork);
        Assert.assertNotNull((Object)newWork);
        Assert.assertNotEquals((Object)newWork, (Object)mockWork);
        Assert.assertEquals((Object)condInputPath, (Object)newWork.getLoadFileWork().getSourcePath());
        Assert.assertEquals((Object)targetMoveWorkPath, (Object)newWork.getLoadFileWork().getTargetDir());
        TableDesc tableDesc = new TableDesc();
        Mockito.reset((Object[])new MoveWork[]{mockWork});
        Mockito.when((Object)mockWork.getLoadTableWork()).thenReturn((Object)new LoadTableDesc(condOutputPath, tableDesc, null));
        newWork = GenMapRedUtils.mergeMovePaths((Path)condInputPath, (MoveWork)mockWork);
        Assert.assertNotNull((Object)newWork);
        Assert.assertNotEquals((Object)newWork, (Object)mockWork);
        Assert.assertEquals((Object)condInputPath, (Object)newWork.getLoadTableWork().getSourcePath());
        Assert.assertTrue((boolean)newWork.getLoadTableWork().getTable().equals((Object)tableDesc));
    }

    @Test
    public void testConditionalMoveTaskIsOptimized() throws SemanticException {
        hiveConf.set(HiveConf.ConfVars.HIVE_BLOBSTORE_OPTIMIZATIONS_ENABLED.varname, "true");
        Path sinkDirName = new Path("s3a://bucket/scratch/-ext-10002");
        FileSinkOperator fileSinkOperator = this.createFileSinkOperator(sinkDirName);
        Path finalDirName = new Path("s3a://bucket/scratch/-ext-10000");
        Path tableLocation = new Path("s3a://bucket/warehouse/table");
        Task<MoveWork> moveTask = this.createMoveTask(finalDirName, tableLocation);
        List<Task> moveTaskList = Arrays.asList(moveTask);
        GenMapRedUtils.createMRWorkForMergingFiles((FileSinkOperator)fileSinkOperator, (Path)finalDirName, null, moveTaskList, (HiveConf)hiveConf, (Task)this.dummyMRTask);
        ConditionalTask conditionalTask = (ConditionalTask)this.dummyMRTask.getChildTasks().get(0);
        Task moveOnlyTask = (Task)conditionalTask.getListTasks().get(0);
        Task mergeOnlyTask = (Task)conditionalTask.getListTasks().get(1);
        Task mergeAndMoveTask = (Task)conditionalTask.getListTasks().get(2);
        Assert.assertNull((Object)moveOnlyTask.getChildTasks());
        this.verifyMoveTask((Task<? extends Serializable>)moveOnlyTask, sinkDirName, tableLocation);
        Assert.assertEquals((long)1L, (long)mergeOnlyTask.getChildTasks().size());
        this.verifyMoveTask((Task<? extends Serializable>)((Task)mergeOnlyTask.getChildTasks().get(0)), finalDirName, tableLocation);
        Assert.assertEquals((long)1L, (long)mergeAndMoveTask.getChildTasks().size());
        Assert.assertEquals((long)1L, (long)((Task)mergeAndMoveTask.getChildTasks().get(0)).getChildTasks().size());
        this.verifyMoveTask((Task<? extends Serializable>)((Task)mergeAndMoveTask.getChildTasks().get(0)), sinkDirName, finalDirName);
        this.verifyMoveTask((Task<? extends Serializable>)((Task)((Task)mergeAndMoveTask.getChildTasks().get(0)).getChildTasks().get(0)), finalDirName, tableLocation);
    }

    @Test
    public void testConditionalMoveTaskIsNotOptimized() throws SemanticException {
        hiveConf.set(HiveConf.ConfVars.HIVE_BLOBSTORE_OPTIMIZATIONS_ENABLED.varname, "false");
        Path sinkDirName = new Path("s3a://bucket/scratch/-ext-10002");
        FileSinkOperator fileSinkOperator = this.createFileSinkOperator(sinkDirName);
        Path finalDirName = new Path("s3a://bucket/scratch/-ext-10000");
        Path tableLocation = new Path("s3a://bucket/warehouse/table");
        Task<MoveWork> moveTask = this.createMoveTask(finalDirName, tableLocation);
        List<Task> moveTaskList = Arrays.asList(moveTask);
        GenMapRedUtils.createMRWorkForMergingFiles((FileSinkOperator)fileSinkOperator, (Path)finalDirName, null, moveTaskList, (HiveConf)hiveConf, (Task)this.dummyMRTask);
        ConditionalTask conditionalTask = (ConditionalTask)this.dummyMRTask.getChildTasks().get(0);
        Task moveOnlyTask = (Task)conditionalTask.getListTasks().get(0);
        Task mergeOnlyTask = (Task)conditionalTask.getListTasks().get(1);
        Task mergeAndMoveTask = (Task)conditionalTask.getListTasks().get(2);
        Assert.assertEquals((long)1L, (long)moveOnlyTask.getChildTasks().size());
        this.verifyMoveTask((Task<? extends Serializable>)moveOnlyTask, sinkDirName, finalDirName);
        this.verifyMoveTask((Task<? extends Serializable>)((Task)moveOnlyTask.getChildTasks().get(0)), finalDirName, tableLocation);
        Assert.assertEquals((long)1L, (long)mergeOnlyTask.getChildTasks().size());
        this.verifyMoveTask((Task<? extends Serializable>)((Task)mergeOnlyTask.getChildTasks().get(0)), finalDirName, tableLocation);
        Assert.assertEquals((long)1L, (long)mergeAndMoveTask.getChildTasks().size());
        Assert.assertEquals((long)1L, (long)((Task)mergeAndMoveTask.getChildTasks().get(0)).getChildTasks().size());
        this.verifyMoveTask((Task<? extends Serializable>)((Task)mergeAndMoveTask.getChildTasks().get(0)), sinkDirName, finalDirName);
        this.verifyMoveTask((Task<? extends Serializable>)((Task)((Task)mergeAndMoveTask.getChildTasks().get(0)).getChildTasks().get(0)), finalDirName, tableLocation);
    }

    @Test
    public void testConditionalMoveOnHdfsIsNotOptimized() throws SemanticException {
        hiveConf.set(HiveConf.ConfVars.HIVE_BLOBSTORE_OPTIMIZATIONS_ENABLED.varname, "true");
        Path sinkDirName = new Path("hdfs://bucket/scratch/-ext-10002");
        FileSinkOperator fileSinkOperator = this.createFileSinkOperator(sinkDirName);
        Path finalDirName = new Path("hdfs://bucket/scratch/-ext-10000");
        Path tableLocation = new Path("hdfs://bucket/warehouse/table");
        Task<MoveWork> moveTask = this.createMoveTask(finalDirName, tableLocation);
        List<Task> moveTaskList = Arrays.asList(moveTask);
        GenMapRedUtils.createMRWorkForMergingFiles((FileSinkOperator)fileSinkOperator, (Path)finalDirName, null, moveTaskList, (HiveConf)hiveConf, (Task)this.dummyMRTask);
        ConditionalTask conditionalTask = (ConditionalTask)this.dummyMRTask.getChildTasks().get(0);
        Task moveOnlyTask = (Task)conditionalTask.getListTasks().get(0);
        Task mergeOnlyTask = (Task)conditionalTask.getListTasks().get(1);
        Task mergeAndMoveTask = (Task)conditionalTask.getListTasks().get(2);
        Assert.assertEquals((long)1L, (long)moveOnlyTask.getChildTasks().size());
        this.verifyMoveTask((Task<? extends Serializable>)moveOnlyTask, sinkDirName, finalDirName);
        this.verifyMoveTask((Task<? extends Serializable>)((Task)moveOnlyTask.getChildTasks().get(0)), finalDirName, tableLocation);
        Assert.assertEquals((long)1L, (long)mergeOnlyTask.getChildTasks().size());
        this.verifyMoveTask((Task<? extends Serializable>)((Task)mergeOnlyTask.getChildTasks().get(0)), finalDirName, tableLocation);
        Assert.assertEquals((long)1L, (long)mergeAndMoveTask.getChildTasks().size());
        Assert.assertEquals((long)1L, (long)((Task)mergeAndMoveTask.getChildTasks().get(0)).getChildTasks().size());
        this.verifyMoveTask((Task<? extends Serializable>)((Task)mergeAndMoveTask.getChildTasks().get(0)), sinkDirName, finalDirName);
        this.verifyMoveTask((Task<? extends Serializable>)((Task)((Task)mergeAndMoveTask.getChildTasks().get(0)).getChildTasks().get(0)), finalDirName, tableLocation);
    }

    private FileSinkOperator createFileSinkOperator(Path finalDirName) {
        FileSinkOperator fileSinkOperator = (FileSinkOperator)Mockito.mock(FileSinkOperator.class);
        TableDesc tableDesc = new TableDesc(HiveInputFormat.class, HiveOutputFormat.class, new Properties());
        FileSinkDesc fileSinkDesc = new FileSinkDesc(finalDirName, tableDesc, false);
        fileSinkDesc.setDirName(finalDirName);
        Mockito.when((Object)fileSinkOperator.getConf()).thenReturn((Object)fileSinkDesc);
        Mockito.when((Object)fileSinkOperator.getSchema()).thenReturn(Mockito.mock(RowSchema.class));
        fileSinkDesc.setTableInfo(tableDesc);
        Mockito.when((Object)fileSinkOperator.getCompilationOpContext()).thenReturn(Mockito.mock(CompilationOpContext.class));
        return fileSinkOperator;
    }

    private Task<MoveWork> createMoveTask(Path source, Path destination) {
        Task moveTask = (Task)Mockito.mock(MoveTask.class);
        MoveWork moveWork = new MoveWork();
        moveWork.setLoadFileWork(new LoadFileDesc(source, destination, true, null, null));
        Mockito.when((Object)moveTask.getWork()).thenReturn((Object)moveWork);
        return moveTask;
    }

    private void verifyMoveTask(Task<? extends Serializable> task, Path source, Path target) {
        MoveTask moveTask = (MoveTask)task;
        Assert.assertEquals((Object)source, (Object)((MoveWork)moveTask.getWork()).getLoadFileWork().getSourcePath());
        Assert.assertEquals((Object)target, (Object)((MoveWork)moveTask.getWork()).getLoadFileWork().getTargetDir());
    }
}

