/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.sarg;

import com.google.common.collect.Sets;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetFilterPredicateConverter;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentImpl;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Test;

public class TestConvertAstToSearchArg {
    private final Configuration conf = new Configuration();

    private static void assertNoSharedNodes(ExpressionTree tree, Set<ExpressionTree> seen) throws Exception {
        if (seen.contains(tree) && tree.getOperator() != ExpressionTree.Operator.LEAF) {
            Assert.assertTrue((String)("repeated node in expression " + tree), (boolean)false);
        }
        seen.add(tree);
        if (tree.getChildren() != null) {
            for (ExpressionTree child : tree.getChildren()) {
                TestConvertAstToSearchArg.assertNoSharedNodes(child, seen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExprNodeGenericFuncDesc getFuncDesc(String xmlSerialized) {
        byte[] bytes;
        try {
            bytes = xmlSerialized.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 support required", ex);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (XMLDecoder decoder = new XMLDecoder(bais, null, null);){
            ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = (ExprNodeGenericFuncDesc)decoder.readObject();
            return exprNodeGenericFuncDesc;
        }
    }

    @Test
    public void testExpression1() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                          <void property=\"children\"> \n                           <object class=\"java.util.ArrayList\"> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                              <void property=\"children\"> \n                               <object class=\"java.util.ArrayList\"> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                                  <void property=\"column\"> \n                                   <string>first_name</string> \n                                  </void> \n                                  <void property=\"tabAlias\"> \n                                   <string>orc_people</string> \n                                  </void> \n                                  <void property=\"typeInfo\"> \n                                   <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                                    <void property=\"typeName\"> \n                                     <string>string</string> \n                                    </void> \n                                   </object> \n                                  </void> \n                                 </object> \n                                </void> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                                  <void property=\"typeInfo\"> \n                                   <object idref=\"PrimitiveTypeInfo0\"/> \n                                  </void> \n                                  <void property=\"value\"> \n                                   <string>john</string> \n                                  </void> \n                                 </object> \n                                </void> \n                               </object> \n                              </void> \n                              <void property=\"genericUDF\"> \n                               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n                              </void> \n                              <void property=\"typeInfo\"> \n                               <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                                <void property=\"typeName\"> \n                                 <string>boolean</string> \n                                </void> \n                               </object> \n                              </void> \n                             </object> \n                            </void> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                              <void property=\"children\"> \n                               <object class=\"java.util.ArrayList\"> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                                  <void property=\"typeInfo\"> \n                                   <object idref=\"PrimitiveTypeInfo0\"/> \n                                  </void> \n                                  <void property=\"value\"> \n                                   <string>greg</string> \n                                  </void> \n                                 </object> \n                                </void> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                                  <void property=\"column\"> \n                                   <string>first_name</string> \n                                  </void> \n                                  <void property=\"tabAlias\"> \n                                   <string>orc_people</string> \n                                  </void> \n                                  <void property=\"typeInfo\"> \n                                   <object idref=\"PrimitiveTypeInfo0\"/> \n                                  </void> \n                                 </object> \n                                </void> \n                               </object> \n                              </void> \n                              <void property=\"genericUDF\"> \n                               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                              </void> \n                              <void property=\"typeInfo\"> \n                               <object idref=\"PrimitiveTypeInfo1\"/> \n                              </void> \n                             </object> \n                            </void> \n                           </object> \n                          </void> \n                          <void property=\"genericUDF\"> \n                           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo1\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                          <void property=\"children\"> \n                           <object class=\"java.util.ArrayList\"> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                              <void property=\"typeInfo\"> \n                               <object idref=\"PrimitiveTypeInfo0\"/> \n                              </void> \n                              <void property=\"value\"> \n                               <string>alan</string> \n                              </void> \n                             </object> \n                            </void> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                              <void property=\"column\"> \n                               <string>first_name</string> \n                              </void> \n                              <void property=\"tabAlias\"> \n                               <string>orc_people</string> \n                              </void> \n                              <void property=\"typeInfo\"> \n                               <object idref=\"PrimitiveTypeInfo0\"/> \n                              </void> \n                             </object> \n                            </void> \n                           </object> \n                          </void> \n                          <void property=\"genericUDF\"> \n                           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan\"/> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo1\"/> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                            <void property=\"typeName\"> \n                             <string>int</string> \n                            </void> \n                           </object> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo2\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>12</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>13</int> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>id</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <int>15</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <int>16</int> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <int>30</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <string>owen</string> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n";
        SearchArgumentImpl sarg = (SearchArgumentImpl)ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)9, (int)leaves.size());
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        Object[] conditions = new String[]{"eq(first_name, Binary{\"john\"})", "not(lteq(first_name, Binary{\"greg\"}))", "lt(first_name, Binary{\"alan\"})", "not(lteq(id, 12))", "not(lteq(id, 13))", "lt(id, 15)", "lt(id, 16)", "eq(id, 30)", "eq(first_name, Binary{\"owen\"})"};
        String expected = String.format("and(or(or(or(or(or(or(or(%1$s, %2$s), %3$s), %4$s), %5$s), %6$s), %7$s), %8$s), or(or(or(or(or(or(or(%1$s, %2$s), %3$s), %4$s), %5$s), %6$s), %7$s), %9$s))", conditions);
        Assert.assertEquals((String)expected, (String)p.toString());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"john", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"greg", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"alan", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(3);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(4);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)13L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(5);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)15L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(6);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)16L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(7);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)30L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(8);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"owen", (Object)leaf.getLiteral());
        Assert.assertEquals((String)"(and (or leaf-0 (not leaf-1) leaf-2 (not leaf-3) (not leaf-4) leaf-5 leaf-6 leaf-7) (or leaf-0 (not leaf-1) leaf-2 (not leaf-3) (not leaf-4) leaf-5 leaf-6 leaf-8))", (String)sarg.getExpression().toString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
    }

    @Test
    public void testExpression2() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>first_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                    <void property=\"typeName\"> \n                     <string>string</string> \n                    </void> \n                   </object> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>boolean</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>first_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <string>sue</string> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>int</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <int>12</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n          <void property=\"value\"> \n           <int>4</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n";
        SearchArgumentImpl sarg = (SearchArgumentImpl)ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)4, (int)leaves.size());
        Object[] conditions = new String[]{"eq(first_name, null)", "not(eq(first_name, Binary{\"sue\"}))", "not(lt(id, 12))", "lteq(id, 4)"};
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = String.format("or(or(or(%1$s, %2$s), %3$s), %4$s)", conditions);
        Assert.assertEquals((String)expected, (String)p.toString());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IS_NULL, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals(null, (Object)leaf.getLiteral());
        Assert.assertEquals(null, (Object)leaf.getLiteralList());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"sue", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(3);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)4L, (Object)leaf.getLiteral());
        Assert.assertEquals((String)"(or leaf-0 (not leaf-1) (not leaf-2) leaf-3)", (String)sarg.getExpression().toString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES_NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES_NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES_NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES_NULL, SearchArgument.TruthValue.YES_NO_NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO_NULL, SearchArgument.TruthValue.YES_NO_NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
    }

    @Test
    public void testExpression3() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>boolean</string> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"value\"> \n                       <boolean>false</boolean> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>int</string> \n                        </void> \n                       </object> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>23</int> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>45</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>first_name</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>string</string> \n                        </void> \n                       </object> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <string>alan</string> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <string>xxxxx</string> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>3</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n                    <void property=\"udfClassName\"> \n                     <string>org.apache.hadoop.hive.ql.udf.UDFSubstr</string> \n                    </void> \n                    <void property=\"udfName\"> \n                     <string>substr</string> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>first_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <string>smith</string> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>last_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n              <void property=\"value\"> \n               <int>3</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n            <void property=\"udfClassName\"> \n             <string>org.apache.hadoop.hive.ql.udf.UDFSubstr</string> \n            </void> \n            <void property=\"udfName\"> \n             <string>substr</string> \n            </void> \n           </object> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n          <void property=\"value\"> \n           <string>yyy</string> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo0\"/> \n  </void> \n </object> \n</java> \n";
        SearchArgumentImpl sarg = (SearchArgumentImpl)ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)3, (int)leaves.size());
        Object[] conditions = new String[]{"lteq(id, 45)", "not(lt(id, 23))", "eq(first_name, Binary{\"alan\"})", "eq(last_name, Binary{\"smith\"})"};
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; required binary last_name;}");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = String.format("and(and(and(%1$s, %2$s), %3$s), %4$s)", conditions);
        Assert.assertEquals((String)expected, (String)p.toString());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.BETWEEN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals(null, (Object)leaf.getLiteral());
        Assert.assertEquals((Object)23L, leaf.getLiteralList().get(0));
        Assert.assertEquals((Object)45L, leaf.getLiteralList().get(1));
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"alan", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"last_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"smith", (Object)leaf.getLiteral());
        Assert.assertEquals((String)"(and leaf-0 leaf-1 leaf-2)", (String)sarg.getExpression().toString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
    }

    @Test
    public void testExpression4() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>int</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>12</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n            <void property=\"typeName\"> \n             <string>boolean</string> \n            </void> \n           </object> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>string</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <string>john</string> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <string>sue</string> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>34</int> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>50</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n\n";
        SearchArgumentImpl sarg = (SearchArgumentImpl)ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)3, (int)leaves.size());
        Object[] conditions = new String[]{"not(eq(id, 12))", "or(eq(first_name, Binary{\"john\"}), eq(first_name, Binary{\"sue\"}))", "or(eq(id, 34), eq(id, 50))"};
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = String.format("and(and(%1$s, %2$s), %3$s)", conditions);
        Assert.assertEquals((String)expected, (String)p.toString());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"first_name", (String)leaf.getColumnName());
        Assert.assertEquals((Object)"john", leaf.getLiteralList().get(0));
        Assert.assertEquals((Object)"sue", leaf.getLiteralList().get(1));
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)34L, leaf.getLiteralList().get(0));
        Assert.assertEquals((Object)50L, leaf.getLiteralList().get(1));
        Assert.assertEquals((String)"(and (not leaf-0) leaf-1 leaf-2)", (String)sarg.getExpression().toString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES_NULL, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES_NO_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO_NULL)));
    }

    @Test
    public void testExpression5() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>string</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <string>owen</string> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n            <void property=\"typeName\"> \n             <string>boolean</string> \n            </void> \n           </object> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <string>foobar</string> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>last_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                    <void property=\"typeName\"> \n                     <string>int</string> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"value\"> \n                   <int>4</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n                <void property=\"udfClassName\"> \n                 <string>org.apache.hadoop.hive.ql.udf.UDFSubstr</string> \n                </void> \n                <void property=\"udfName\"> \n                 <string>substr</string> \n                </void> \n               </object> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n          <void property=\"value\"> \n           <boolean>false</boolean> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>first_name</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <string>david</string> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <string>greg</string> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n";
        SearchArgumentImpl sarg = (SearchArgumentImpl)ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)1, (int)leaves.size());
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "and(lteq(first_name, Binary{\"greg\"}), not(lt(first_name, Binary{\"david\"})))";
        Assert.assertEquals((String)p.toString(), (String)expected);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)((PredicateLeaf)leaves.get(0)).getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.BETWEEN, (Object)((PredicateLeaf)leaves.get(0)).getOperator());
        Assert.assertEquals((String)"first_name", (String)((PredicateLeaf)leaves.get(0)).getColumnName());
        Assert.assertEquals((String)"leaf-0", (String)sarg.getExpression().toString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
    }

    @Test
    public void testExpression7() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                            <void property=\"typeName\"> \n                             <string>int</string> \n                            </void> \n                           </object> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>10</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>boolean</string> \n                        </void> \n                       </object> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>11</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>12</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>13</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>14</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>15</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>id</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <int>16</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>id</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <int>17</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>18</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object>\n</java>";
        SearchArgumentImpl sarg = (SearchArgumentImpl)ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)9, (int)leaves.size());
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "and(and(and(and(and(and(and(and(and(and(and(and(and(and(and(and(and(or(or(or(lt(id, 18), lt(id, 10)), lt(id, 13)), lt(id, 16)), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 13)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 13)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 10)), lt(id, 14)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 14)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 14)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 10)), lt(id, 15)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 15)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 15)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 10)), lt(id, 13)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 13)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 13)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 10)), lt(id, 14)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 14)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 14)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 10)), lt(id, 15)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 15)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 15)), lt(id, 17)))";
        Assert.assertEquals((String)p.toString(), (String)expected);
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)18L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)10L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)13L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(3);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)16L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(4);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)11L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(5);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(6);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)14L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(7);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)15L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(8);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((String)"id", (String)leaf.getColumnName());
        Assert.assertEquals((Object)17L, (Object)leaf.getLiteral());
        Assert.assertEquals((String)"(and (or leaf-0 leaf-1 leaf-2 leaf-3) (or leaf-0 leaf-4 leaf-2 leaf-3) (or leaf-0 leaf-5 leaf-2 leaf-3) (or leaf-0 leaf-1 leaf-6 leaf-3) (or leaf-0 leaf-4 leaf-6 leaf-3) (or leaf-0 leaf-5 leaf-6 leaf-3) (or leaf-0 leaf-1 leaf-7 leaf-3) (or leaf-0 leaf-4 leaf-7 leaf-3) (or leaf-0 leaf-5 leaf-7 leaf-3) (or leaf-0 leaf-1 leaf-2 leaf-8) (or leaf-0 leaf-4 leaf-2 leaf-8) (or leaf-0 leaf-5 leaf-2 leaf-8) (or leaf-0 leaf-1 leaf-6 leaf-8) (or leaf-0 leaf-4 leaf-6 leaf-8) (or leaf-0 leaf-5 leaf-6 leaf-8) (or leaf-0 leaf-1 leaf-7 leaf-8) (or leaf-0 leaf-4 leaf-7 leaf-8) (or leaf-0 leaf-5 leaf-7 leaf-8))", (String)sarg.getExpression().toString());
    }

    @Test
    public void testExpression8() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n      <void property=\"column\"> \n       <string>first_name</string> \n      </void> \n      <void property=\"tabAlias\"> \n       <string>orc_people</string> \n      </void> \n      <void property=\"typeInfo\"> \n       <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n        <void property=\"typeName\"> \n         <string>string</string> \n        </void> \n       </object> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n      <void property=\"column\"> \n       <string>last_name</string> \n      </void> \n      <void property=\"tabAlias\"> \n       <string>orc_people</string> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n    <void property=\"typeName\"> \n     <string>boolean</string> \n    </void> \n   </object> \n  </void> \n </object> \n</java> ";
        SearchArgumentImpl sarg = (SearchArgumentImpl)ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)0, (int)leaves.size());
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        Assert.assertNull((Object)p);
        Assert.assertEquals((String)"YES_NO_NULL", (String)sarg.getExpression().toString());
    }

    @Test
    public void testExpression9() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n      <void property=\"column\"> \n       <string>id</string> \n      </void> \n      <void property=\"tabAlias\"> \n       <string>orc_people</string> \n      </void> \n      <void property=\"typeInfo\"> \n       <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n        <void property=\"typeName\"> \n         <string>int</string> \n        </void> \n       </object> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>1</int> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>3</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n            <void property=\"operator\"> \n             <boolean>true</boolean> \n            </void> \n            <void property=\"udfClassName\"> \n             <string>org.apache.hadoop.hive.ql.udf.UDFOPPlus</string> \n            </void> \n            <void property=\"udfName\"> \n             <string>+</string> \n            </void> \n           </object> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>4</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n        <void property=\"operator\"> \n         <boolean>true</boolean> \n        </void> \n        <void property=\"udfClassName\"> \n         <string>org.apache.hadoop.hive.ql.udf.UDFOPPlus</string> \n        </void> \n        <void property=\"udfName\"> \n         <string>+</string> \n        </void> \n       </object> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n    <void property=\"typeName\"> \n     <string>boolean</string> \n    </void> \n   </object> \n  </void> \n </object> \n</java> ";
        SearchArgumentImpl sarg = (SearchArgumentImpl)ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)0, (int)leaves.size());
        Assert.assertEquals((String)"YES_NO_NULL", (String)sarg.getExpression().toString());
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(new SearchArgument.TruthValue[0])));
    }

    @Test
    public void testExpression10() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n            <void property=\"typeName\"> \n             <string>int</string> \n            </void> \n           </object> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>10</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n        <void property=\"typeName\"> \n         <string>boolean</string> \n        </void> \n       </object> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>10</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java>";
        SearchArgumentImpl sarg = (SearchArgumentImpl)ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        List leaves = sarg.getLeaves();
        Assert.assertEquals((int)1, (int)leaves.size());
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "and(not(lt(id, 10)), not(lt(id, 10)))";
        Assert.assertEquals((String)expected, (String)p.toString());
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)((PredicateLeaf)leaves.get(0)).getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)((PredicateLeaf)leaves.get(0)).getOperator());
        Assert.assertEquals((String)"id", (String)((PredicateLeaf)leaves.get(0)).getColumnName());
        Assert.assertEquals((Object)10L, (Object)((PredicateLeaf)leaves.get(0)).getLiteral());
        Assert.assertEquals((String)"(and (not leaf-0) (not leaf-0))", (String)sarg.getExpression().toString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES_NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES_NO_NULL)));
    }

    private static SearchArgument.TruthValue[] values(SearchArgument.TruthValue ... vals) {
        return vals;
    }

    @Test
    public void TestTimestampSarg() throws Exception {
        String serialAst = "AQEAamF2YS51dGlsLkFycmF5TGlz9AECAQFvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnBsYW4uRXhwck5vZGVDb2x1bW5EZXPjAQF08wAAAWJpZ29y4wECb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5zZXJkZTIudHlwZWluZm8uUHJpbWl0aXZlVHlwZUluZu8BAXRpbWVzdGFt8AEDb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5xbC5wbGFuLkV4cHJOb2RlQ29uc3RhbnREZXPjAQECAQFzdHJpbucDATIwMTUtMDMtMTcgMTI6MzQ6NbYBBG9yZy5hcGFjaGUuaGFkb29wLmhpdmUucWwudWRmLmdlbmVyaWMuR2VuZXJpY1VERk9QRXF1YewBAAABgj0BRVFVQcwBBW9yZy5hcGFjaGUuaGFkb29wLmlvLkJvb2xlYW5Xcml0YWJs5QEAAAECAQFib29sZWHu";
        SearchArgument sarg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst)).buildSearchArgument();
        Assert.assertEquals((String)"leaf-0", (String)sarg.getExpression().toString());
        Assert.assertEquals((int)1, (int)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.TIMESTAMP, (Object)leaf.getType());
        Assert.assertEquals((String)"(EQUALS ts 2015-03-17 12:34:56.0)", (String)leaf.toString());
    }

    @Test
    public void TestDateSarg() throws Exception {
        String serialAst = "AQEAamF2YS51dGlsLkFycmF5TGlz9AECAQFvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnBsYW4uRXhwck5vZGVDb2x1bW5EZXPjAQFk9AAAAWJpZ29y4wECb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5zZXJkZTIudHlwZWluZm8uUHJpbWl0aXZlVHlwZUluZu8BAWRhdOUBA29yZy5hcGFjaGUuaGFkb29wLmhpdmUucWwucGxhbi5FeHByTm9kZUNvbnN0YW50RGVz4wEBAgEBc3RyaW7nAwEyMDE1LTA1LTC1AQRvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnVkZi5nZW5lcmljLkdlbmVyaWNVREZPUEVxdWHsAQAAAYI9AUVRVUHMAQVvcmcuYXBhY2hlLmhhZG9vcC5pby5Cb29sZWFuV3JpdGFibOUBAAABAgEBYm9vbGVh7g==";
        SearchArgument sarg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst)).buildSearchArgument();
        Assert.assertEquals((String)"leaf-0", (String)sarg.getExpression().toString());
        Assert.assertEquals((int)1, (int)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.DATE, (Object)leaf.getType());
        Assert.assertEquals((String)"(EQUALS dt 2015-05-05)", (String)leaf.toString());
    }

    @Test
    public void TestDecimalSarg() throws Exception {
        String serialAst = "AQEAamF2YS51dGlsLkFycmF5TGlz9AECAQFvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnBsYW4uRXhwck5vZGVDb2x1bW5EZXPjAQFkZeMAAAFiaWdvcuMBAm9yZy5hcGFjaGUuaGFkb29wLmhpdmUuc2VyZGUyLnR5cGVpbmZvLkRlY2ltYWxUeXBlSW5m7wEUAAFkZWNpbWHsAQNvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnBsYW4uRXhwck5vZGVDb25zdGFudERlc+MBAQRvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnNlcmRlMi50eXBlaW5mby5QcmltaXRpdmVUeXBlSW5m7wEBaW70AvYBAQVvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnVkZi5nZW5lcmljLkdlbmVyaWNVREZPUEVxdWHsAQAAAYI9AUVRVUHMAQZvcmcuYXBhY2hlLmhhZG9vcC5pby5Cb29sZWFuV3JpdGFibOUBAAABBAEBYm9vbGVh7g==";
        SearchArgument sarg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst)).buildSearchArgument();
        Assert.assertEquals((String)"leaf-0", (String)sarg.getExpression().toString());
        Assert.assertEquals((int)1, (int)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.DECIMAL, (Object)leaf.getType());
        Assert.assertEquals((String)"(EQUALS dec 123)", (String)leaf.toString());
    }

    @Test
    public void TestCharSarg() throws Exception {
        String serialAst = "AQEAamF2YS51dGlsLkFycmF5TGlz9AECAQFvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnBsYW4uRXhwck5vZGVDb2x1bW5EZXPjAQFj6AAAAWJpZ29y4wECb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5zZXJkZTIudHlwZWluZm8uQ2hhclR5cGVJbmbvARQBY2hh8gEDb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5xbC5wbGFuLkV4cHJOb2RlQ29uc3RhbnREZXPjAQEEb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5zZXJkZTIudHlwZWluZm8uUHJpbWl0aXZlVHlwZUluZu8BAXN0cmlu5wMBY2hhciAgICAgoAEFb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5xbC51ZGYuZ2VuZXJpYy5HZW5lcmljVURGT1BFcXVh7AEAAAGCPQFFUVVBzAEGb3JnLmFwYWNoZS5oYWRvb3AuaW8uQm9vbGVhbldyaXRhYmzlAQAAAQQBAWJvb2xlYe4=";
        SearchArgument sarg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst)).buildSearchArgument();
        Assert.assertEquals((String)"leaf-0", (String)sarg.getExpression().toString());
        Assert.assertEquals((int)1, (int)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((String)"(EQUALS ch char      )", (String)leaf.toString());
    }

    @Test
    public void TestVarcharSarg() throws Exception {
        String serialAst = "AQEAamF2YS51dGlsLkFycmF5TGlz9AECAQFvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnBsYW4uRXhwck5vZGVDb2x1bW5EZXPjAQF24wAAAWJpZ29y4wECb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5zZXJkZTIudHlwZWluZm8uVmFyY2hhclR5cGVJbmbvAcgBAXZhcmNoYfIBA29yZy5hcGFjaGUuaGFkb29wLmhpdmUucWwucGxhbi5FeHByTm9kZUNvbnN0YW50RGVz4wEBBG9yZy5hcGFjaGUuaGFkb29wLmhpdmUuc2VyZGUyLnR5cGVpbmZvLlByaW1pdGl2ZVR5cGVJbmbvAQFzdHJpbucDAXZhcmlhYmzlAQVvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnVkZi5nZW5lcmljLkdlbmVyaWNVREZPUEVxdWHsAQAAAYI9AUVRVUHMAQZvcmcuYXBhY2hlLmhhZG9vcC5pby5Cb29sZWFuV3JpdGFibOUBAAABBAEBYm9vbGVh7g==";
        SearchArgument sarg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst)).buildSearchArgument();
        Assert.assertEquals((String)"leaf-0", (String)sarg.getExpression().toString());
        Assert.assertEquals((int)1, (int)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((String)"(EQUALS vc variable)", (String)leaf.toString());
    }

    @Test
    public void TestBigintSarg() throws Exception {
        String serialAst = "AQEAamF2YS51dGlsLkFycmF5TGlz9AECAQFvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnBsYW4uRXhwck5vZGVDb2x1bW5EZXPjAQFi6QAAAWJpZ29y4wECb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5zZXJkZTIudHlwZWluZm8uUHJpbWl0aXZlVHlwZUluZu8BAWJpZ2lu9AEDb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5xbC5wbGFuLkV4cHJOb2RlQ29uc3RhbnREZXPjAQECBwnywAEBBG9yZy5hcGFjaGUuaGFkb29wLmhpdmUucWwudWRmLmdlbmVyaWMuR2VuZXJpY1VERk9QRXF1YewBAAABgj0BRVFVQcwBBW9yZy5hcGFjaGUuaGFkb29wLmlvLkJvb2xlYW5Xcml0YWJs5QEAAAECAQFib29sZWHu";
        SearchArgument sarg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst)).buildSearchArgument();
        Assert.assertEquals((String)"leaf-0", (String)sarg.getExpression().toString());
        Assert.assertEquals((int)1, (int)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((String)"(EQUALS bi 12345)", (String)leaf.toString());
    }

    @Test
    public void TestBooleanSarg() throws Exception {
        String serialAst = "AQEAamF2YS51dGlsLkFycmF5TGlz9AECAQFvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnBsYW4uRXhwck5vZGVHZW5lcmljRnVuY0Rlc+MBAQABAgECb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5xbC5wbGFuLkV4cHJOb2RlQ29sdW1uRGVz4wEBYrEAAAFib29sb3LjAQNvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnNlcmRlMi50eXBlaW5mby5QcmltaXRpdmVUeXBlSW5m7wEBYm9vbGVh7gEEb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5xbC5wbGFuLkV4cHJOb2RlQ29uc3RhbnREZXPjAQEDCQUBAQVvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnVkZi5nZW5lcmljLkdlbmVyaWNVREZPUEVxdWHsAQAAAYI9AUVRVUHMAQZvcmcuYXBhY2hlLmhhZG9vcC5pby5Cb29sZWFuV3JpdGFibOUBAAABAwkBAgEBYrIAAAgBAwkBB29yZy5hcGFjaGUuaGFkb29wLmhpdmUucWwudWRmLmdlbmVyaWMuR2VuZXJpY1VERk9QQW7kAQEGAQAAAQMJ";
        SearchArgument sarg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst)).buildSearchArgument();
        Assert.assertEquals((String)"(and leaf-0 leaf-1)", (String)sarg.getExpression().toString());
        Assert.assertEquals((int)2, (int)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.BOOLEAN, (Object)leaf.getType());
        Assert.assertEquals((String)"(EQUALS b1 true)", (String)leaf.toString());
        leaf = (PredicateLeaf)sarg.getLeaves().get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.BOOLEAN, (Object)leaf.getType());
        Assert.assertEquals((String)"(EQUALS b2 true)", (String)leaf.toString());
    }

    @Test
    public void TestFloatSarg() throws Exception {
        String serialAst = "AQEAamF2YS51dGlsLkFycmF5TGlz9AECAQFvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnBsYW4uRXhwck5vZGVDb2x1bW5EZXPjAQFmbPQAAAFiaWdvcuMBAm9yZy5hcGFjaGUuaGFkb29wLmhpdmUuc2VyZGUyLnR5cGVpbmZvLlByaW1pdGl2ZVR5cGVJbmbvAQFmbG9h9AEDb3JnLmFwYWNoZS5oYWRvb3AuaGl2ZS5xbC5wbGFuLkV4cHJOb2RlQ29uc3RhbnREZXPjAQECBwQ/jMzNAQRvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnVkZi5nZW5lcmljLkdlbmVyaWNVREZPUEVxdWHsAQAAAYI9AUVRVUHMAQVvcmcuYXBhY2hlLmhhZG9vcC5pby5Cb29sZWFuV3JpdGFibOUBAAABAgEBYm9vbGVh7g==";
        SearchArgument sarg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst)).buildSearchArgument();
        Assert.assertEquals((String)"leaf-0", (String)sarg.getExpression().toString());
        Assert.assertEquals((int)1, (int)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.FLOAT, (Object)leaf.getType());
        Assert.assertEquals((String)("(EQUALS flt " + ((Number)Float.valueOf(1.1f)).doubleValue() + ")"), (String)leaf.toString());
    }

    @Test
    public void TestDoubleSarg() throws Exception {
        String serialAst = "AQEAamF2YS51dGlsLkFycmF5TGlz9AECAQFvcmcuYXBhY2hlLmhhZG9vcC5oaXZlLnFsLnBsYW4uRXhwck5vZGVDb2x1bW5EZXPjAQFkYuwAAAFiaWdvcuMBAm9yZy5hcGFjaGUuaGFkb29wLmhpdmUuc2VyZGUyLnR5cGVpbmZvLlByaW1pdGl2ZVR5cGVJbmbvAQFkb3VibOUBA29yZy5hcGFjaGUuaGFkb29wLmhpdmUucWwucGxhbi5FeHByTm9kZUNvbnN0YW50RGVz4wEBAgcKQAGZmZmZmZoBBG9yZy5hcGFjaGUuaGFkb29wLmhpdmUucWwudWRmLmdlbmVyaWMuR2VuZXJpY1VERk9QRXF1YewBAAABgj0BRVFVQcwBBW9yZy5hcGFjaGUuaGFkb29wLmlvLkJvb2xlYW5Xcml0YWJs5QEAAAECAQFib29sZWHu";
        SearchArgument sarg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst)).buildSearchArgument();
        Assert.assertEquals((String)"leaf-0", (String)sarg.getExpression().toString());
        Assert.assertEquals((int)1, (int)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.FLOAT, (Object)leaf.getType());
        Assert.assertEquals((String)"(EQUALS dbl 2.2)", (String)leaf.toString());
    }
}

