/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import java.io.IOException;
import org.apache.hadoop.hive.ql.index.MockHiveInputSplits;
import org.apache.hadoop.hive.ql.index.MockInputFile;
import org.apache.hadoop.hive.ql.index.SplitFilterTestCase;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.junit.Test;

public class TestSplitFilter {
    private SplitFilterTestCase testCase;

    @Test
    public void testOneSelectedSplitsInMiddle() throws Exception {
        this.testCase = SplitFilterTestCase.builder().inputFiles(MockInputFile.builder().path("A").split().selectedSplit().split().build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 1046576L, 1050576L)).build();
        this.testCase.executeAndValidate();
    }

    @Test
    public void testSelectedFirstSplit() throws Exception {
        this.testCase = SplitFilterTestCase.builder().inputFiles(MockInputFile.builder().path("A").selectedSplit().split().split().build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 0L, 0x100000L)).build();
        this.testCase.executeAndValidate();
    }

    @Test
    public void testSelectedLastSplit() throws Exception {
        int lastSplitSize = 1234;
        this.testCase = SplitFilterTestCase.builder().inputFiles(MockInputFile.builder().path("A").split().selectedSplit(lastSplitSize).build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 1046576L, lastSplitSize + 2000)).build();
        this.testCase.executeAndValidate();
    }

    @Test
    public void testSelectedTwoAdjacentSplits() throws Exception {
        this.testCase = SplitFilterTestCase.builder().inputFiles(MockInputFile.builder().path("A").selectedSplit().selectedSplit().split().build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 0L, 0x100000L), MockHiveInputSplits.createMockSplit("A", 0x100000L, 0x100000L)).build();
        this.testCase.executeAndValidate();
    }

    @Test
    public void testSelectedThreeAdjacentSplits() throws Exception {
        this.testCase = SplitFilterTestCase.builder().inputFiles(MockInputFile.builder().path("A").selectedSplit().selectedSplit().selectedSplit().split().build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 0L, 0x100000L), MockHiveInputSplits.createMockSplit("A", 0x100000L, 0x100000L), MockHiveInputSplits.createMockSplit("A", 0x200000L, 0x100000L)).build();
        this.testCase.executeAndValidate();
    }

    @Test
    public void testSelectedSplitsInTwoFiles() throws Exception {
        this.testCase = SplitFilterTestCase.builder().inputFiles(MockInputFile.builder().path("A").selectedSplit().split().build(), MockInputFile.builder().path("B").selectedSplit().build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 0L, 0x100000L), MockHiveInputSplits.createMockSplit("B", 0L, 0x100000L)).build();
        this.testCase.executeAndValidate();
    }

    @Test
    public void testOverlapWithPreviousFile() throws Exception {
        this.testCase = SplitFilterTestCase.builder().inputFiles(MockInputFile.builder().path("A").selectedSplit().build(), MockInputFile.builder().path("B").split().selectedSplit().build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 0L, 0x100000L), MockHiveInputSplits.createMockSplit("B", 1046576L, 1050576L)).build();
        this.testCase.executeAndValidate();
    }

    @Test
    public void testOverlapInSecondFile() throws Exception {
        this.testCase = SplitFilterTestCase.builder().inputFiles(MockInputFile.builder().path("A").selectedSplit().build(), MockInputFile.builder().path("B").split().selectedSplit().selectedSplit().build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 0L, 0x100000L), MockHiveInputSplits.createMockSplit("B", 1046576L, 1050576L), MockHiveInputSplits.createMockSplit("B", 0x200000L, 0x100000L)).build();
        this.testCase.executeAndValidate();
    }

    @Test
    public void testSmallSplitsLengthAdjustment() throws Exception {
        this.testCase = SplitFilterTestCase.builder().inputFiles(MockInputFile.builder().path("A").defaultSplitLength(500L).split().selectedSplit().build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 0L, 1000L)).build();
        this.testCase.executeAndValidate();
    }

    @Test
    public void testSmallSplitsOverlap() throws Exception {
        this.testCase = SplitFilterTestCase.builder().inputFiles(MockInputFile.builder().path("A").defaultSplitLength(500L).selectedSplit().split().selectedSplit().split().selectedSplit().build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 0L, 500L), MockHiveInputSplits.createMockSplit("A", 1000L, 500L), MockHiveInputSplits.createMockSplit("A", 2000L, 500L)).build();
        this.testCase.executeAndValidate();
    }

    @Test
    public void testMaxSplitsSizePositive() throws Exception {
        this.testCase = SplitFilterTestCase.builder().maxInputSize(3149728L).inputFiles(MockInputFile.builder().path("A").selectedSplit().split().selectedSplit().split().selectedSplit().build()).expectedSplits(MockHiveInputSplits.createMockSplit("A", 0L, 0x100000L), MockHiveInputSplits.createMockSplit("A", 2095152L, 1050576L), MockHiveInputSplits.createMockSplit("A", 4192304L, 1050576L)).build();
        this.testCase.executeAndValidate();
    }

    @Test(expected=IOException.class)
    public void testMaxSplitsSizeNegative() throws Exception {
        this.testCase = SplitFilterTestCase.builder().maxInputSize(0x300000L).inputFiles(MockInputFile.builder().path("A").selectedSplit().split().selectedSplit().split().selectedSplit().build()).expectedSplits(new HiveInputFormat.HiveInputSplit[0]).build();
        this.testCase.executeAndValidate();
    }
}

