/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.hooks.PreParseHook;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPreParseHook {
    @Test
    public void testWithoutHook() throws Exception {
        String command = "query";
        Context context = (Context)Mockito.mock(Context.class);
        HiveConf hiveConf = new HiveConf();
        List preParseHooks = HookUtils.getHooks((HiveConf)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PRE_PARSE_HOOKS, PreParseHook.class);
        Assert.assertEquals((long)0L, (long)preParseHooks.size());
        for (PreParseHook preParseHook : preParseHooks) {
            command = preParseHook.getCustomCommand(context, command);
        }
        String expected = "query";
        Assert.assertEquals((Object)expected, (Object)command);
    }

    @Test
    public void testPareParseHookExtraction() throws Exception {
        HiveConf hiveConf = new HiveConf();
        hiveConf.set(HiveConf.ConfVars.HIVE_PRE_PARSE_HOOKS.varname, "org.apache.hadoop.hive.ql.hooks.TestPreParseHook$SimpleCustomSQL,org.apache.hadoop.hive.ql.hooks.TestPreParseHook$BrokenPreParseHook");
        List preParseHooks = HookUtils.getHooks((HiveConf)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PRE_PARSE_HOOKS, PreParseHook.class);
        Assert.assertEquals((long)2L, (long)preParseHooks.size());
    }

    @Test
    public void testPreParseHook() throws Exception {
        String command = "SLCT %for id = 1 to 5% query";
        Context context = (Context)Mockito.mock(Context.class);
        HiveConf hiveConf = new HiveConf();
        hiveConf.set(HiveConf.ConfVars.HIVE_PRE_PARSE_HOOKS.varname, "org.apache.hadoop.hive.ql.hooks.TestPreParseHook$SimpleCustomSQL");
        List preParseHooks = HookUtils.getHooks((HiveConf)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PRE_PARSE_HOOKS, PreParseHook.class);
        Assert.assertEquals((long)1L, (long)preParseHooks.size());
        for (PreParseHook preParseHook : preParseHooks) {
            command = preParseHook.getCustomCommand(context, command);
        }
        String expected = "SELECT %for id = 1 to 5% query";
        Assert.assertEquals((Object)expected, (Object)command);
    }

    @Test
    public void testBrokenHook() {
        String command = "query";
        Context context = (Context)Mockito.mock(Context.class);
        HiveConf hiveConf = new HiveConf();
        hiveConf.set(HiveConf.ConfVars.HIVE_PRE_PARSE_HOOKS.varname, "org.apache.hadoop.hive.ql.hooks.TestPreParseHook$BrokenPreParseHook");
        try {
            List preParseHooks = HookUtils.getHooks((HiveConf)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PRE_PARSE_HOOKS, PreParseHook.class);
            for (PreParseHook preParseHook : preParseHooks) {
                command = preParseHook.getCustomCommand(context, command);
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"broken hook");
        }
    }

    public static class BrokenPreParseHook
    implements PreParseHook {
        public String getCustomCommand(Context context, String command) throws Exception {
            throw new Exception("broken hook");
        }
    }

    public static class SimpleCustomSQL
    implements PreParseHook {
        public String getCustomCommand(Context context, String command) throws Exception {
            return command.replace("SLCT", "SELECT");
        }
    }
}

