/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorMapJoinFastBytesHashSet
extends CommonFastHashTable {
    @Test
    public void testOneKey() throws Exception {
        random = new Random(81104L);
        VectorMapJoinFastMultiKeyHashSet map = new VectorMapJoinFastMultiKeyHashSet(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashSet();
        byte[] key = new byte[random.nextInt(100)];
        random.nextBytes(key);
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify((VectorMapJoinFastBytesHashSet)map);
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify((VectorMapJoinFastBytesHashSet)map);
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify((VectorMapJoinFastBytesHashSet)map);
    }

    @Test
    public void testMultipleKeysSingleValue() throws Exception {
        random = new Random(1120L);
        VectorMapJoinFastMultiKeyHashSet map = new VectorMapJoinFastMultiKeyHashSet(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashSet();
        int keyCount = 100 + random.nextInt(1000);
        for (int i = 0; i < keyCount; ++i) {
            byte[] key = new byte[random.nextInt(100)];
            random.nextBytes(key);
            if (!verifyTable.contains(key)) break;
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashSet)map);
    }

    @Test
    public void testGetNonExistent() throws Exception {
        random = new Random(2293L);
        VectorMapJoinFastMultiKeyHashSet map = new VectorMapJoinFastMultiKeyHashSet(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashSet();
        byte[] key1 = new byte[random.nextInt(100)];
        random.nextBytes(key1);
        map.testPutRow(key1);
        verifyTable.add(key1);
        verifyTable.verify((VectorMapJoinFastBytesHashSet)map);
        byte[] key2 = new byte[random.nextInt(100)];
        random.nextBytes(key2);
        VectorMapJoinHashSetResult hashSetResult = map.createHashSetResult();
        JoinUtil.JoinResult joinResult = map.contains(key2, 0, key2.length, hashSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        map.testPutRow(key2);
        verifyTable.add(key2);
        verifyTable.verify((VectorMapJoinFastBytesHashSet)map);
        byte[] key3 = new byte[random.nextInt(100)];
        random.nextBytes(key3);
        hashSetResult = map.createHashSetResult();
        joinResult = map.contains(key3, 0, key3.length, hashSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
    }

    @Test
    public void testFullMap() throws Exception {
        byte[] anotherKey;
        random = new Random(219L);
        VectorMapJoinFastMultiKeyHashSet map = new VectorMapJoinFastMultiKeyHashSet(false, 8, 1.0f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashSet();
        for (int i = 0; i < 8; ++i) {
            byte[] key;
            do {
                key = new byte[random.nextInt(100)];
                random.nextBytes(key);
            } while (verifyTable.contains(key));
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashSet)map);
        do {
            anotherKey = new byte[random.nextInt(100)];
            random.nextBytes(anotherKey);
        } while (verifyTable.contains(anotherKey));
        VectorMapJoinHashSetResult hashSetResult = map.createHashSetResult();
        JoinUtil.JoinResult joinResult = map.contains(anotherKey, 0, anotherKey.length, hashSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
    }

    @Test
    public void testExpand() throws Exception {
        random = new Random(773L);
        VectorMapJoinFastMultiKeyHashSet map = new VectorMapJoinFastMultiKeyHashSet(false, 1, 1.0E-7f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashSet();
        for (int i = 0; i < 18; ++i) {
            byte[] key;
            do {
                key = new byte[random.nextInt(100)];
                random.nextBytes(key);
            } while (verifyTable.contains(key));
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashSet)map);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastMultiKeyHashSet map, CheckFastHashTable.VerifyFastBytesHashSet verifyTable) throws HiveException, IOException {
        for (int i = 0; i < keyCount; ++i) {
            byte[] value = new byte[TestVectorMapJoinFastBytesHashSet.generateLargeCount() - 1];
            random.nextBytes(value);
            if (random.nextBoolean() || verifyTable.getCount() == 0) {
                byte[] key;
                do {
                    key = new byte[random.nextInt(100)];
                    random.nextBytes(key);
                } while (verifyTable.contains(key));
                map.testPutRow(key);
                verifyTable.add(key);
                continue;
            }
            byte[] randomExistingKey = verifyTable.addRandomExisting(value, random);
            map.testPutRow(randomExistingKey);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashSet)map);
    }

    @Test
    public void testMultipleKeysMultipleValue() throws Exception {
        random = new Random(9L);
        VectorMapJoinFastMultiKeyHashSet map = new VectorMapJoinFastMultiKeyHashSet(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastHashTable.VerifyFastBytesHashSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashSet();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Test
    public void testLargeAndExpand() throws Exception {
        random = new Random(8462L);
        VectorMapJoinFastMultiKeyHashSet map = new VectorMapJoinFastMultiKeyHashSet(false, 512, 0.75f, 8192, -1L);
        CheckFastHashTable.VerifyFastBytesHashSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashSet();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }
}

