/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Charsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.RandomTypeUtil;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveIntervalDayTimeObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveIntervalYearMonthObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public class VectorRandomRowSource {
    private Random r;
    private int columnCount;
    private List<String> typeNames;
    private PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories;
    private PrimitiveTypeInfo[] primitiveTypeInfos;
    private List<ObjectInspector> primitiveObjectInspectorList;
    private StructObjectInspector rowStructObjectInspector;
    private String[] alphabets;
    private boolean addEscapables;
    private String needsEscapeStr;
    private static String[] possibleHiveTypeNames = new String[]{"boolean", "tinyint", "smallint", "int", "bigint", "date", "float", "double", "string", "varchar", "binary", "date", "timestamp", "interval_year_month", "interval_day_time", "decimal"};
    private static final String DECIMAL_CHARS = "0123456789";

    public List<String> typeNames() {
        return this.typeNames;
    }

    public PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories() {
        return this.primitiveCategories;
    }

    public PrimitiveTypeInfo[] primitiveTypeInfos() {
        return this.primitiveTypeInfos;
    }

    public StructObjectInspector rowStructObjectInspector() {
        return this.rowStructObjectInspector;
    }

    public StructObjectInspector partialRowStructObjectInspector(int partialFieldCount) {
        ArrayList<AbstractPrimitiveWritableObjectInspector> partialPrimitiveObjectInspectorList = new ArrayList<AbstractPrimitiveWritableObjectInspector>(partialFieldCount);
        ArrayList<String> columnNames = new ArrayList<String>(partialFieldCount);
        for (int i = 0; i < partialFieldCount; ++i) {
            columnNames.add(String.format("partial%d", i));
            partialPrimitiveObjectInspectorList.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)this.primitiveTypeInfos[i]));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, this.primitiveObjectInspectorList);
    }

    public void init(Random r) {
        this.r = r;
        this.chooseSchema();
    }

    private void chooseSchema() {
        boolean allTypes;
        boolean onlyOne;
        HashSet<Integer> hashSet = null;
        boolean bl = onlyOne = this.r.nextInt(100) == 7;
        if (onlyOne) {
            this.columnCount = 1;
            allTypes = false;
        } else {
            allTypes = this.r.nextBoolean();
            if (allTypes) {
                this.columnCount = possibleHiveTypeNames.length;
                hashSet = new HashSet<Integer>();
            } else {
                this.columnCount = 1 + this.r.nextInt(20);
            }
        }
        this.typeNames = new ArrayList<String>(this.columnCount);
        this.primitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[this.columnCount];
        this.primitiveTypeInfos = new PrimitiveTypeInfo[this.columnCount];
        this.primitiveObjectInspectorList = new ArrayList<ObjectInspector>(this.columnCount);
        ArrayList<String> columnNames = new ArrayList<String>(this.columnCount);
        for (int c = 0; c < this.columnCount; ++c) {
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
            PrimitiveTypeInfo primitiveTypeInfo;
            int maxLength;
            String typeName;
            columnNames.add(String.format("col%d", c));
            if (onlyOne) {
                typeName = possibleHiveTypeNames[this.r.nextInt(possibleHiveTypeNames.length)];
            } else {
                int typeNum;
                if (allTypes) {
                    Integer typeNumInteger;
                    while (hashSet.contains(typeNumInteger = new Integer(typeNum = this.r.nextInt(possibleHiveTypeNames.length)))) {
                    }
                    hashSet.add(typeNumInteger);
                } else {
                    typeNum = this.r.nextInt(possibleHiveTypeNames.length);
                }
                typeName = possibleHiveTypeNames[typeNum];
            }
            if (typeName.equals("char")) {
                maxLength = 1 + this.r.nextInt(100);
                typeName = String.format("char(%d)", maxLength);
            } else if (typeName.equals("varchar")) {
                maxLength = 1 + this.r.nextInt(100);
                typeName = String.format("varchar(%d)", maxLength);
            } else if (typeName.equals("decimal")) {
                typeName = String.format("decimal(%d,%d)", 38, 18);
            }
            this.primitiveTypeInfos[c] = primitiveTypeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
            this.primitiveCategories[c] = primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
            this.primitiveObjectInspectorList.add((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo));
            this.typeNames.add(typeName);
        }
        this.rowStructObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, this.primitiveObjectInspectorList);
        this.alphabets = new String[this.columnCount];
    }

    public void addBinarySortableAlphabets() {
        block3: for (int c = 0; c < this.columnCount; ++c) {
            switch (this.primitiveCategories[c]) {
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    byte[] bytes = new byte[10 + this.r.nextInt(10)];
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = (byte)(32 + this.r.nextInt(96));
                    }
                    int alwaysIndex = this.r.nextInt(bytes.length);
                    bytes[alwaysIndex] = 0;
                    int alwaysIndex2 = this.r.nextInt(bytes.length);
                    bytes[alwaysIndex2] = 1;
                    this.alphabets[c] = new String(bytes, Charsets.UTF_8);
                    continue block3;
                }
            }
        }
    }

    public void addEscapables(String needsEscapeStr) {
        this.addEscapables = true;
        this.needsEscapeStr = needsEscapeStr;
    }

    public Object[][] randomRows(int n) {
        Object[][] result = new Object[n][];
        for (int i = 0; i < n; ++i) {
            result[i] = this.randomRow();
        }
        return result;
    }

    public Object[] randomRow() {
        Object[] row = new Object[this.columnCount];
        for (int c = 0; c < this.columnCount; ++c) {
            Object object = this.randomObject(c);
            if (object == null) {
                throw new Error("Unexpected null for column " + c);
            }
            row[c] = this.getWritableObject(c, object);
            if (row[c] != null) continue;
            throw new Error("Unexpected null for writable for column " + c);
        }
        return row;
    }

    public Object[] randomRow(int columnCount) {
        return VectorRandomRowSource.randomRow(columnCount, this.r, this.primitiveObjectInspectorList, this.primitiveCategories, this.primitiveTypeInfos);
    }

    public static Object[] randomRow(int columnCount, Random r, List<ObjectInspector> primitiveObjectInspectorList, PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories, PrimitiveTypeInfo[] primitiveTypeInfos) {
        Object[] row = new Object[columnCount];
        for (int c = 0; c < columnCount; ++c) {
            Object object = VectorRandomRowSource.randomObject(c, r, primitiveCategories, primitiveTypeInfos);
            if (object == null) {
                throw new Error("Unexpected null for column " + c);
            }
            row[c] = VectorRandomRowSource.getWritableObject(c, object, primitiveObjectInspectorList, primitiveCategories, primitiveTypeInfos);
            if (row[c] != null) continue;
            throw new Error("Unexpected null for writable for column " + c);
        }
        return row;
    }

    public static void sort(Object[][] rows, ObjectInspector oi) {
        for (int i = 0; i < rows.length; ++i) {
            for (int j = i + 1; j < rows.length; ++j) {
                if (ObjectInspectorUtils.compare((Object)rows[i], (ObjectInspector)oi, (Object)rows[j], (ObjectInspector)oi) <= 0) continue;
                Object[] t = rows[i];
                rows[i] = rows[j];
                rows[j] = t;
            }
        }
    }

    public void sort(Object[][] rows) {
        VectorRandomRowSource.sort(rows, (ObjectInspector)this.rowStructObjectInspector);
    }

    public Object getWritableObject(int column, Object object) {
        return VectorRandomRowSource.getWritableObject(column, object, this.primitiveObjectInspectorList, this.primitiveCategories, this.primitiveTypeInfos);
    }

    public static Object getWritableObject(int column, Object object, List<ObjectInspector> primitiveObjectInspectorList, PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories, PrimitiveTypeInfo[] primitiveTypeInfos) {
        ObjectInspector objectInspector = primitiveObjectInspectorList.get(column);
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveCategories[column];
        PrimitiveTypeInfo primitiveTypeInfo = primitiveTypeInfos[column];
        switch (primitiveCategory) {
            case BOOLEAN: {
                return ((WritableBooleanObjectInspector)objectInspector).create(((Boolean)object).booleanValue());
            }
            case BYTE: {
                return ((WritableByteObjectInspector)objectInspector).create(((Byte)object).byteValue());
            }
            case SHORT: {
                return ((WritableShortObjectInspector)objectInspector).create(((Short)object).shortValue());
            }
            case INT: {
                return ((WritableIntObjectInspector)objectInspector).create(((Integer)object).intValue());
            }
            case LONG: {
                return ((WritableLongObjectInspector)objectInspector).create(((Long)object).longValue());
            }
            case DATE: {
                return ((WritableDateObjectInspector)objectInspector).create((Date)object);
            }
            case FLOAT: {
                return ((WritableFloatObjectInspector)objectInspector).create(((Float)object).floatValue());
            }
            case DOUBLE: {
                return ((WritableDoubleObjectInspector)objectInspector).create(((Double)object).doubleValue());
            }
            case STRING: {
                return ((WritableStringObjectInspector)objectInspector).create((String)object);
            }
            case CHAR: {
                WritableHiveCharObjectInspector writableCharObjectInspector = new WritableHiveCharObjectInspector((CharTypeInfo)primitiveTypeInfo);
                return writableCharObjectInspector.create((HiveChar)object);
            }
            case VARCHAR: {
                WritableHiveVarcharObjectInspector writableVarcharObjectInspector = new WritableHiveVarcharObjectInspector((VarcharTypeInfo)primitiveTypeInfo);
                return writableVarcharObjectInspector.create((HiveVarchar)object);
            }
            case BINARY: {
                return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector.create((byte[])object);
            }
            case TIMESTAMP: {
                return ((WritableTimestampObjectInspector)objectInspector).create((Timestamp)object);
            }
            case INTERVAL_YEAR_MONTH: {
                return ((WritableHiveIntervalYearMonthObjectInspector)objectInspector).create((HiveIntervalYearMonth)object);
            }
            case INTERVAL_DAY_TIME: {
                return ((WritableHiveIntervalDayTimeObjectInspector)objectInspector).create((HiveIntervalDayTime)object);
            }
            case DECIMAL: {
                WritableHiveDecimalObjectInspector writableDecimalObjectInspector = new WritableHiveDecimalObjectInspector((DecimalTypeInfo)primitiveTypeInfo);
                HiveDecimalWritable result = (HiveDecimalWritable)writableDecimalObjectInspector.create((HiveDecimal)object);
                return result;
            }
        }
        throw new Error("Unknown primitive category " + primitiveCategory);
    }

    public Object randomObject(int column) {
        return VectorRandomRowSource.randomObject(column, this.r, this.primitiveCategories, this.primitiveTypeInfos, this.alphabets, this.addEscapables, this.needsEscapeStr);
    }

    public static Object randomObject(int column, Random r, PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories, PrimitiveTypeInfo[] primitiveTypeInfos) {
        return VectorRandomRowSource.randomObject(column, r, primitiveCategories, primitiveTypeInfos, null, false, "");
    }

    public static Object randomObject(int column, Random r, PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories, PrimitiveTypeInfo[] primitiveTypeInfos, String[] alphabets, boolean addEscapables, String needsEscapeStr) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveCategories[column];
        PrimitiveTypeInfo primitiveTypeInfo = primitiveTypeInfos[column];
        try {
            switch (primitiveCategory) {
                case BOOLEAN: {
                    return r.nextInt(1) == 1;
                }
                case BYTE: {
                    return (byte)r.nextInt();
                }
                case SHORT: {
                    return (short)r.nextInt();
                }
                case INT: {
                    return r.nextInt();
                }
                case LONG: {
                    return r.nextLong();
                }
                case DATE: {
                    return RandomTypeUtil.getRandDate((Random)r);
                }
                case FLOAT: {
                    return Float.valueOf(r.nextFloat() * 10.0f - 5.0f);
                }
                case DOUBLE: {
                    return r.nextDouble() * 10.0 - 5.0;
                }
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    String result = alphabets != null && alphabets[column] != null ? RandomTypeUtil.getRandString((Random)r, (String)alphabets[column], (int)r.nextInt(10)) : RandomTypeUtil.getRandString((Random)r);
                    if (addEscapables && result.length() > 0) {
                        int escapeCount = 1 + r.nextInt(2);
                        for (int i = 0; i < escapeCount; ++i) {
                            int index = r.nextInt(result.length());
                            String begin = result.substring(0, index);
                            String end = result.substring(index);
                            Character needsEscapeChar = Character.valueOf(needsEscapeStr.charAt(r.nextInt(needsEscapeStr.length())));
                            result = begin + needsEscapeChar + end;
                        }
                    }
                    switch (primitiveCategory) {
                        case STRING: {
                            return result;
                        }
                        case CHAR: {
                            return new HiveChar(result, ((CharTypeInfo)primitiveTypeInfo).getLength());
                        }
                        case VARCHAR: {
                            return new HiveVarchar(result, ((VarcharTypeInfo)primitiveTypeInfo).getLength());
                        }
                    }
                    throw new Error("Unknown primitive category " + primitiveCategory);
                }
                case BINARY: {
                    return VectorRandomRowSource.getRandBinary(r, 1 + r.nextInt(100));
                }
                case TIMESTAMP: {
                    return RandomTypeUtil.getRandTimestamp((Random)r);
                }
                case INTERVAL_YEAR_MONTH: {
                    return VectorRandomRowSource.getRandIntervalYearMonth(r);
                }
                case INTERVAL_DAY_TIME: {
                    return VectorRandomRowSource.getRandIntervalDayTime(r);
                }
                case DECIMAL: {
                    return VectorRandomRowSource.getRandHiveDecimal(r, (DecimalTypeInfo)primitiveTypeInfo);
                }
            }
            throw new Error("Unknown primitive category " + primitiveCategory);
        }
        catch (Exception e) {
            throw new RuntimeException("randomObject failed on column " + column + " type " + primitiveCategory, e);
        }
    }

    public static HiveChar getRandHiveChar(Random r, CharTypeInfo charTypeInfo, String alphabet) {
        int maxLength = 1 + r.nextInt(charTypeInfo.getLength());
        String randomString = RandomTypeUtil.getRandString((Random)r, (String)alphabet, (int)100);
        HiveChar hiveChar = new HiveChar(randomString, maxLength);
        return hiveChar;
    }

    public static HiveChar getRandHiveChar(Random r, CharTypeInfo charTypeInfo) {
        return VectorRandomRowSource.getRandHiveChar(r, charTypeInfo, "abcdefghijklmnopqrstuvwxyz");
    }

    public static HiveVarchar getRandHiveVarchar(Random r, VarcharTypeInfo varcharTypeInfo, String alphabet) {
        int maxLength = 1 + r.nextInt(varcharTypeInfo.getLength());
        String randomString = RandomTypeUtil.getRandString((Random)r, (String)alphabet, (int)100);
        HiveVarchar hiveVarchar = new HiveVarchar(randomString, maxLength);
        return hiveVarchar;
    }

    public static HiveVarchar getRandHiveVarchar(Random r, VarcharTypeInfo varcharTypeInfo) {
        return VectorRandomRowSource.getRandHiveVarchar(r, varcharTypeInfo, "abcdefghijklmnopqrstuvwxyz");
    }

    public static byte[] getRandBinary(Random r, int len) {
        byte[] bytes = new byte[len];
        for (int j = 0; j < len; ++j) {
            bytes[j] = (byte)r.nextInt();
        }
        return bytes;
    }

    public static HiveDecimal getRandHiveDecimal(Random r, DecimalTypeInfo decimalTypeInfo) {
        StringBuilder sb = new StringBuilder();
        int precision = 1 + r.nextInt(18);
        int scale = 0 + r.nextInt(precision + 1);
        int integerDigits = precision - scale;
        if (r.nextBoolean()) {
            sb.append("-");
        }
        if (integerDigits == 0) {
            sb.append("0");
        } else {
            sb.append(RandomTypeUtil.getRandString((Random)r, (String)DECIMAL_CHARS, (int)integerDigits));
        }
        if (scale != 0) {
            sb.append(".");
            sb.append(RandomTypeUtil.getRandString((Random)r, (String)DECIMAL_CHARS, (int)scale));
        }
        HiveDecimal dec = HiveDecimal.create((String)sb.toString());
        return dec;
    }

    public static HiveIntervalYearMonth getRandIntervalYearMonth(Random r) {
        String yearMonthSignStr = r.nextInt(2) == 0 ? "" : "-";
        String intervalYearMonthStr = String.format("%s%d-%d", yearMonthSignStr, 1800 + r.nextInt(500), 0 + r.nextInt(12));
        HiveIntervalYearMonth intervalYearMonthVal = HiveIntervalYearMonth.valueOf((String)intervalYearMonthStr);
        return intervalYearMonthVal;
    }

    public static HiveIntervalDayTime getRandIntervalDayTime(Random r) {
        String optionalNanos = "";
        if (r.nextInt(2) == 1) {
            optionalNanos = String.format(".%09d", 0 + r.nextInt(1000000000));
        }
        String yearMonthSignStr = r.nextInt(2) == 0 ? "" : "-";
        String dayTimeStr = String.format("%s%d %02d:%02d:%02d%s", yearMonthSignStr, 1 + r.nextInt(28), 0 + r.nextInt(24), 0 + r.nextInt(60), 0 + r.nextInt(60), optionalNanos);
        HiveIntervalDayTime intervalDayTimeVal = HiveIntervalDayTime.valueOf((String)dayTimeStr);
        return intervalDayTimeVal;
    }
}

