/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestTxnCommands2WithSplitUpdate
extends TestTxnCommands2 {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    @Before
    public void setUp() throws Exception {
        this.setUpWithTableProperties("'transactional'='true','transactional_properties'='default'");
    }

    @Override
    @Test
    public void testInitiatorWithMultipleFailedCompactions() throws Exception {
        this.testInitiatorWithMultipleFailedCompactionsForVariousTblProperties("'transactional'='true','transactional_properties'='default'");
    }

    @Override
    @Test
    public void writeBetweenWorkerAndCleaner() throws Exception {
        this.writeBetweenWorkerAndCleanerForVariousTblProperties("'transactional'='true','transactional_properties'='default'");
    }

    @Override
    @Test
    public void testACIDwithSchemaEvolutionAndCompaction() throws Exception {
        this.testACIDwithSchemaEvolutionForVariousTblProperties("'transactional'='true','transactional_properties'='default'");
    }

    @Test
    public void testFailureOnAlteringTransactionalProperties() throws Exception {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("TBLPROPERTIES with 'transactional_properties' cannot be altered after the table is created");
        this.runStatementOnDriver("create table acidTblLegacy (a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("alter table acidTblLegacy SET TBLPROPERTIES ('transactional_properties' = 'default')");
    }

    @Test
    public void testNonAcidToAcidSplitUpdateConversion1() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        FileStatus[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='default')");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("insert into " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + "(a,b) values(3,4)");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        boolean sawNewDelta = false;
        for (int i = 0; i < status.length; ++i) {
            if (status[i].getPath().getName().matches("delta_.*")) {
                sawNewDelta = true;
                FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00001"));
                continue;
            }
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        Assert.assertTrue((boolean)sawNewDelta);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " order by a,b");
        resultData = new int[][]{{1, 2}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " compact 'MAJOR'");
        TestTxnCommands2WithSplitUpdate.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)1L, (long)buckets.length);
            Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00001"));
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        String fakeFile0 = TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase() + "/subdir/000000_0";
        String fakeFile1 = TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase() + "/subdir/000000_1";
        fs.create(new Path(fakeFile0));
        fs.create(new Path(fakeFile1));
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)5L, (long)status.length);
        TestTxnCommands2WithSplitUpdate.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
        FileStatus[] buckets = fs.listStatus(status[0].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)buckets.length);
        Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00001"));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    @Test
    public void testNonAcidToAcidSplitUpdateConversion2() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        FileStatus[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='default')");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("update " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " set b=3 where a=1");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)4L, (long)status.length);
        boolean sawNewDelta = false;
        boolean sawNewDeleteDelta = false;
        for (int i = 0; i < status.length; ++i) {
            FileStatus[] buckets;
            if (status[i].getPath().getName().matches("delta_.*")) {
                sawNewDelta = true;
                buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                continue;
            }
            if (status[i].getPath().getName().matches("delete_delta_.*")) {
                sawNewDeleteDelta = true;
                buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
                Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_0000[01]"));
                continue;
            }
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        Assert.assertTrue((boolean)sawNewDelta);
        Assert.assertTrue((boolean)sawNewDeleteDelta);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " compact 'MAJOR'");
        TestTxnCommands2WithSplitUpdate.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)5L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
            Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00001"));
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)5L, (long)status.length);
        TestTxnCommands2WithSplitUpdate.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertTrue((boolean)status[0].getPath().getName().matches("base_.*"));
        FileStatus[] buckets = fs.listStatus(status[0].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
        Assert.assertTrue((boolean)buckets[0].getPath().getName().matches("bucket_00001"));
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    @Test
    public void testNonAcidToAcidSplitUpdateConversion3() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        this.runStatementOnDriver("insert into " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        Object[] status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        int[][] resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        int resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='default')");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)BUCKET_COUNT, (long)status.length);
        for (int i = 0; i < status.length; ++i) {
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " compact 'MAJOR'");
        TestTxnCommands2WithSplitUpdate.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)3L, (long)status.length);
        boolean sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            Assert.assertEquals((Object)"base_-9223372036854775808", (Object)status[i].getPath().getName());
            sawNewBase = true;
            FileStatus[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
            Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
            Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
        }
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 2}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 1;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("update " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " set b=3 where a=1");
        this.runStatementOnDriver("insert into " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + "(a,b) values(3,4)");
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Arrays.sort(status);
        Assert.assertEquals((long)6L, (long)status.length);
        int numDelta = 0;
        int numDeleteDelta = 0;
        sawNewBase = false;
        for (int i = 0; i < status.length; ++i) {
            Object[] buckets;
            if (status[i].getPath().getName().matches("delta_.*")) {
                buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Arrays.sort(buckets);
                if (++numDelta == 1) {
                    Assert.assertEquals((Object)"delta_0000001_0000001_0000", (Object)status[i].getPath().getName());
                    Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
                    Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                    continue;
                }
                if (numDelta != 2) continue;
                Assert.assertEquals((Object)"delta_0000002_0000002_0000", (Object)status[i].getPath().getName());
                Assert.assertEquals((long)1L, (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                continue;
            }
            if (status[i].getPath().getName().matches("delete_delta_.*")) {
                buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Arrays.sort(buckets);
                if (++numDeleteDelta != 1) continue;
                Assert.assertEquals((Object)"delete_delta_0000001_0000001_0000", (Object)status[i].getPath().getName());
                Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                continue;
            }
            if (status[i].getPath().getName().matches("base_.*")) {
                Assert.assertEquals((Object)"base_-9223372036854775808", (Object)status[i].getPath().getName());
                sawNewBase = true;
                buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
                Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                continue;
            }
            Assert.assertTrue((boolean)status[i].getPath().getName().matches("00000[01]_0"));
        }
        Assert.assertEquals((long)2L, (long)numDelta);
        Assert.assertEquals((long)1L, (long)numDeleteDelta);
        Assert.assertTrue((boolean)sawNewBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL) + " compact 'MAJOR'");
        TestTxnCommands2WithSplitUpdate.runWorker(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Arrays.sort(status);
        Assert.assertEquals((long)7L, (long)status.length);
        int numBase = 0;
        for (int i = 0; i < status.length; ++i) {
            if (!status[i].getPath().getName().matches("base_.*")) continue;
            Object[] buckets = fs.listStatus(status[i].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
            Arrays.sort(buckets);
            if (++numBase == 1) {
                Assert.assertEquals((Object)"base_-9223372036854775808", (Object)status[i].getPath().getName());
                Assert.assertEquals((long)(BUCKET_COUNT - 1), (long)buckets.length);
                Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
                continue;
            }
            if (numBase != 2) continue;
            Assert.assertEquals((Object)"base_0000002", (Object)status[i].getPath().getName());
            Assert.assertEquals((long)1L, (long)buckets.length);
            Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
        }
        Assert.assertEquals((long)2L, (long)numBase);
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)7L, (long)status.length);
        TestTxnCommands2WithSplitUpdate.runCleaner(this.hiveConf);
        status = fs.listStatus(new Path(TEST_WAREHOUSE_DIR + "/" + TestTxnCommands2.Table.NONACIDORCTBL.toString().toLowerCase()), FileUtils.STAGING_DIR_PATH_FILTER);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertEquals((Object)"base_0000002", (Object)status[0].getPath().getName());
        Object[] buckets = fs.listStatus(status[0].getPath(), FileUtils.STAGING_DIR_PATH_FILTER);
        Arrays.sort(buckets);
        Assert.assertEquals((long)1L, (long)buckets.length);
        Assert.assertEquals((Object)"bucket_00001", (Object)buckets[0].getPath().getName());
        rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultData = new int[][]{{1, 3}, {3, 4}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(resultData), rs);
        rs = this.runStatementOnDriver("select count(*) from " + (Object)((Object)TestTxnCommands2.Table.NONACIDORCTBL));
        resultCount = 2;
        Assert.assertEquals((long)resultCount, (long)Integer.parseInt(rs.get(0)));
    }

    @Override
    @Ignore(value="HIVE-14947")
    @Test
    public void testDynamicPartitionsMerge() throws Exception {
    }

    @Override
    @Ignore(value="HIVE-14947")
    @Test
    public void testDynamicPartitionsMerge2() throws Exception {
    }

    @Override
    @Ignore(value="HIVE-14947")
    @Test
    public void testMerge() throws Exception {
    }

    @Override
    @Test
    public void testMerge2() throws Exception {
        int[][] baseValsOdd = new int[][]{{5, 5}, {11, 11}};
        int[][] baseValsEven = new int[][]{{2, 2}, {4, 44}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TestTxnCommands2.Table.NONACIDPART2) + " PARTITION(p2='odd') " + this.makeValuesClause(baseValsOdd));
        this.runStatementOnDriver("insert into " + (Object)((Object)TestTxnCommands2.Table.NONACIDPART2) + " PARTITION(p2='even') " + this.makeValuesClause(baseValsEven));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)TestTxnCommands2.Table.ACIDTBL) + " " + this.makeValuesClause(vals));
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(vals), r);
        String query = "merge into " + (Object)((Object)TestTxnCommands2.Table.ACIDTBL) + " using " + (Object)((Object)TestTxnCommands2.Table.NONACIDPART2) + " source ON " + (Object)((Object)TestTxnCommands2.Table.ACIDTBL) + ".a = source.a2 WHEN MATCHED THEN UPDATE set b = source.b2 ";
        r = this.runStatementOnDriver(query);
        r = this.runStatementOnDriver("select a,b from " + (Object)((Object)TestTxnCommands2.Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{2, 2}, {4, 44}, {5, 5}, {7, 8}};
        Assert.assertEquals(TestTxnCommands2WithSplitUpdate.stringifyValues(rExpected), r);
    }

    @Override
    @Ignore(value="HIVE-14947")
    @Test
    public void testMergeWithPredicate() throws Exception {
    }
}

