/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Test;

public class TestDriver {
    @Test
    public void TestGetSchemaFieldsHasNullComments() throws CommandNeedRetryException, IOException {
        HiveConf conf = new HiveConf();
        conf.set("fs.default.name", "file:///");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        conf.setVar(HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)conf);
        Driver driver = new Driver();
        String externalTable = "Test_Dup_Partions_" + System.currentTimeMillis();
        driver.init();
        CommandProcessorResponse response = driver.run("drop table if exists " + externalTable);
        Assert.assertEquals((long)0L, (long)response.getResponseCode());
        driver.init();
        response = driver.run("create external table IF NOT EXISTS " + externalTable + " (EmployeeID Int,FirstName String,Designation String,Salary Int,Department String) row format delimited fields terminated by \",\"\n");
        Assert.assertEquals((long)0L, (long)response.getResponseCode());
        driver.init();
        response = driver.run("load data local inpath '../data/files/empl_dupl.txt' into table " + externalTable);
        Assert.assertEquals((long)0L, (long)response.getResponseCode());
        driver.init();
        response = driver.run("select * from " + externalTable);
        Assert.assertEquals((long)0L, (long)response.getResponseCode());
        ArrayList externalTableItemsList = new ArrayList();
        driver.getResults(externalTableItemsList);
        Assert.assertEquals((long)20L, (long)externalTableItemsList.size());
        driver.init();
        response = driver.run("drop table IF EXISTS Test_Parti");
        Assert.assertEquals((long)0L, (long)response.getResponseCode());
        driver.init();
        response = driver.run("create  table Test_Parti \n(EmployeeID Int COMMENT '---------------THIS IS A COMMENT---------------',\nFirstName String COMMENT '---------------THIS IS A COMMENT---------------',\nDesignation  String COMMENT '---------------THIS IS A COMMENT---------------',\nSalary Int COMMENT '---------------THIS IS A COMMENT---------------') \nPARTITIONED BY (Department String) row format delimited fields terminated by \",\"");
        Assert.assertEquals((long)0L, (long)response.getResponseCode());
        driver.init();
        response = driver.run("INSERT INTO TABLE Test_Parti PARTITION(department='A') \nSELECT EmployeeID, FirstName,Designation,Salary FROM " + externalTable + " WHERE department='A'");
        Assert.assertEquals((long)0L, (long)response.getResponseCode());
        driver.init();
        response = driver.run("INSERT INTO TABLE Test_Parti PARTITION (department='B') \nSELECT EmployeeID, FirstName,Designation,Salary FROM " + externalTable + " WHERE department='B'");
        Assert.assertEquals((long)0L, (long)response.getResponseCode());
        driver.init();
        response = driver.run("INSERT INTO TABLE Test_Parti PARTITION (department='C') \nSELECT EmployeeID, FirstName,Designation,Salary FROM " + externalTable + " WHERE department='C'");
        Assert.assertEquals((long)0L, (long)response.getResponseCode());
        driver.init();
        response = driver.run("SELECT * FROM test_parti where employeeid < 10 AND department = 'A' order by employeeid");
        Assert.assertEquals((long)0L, (long)response.getResponseCode());
        ArrayList departmentAEmployees = new ArrayList();
        driver.getResults(departmentAEmployees);
        Assert.assertEquals((long)4L, (long)departmentAEmployees.size());
        Schema schema = driver.getSchema();
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((long)5L, (long)schema.getFieldSchemas().size());
        for (FieldSchema field : schema.getFieldSchemas()) {
            Assert.assertNull((Object)field.getComment());
        }
        driver.close();
    }
}

