/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.udf;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFArgDesc;
import org.apache.hadoop.hive.ql.exec.vector.udf.generic.GenericUDFIsNull;
import org.apache.hadoop.hive.ql.exec.vector.udf.legacy.ConcatTextLongDoubleUDF;
import org.apache.hadoop.hive.ql.exec.vector.udf.legacy.LongUDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorUDFAdaptor {
    static byte[] blue = null;
    static byte[] red = null;

    @Test
    public void testLongUDF() {
        PrimitiveTypeInfo typeInfo = TypeInfoFactory.longTypeInfo;
        GenericUDFBridge genericUDFBridge = new GenericUDFBridge("longudf", false, LongUDF.class.getName());
        ArrayList<ExprNodeColumnDesc> children = new ArrayList<ExprNodeColumnDesc>();
        ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc((TypeInfo)typeInfo, "col0", "tablename", false);
        children.add(colDesc);
        VectorUDFArgDesc[] argDescs = new VectorUDFArgDesc[]{new VectorUDFArgDesc()};
        argDescs[0].setVariable(0);
        ExprNodeGenericFuncDesc funcDesc = new ExprNodeGenericFuncDesc((TypeInfo)typeInfo, (GenericUDF)genericUDFBridge, genericUDFBridge.getUdfName(), children);
        VectorUDFAdaptor vudf = null;
        try {
            vudf = new VectorUDFAdaptor(funcDesc, 1, "Long", argDescs);
        }
        catch (HiveException e) {
            Assert.assertTrue((boolean)false);
        }
        VectorizedRowBatch b = this.getBatchLongInLongOut();
        vudf.evaluate(b);
        LongColumnVector out = (LongColumnVector)b.cols[1];
        Assert.assertEquals((long)1000L, (long)out.vector[0]);
        Assert.assertEquals((long)1001L, (long)out.vector[1]);
        Assert.assertEquals((long)1002L, (long)out.vector[2]);
        Assert.assertTrue((boolean)out.noNulls);
        Assert.assertFalse((boolean)out.isRepeating);
        b = this.getBatchLongInLongOut();
        out = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = false;
        vudf.evaluate(b);
        Assert.assertFalse((boolean)out.noNulls);
        Assert.assertEquals((long)1000L, (long)out.vector[0]);
        Assert.assertEquals((long)1001L, (long)out.vector[1]);
        Assert.assertTrue((boolean)out.isNull[2]);
        Assert.assertFalse((boolean)out.isRepeating);
        b = this.getBatchLongInLongOut();
        out = (LongColumnVector)b.cols[1];
        b.cols[0].isRepeating = true;
        vudf.evaluate(b);
        Assert.assertTrue((b.cols[1].isRepeating && out.vector[0] == 1000L || !b.cols[1].isRepeating && out.vector[2] == 1000L ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)b.size);
    }

    @Test
    public void testMultiArgumentUDF() {
        PrimitiveTypeInfo typeInfoStr = TypeInfoFactory.stringTypeInfo;
        PrimitiveTypeInfo typeInfoLong = TypeInfoFactory.longTypeInfo;
        PrimitiveTypeInfo typeInfoDbl = TypeInfoFactory.doubleTypeInfo;
        GenericUDFBridge genericUDFBridge = new GenericUDFBridge("testudf", false, ConcatTextLongDoubleUDF.class.getName());
        ArrayList<ExprNodeColumnDesc> children = new ArrayList<ExprNodeColumnDesc>();
        children.add(new ExprNodeColumnDesc((TypeInfo)typeInfoStr, "col0", "tablename", false));
        children.add(new ExprNodeColumnDesc((TypeInfo)typeInfoLong, "col1", "tablename", false));
        children.add(new ExprNodeColumnDesc((TypeInfo)typeInfoDbl, "col2", "tablename", false));
        VectorUDFArgDesc[] argDescs = new VectorUDFArgDesc[3];
        for (int i = 0; i < 3; ++i) {
            argDescs[i] = new VectorUDFArgDesc();
            argDescs[i].setVariable(i);
        }
        ExprNodeGenericFuncDesc funcDesc = new ExprNodeGenericFuncDesc((TypeInfo)typeInfoStr, (GenericUDF)genericUDFBridge, genericUDFBridge.getUdfName(), children);
        VectorUDFAdaptor vudf = null;
        try {
            vudf = new VectorUDFAdaptor(funcDesc, 3, "String", argDescs);
        }
        catch (HiveException e) {
            Assert.assertTrue((boolean)false);
            throw new RuntimeException(e);
        }
        VectorizedRowBatch b = this.getBatchStrDblLongWithStrOut();
        vudf.evaluate(b);
        byte[] result = null;
        byte[] result2 = null;
        try {
            result = "red:1:1.0".getBytes("UTF-8");
            result2 = "blue:0:0.0".getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        BytesColumnVector out = (BytesColumnVector)b.cols[3];
        int cmp = StringExpr.compare((byte[])result, (int)0, (int)result.length, (byte[])out.vector[1], (int)out.start[1], (int)out.length[1]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)out.noNulls);
        b = this.getBatchStrDblLongWithStrOut();
        b.cols[1].noNulls = false;
        vudf.evaluate(b);
        out = (BytesColumnVector)b.cols[3];
        Assert.assertFalse((boolean)out.noNulls);
        Assert.assertTrue((boolean)out.isNull[1]);
        b = this.getBatchStrDblLongWithStrOut();
        b.cols[0].isRepeating = true;
        b.cols[1].isRepeating = true;
        b.cols[2].isRepeating = true;
        vudf.evaluate(b);
        out = (BytesColumnVector)b.cols[3];
        Assert.assertTrue((boolean)out.isRepeating);
        cmp = StringExpr.compare((byte[])result2, (int)0, (int)result2.length, (byte[])out.vector[0], (int)out.start[0], (int)out.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((boolean)out.noNulls);
    }

    private VectorizedRowBatch getBatchLongInLongOut() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        LongColumnVector in = new LongColumnVector();
        LongColumnVector out = new LongColumnVector();
        b.cols[0] = in;
        b.cols[1] = out;
        in.vector[0] = 0L;
        in.vector[1] = 1L;
        in.vector[2] = 2L;
        in.isNull[2] = true;
        in.noNulls = true;
        b.size = 3;
        return b;
    }

    private VectorizedRowBatch getBatchStrDblLongWithStrOut() {
        VectorizedRowBatch b = new VectorizedRowBatch(4);
        BytesColumnVector strCol = new BytesColumnVector();
        LongColumnVector longCol = new LongColumnVector();
        DoubleColumnVector dblCol = new DoubleColumnVector();
        BytesColumnVector outCol = new BytesColumnVector();
        b.cols[0] = strCol;
        b.cols[1] = longCol;
        b.cols[2] = dblCol;
        b.cols[3] = outCol;
        strCol.initBuffer();
        strCol.setVal(0, blue, 0, blue.length);
        strCol.setVal(1, red, 0, red.length);
        longCol.vector[0] = 0L;
        longCol.vector[1] = 1L;
        dblCol.vector[0] = 0.0;
        dblCol.vector[1] = 1.0;
        longCol.isNull[1] = true;
        longCol.noNulls = true;
        strCol.noNulls = true;
        dblCol.noNulls = true;
        outCol.initBuffer();
        b.size = 2;
        return b;
    }

    @Test
    public void testGenericUDF() {
        GenericUDFIsNull genericUDF = new GenericUDFIsNull();
        PrimitiveTypeInfo typeInfoStr = TypeInfoFactory.stringTypeInfo;
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(new ExprNodeColumnDesc((TypeInfo)typeInfoStr, "col0", "tablename", false));
        children.add(new ExprNodeConstantDesc((TypeInfo)typeInfoStr, (Object)"UNKNOWN"));
        VectorUDFArgDesc[] argDescs = new VectorUDFArgDesc[2];
        for (int i = 0; i < 2; ++i) {
            argDescs[i] = new VectorUDFArgDesc();
        }
        argDescs[0].setVariable(0);
        argDescs[1].setConstant((ExprNodeConstantDesc)children.get(1));
        ExprNodeGenericFuncDesc funcDesc = new ExprNodeGenericFuncDesc((TypeInfo)typeInfoStr, (GenericUDF)genericUDF, "myisnull", children);
        VectorUDFAdaptor vudf = null;
        try {
            vudf = new VectorUDFAdaptor(funcDesc, 3, "String", argDescs);
        }
        catch (HiveException e) {
            Assert.assertTrue((boolean)false);
        }
        byte[] red = null;
        byte[] unknown = null;
        try {
            red = "red".getBytes("UTF-8");
            unknown = "UNKNOWN".getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        VectorizedRowBatch b = this.getBatchStrDblLongWithStrOut();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        vudf.evaluate(b);
        BytesColumnVector out = (BytesColumnVector)b.cols[3];
        int cmp = StringExpr.compare((byte[])red, (int)0, (int)red.length, (byte[])out.vector[1], (int)out.start[1], (int)out.length[1]);
        Assert.assertEquals((long)0L, (long)cmp);
        cmp = StringExpr.compare((byte[])unknown, (int)0, (int)unknown.length, (byte[])out.vector[0], (int)out.start[0], (int)out.length[0]);
        Assert.assertEquals((long)0L, (long)cmp);
        Assert.assertTrue((out.noNulls || !out.isNull[0] ? 1 : 0) != 0);
    }

    static {
        try {
            blue = "blue".getBytes("UTF-8");
            red = "red".getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

