/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.mapping.Mappings;

public class JoinPushThroughJoinRule
extends RelOptRule {
    public static final RelOptRule RIGHT = new JoinPushThroughJoinRule("JoinPushThroughJoinRule:right", true, LogicalJoin.class, RelFactories.LOGICAL_BUILDER);
    public static final RelOptRule LEFT = new JoinPushThroughJoinRule("JoinPushThroughJoinRule:left", false, LogicalJoin.class, RelFactories.LOGICAL_BUILDER);
    private final boolean right;

    public JoinPushThroughJoinRule(String description, boolean right, Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory) {
        super(JoinPushThroughJoinRule.operand(clazz, JoinPushThroughJoinRule.operand(clazz, JoinPushThroughJoinRule.any()), JoinPushThroughJoinRule.operand(RelNode.class, JoinPushThroughJoinRule.any())), relBuilderFactory, description);
        this.right = right;
    }

    @Deprecated
    public JoinPushThroughJoinRule(String description, boolean right, Class<? extends Join> clazz, RelFactories.ProjectFactory projectFactory) {
        this(description, right, clazz, RelBuilder.proto(projectFactory));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        if (this.right) {
            this.onMatchRight(call);
        } else {
            this.onMatchLeft(call);
        }
    }

    private void onMatchRight(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Join bottomJoin = (Join)call.rel(1);
        Object relC = call.rel(2);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelOptCluster cluster = topJoin.getCluster();
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet bBitSet = ImmutableBitSet.range(aCount, aCount + bCount);
        if (topJoin.getJoinType() != JoinRelType.INNER || bottomJoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> intersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> nonIntersecting = new ArrayList<RexNode>();
        JoinPushThroughJoinRule.split(topJoin.getCondition(), bBitSet, intersecting, nonIntersecting);
        if (nonIntersecting.isEmpty()) {
            return;
        }
        ArrayList<RexNode> bottomIntersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> bottomNonIntersecting = new ArrayList<RexNode>();
        JoinPushThroughJoinRule.split(bottomJoin.getCondition(), bBitSet, bottomIntersecting, bottomNonIntersecting);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount, aCount + bCount, cCount);
        ArrayList<RexNode> newBottomList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relA, relC}).visitList(nonIntersecting, newBottomList);
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relA, relC}).visitList(bottomNonIntersecting, newBottomList);
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList, false);
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relA, (RelNode)relC, bottomJoin.getJoinType(), bottomJoin.isSemiJoinDone());
        Mappings.TargetMapping topMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        ArrayList<RexNode> newTopList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relB).visitList(intersecting, newTopList);
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relB).visitList(bottomIntersecting, newTopList);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, newTopList, false);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, newBottomJoin, relB, topJoin.getJoinType(), topJoin.isSemiJoinDone());
        assert (!Mappings.isIdentity(topMapping));
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newTopJoin);
        relBuilder.project(relBuilder.fields(topMapping));
        call.transformTo(relBuilder.build());
    }

    private void onMatchLeft(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Join bottomJoin = (Join)call.rel(1);
        Object relC = call.rel(2);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelOptCluster cluster = topJoin.getCluster();
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet aBitSet = ImmutableBitSet.range(aCount);
        if (topJoin.getJoinType() != JoinRelType.INNER || bottomJoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> intersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> nonIntersecting = new ArrayList<RexNode>();
        JoinPushThroughJoinRule.split(topJoin.getCondition(), aBitSet, intersecting, nonIntersecting);
        if (nonIntersecting.isEmpty()) {
            return;
        }
        ArrayList<RexNode> bottomIntersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> bottomNonIntersecting = new ArrayList<RexNode>();
        JoinPushThroughJoinRule.split(bottomJoin.getCondition(), aBitSet, bottomIntersecting, bottomNonIntersecting);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, cCount, aCount, bCount, 0, aCount + bCount, cCount);
        ArrayList<RexNode> newBottomList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relC, relB}).visitList(nonIntersecting, newBottomList);
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relC, relB}).visitList(bottomNonIntersecting, newBottomList);
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList, false);
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, (RelNode)relC, relB, bottomJoin.getJoinType(), bottomJoin.isSemiJoinDone());
        Mappings.TargetMapping topMapping = Mappings.createShiftMapping(aCount + bCount + cCount, cCount + bCount, 0, aCount, cCount, aCount, bCount, 0, aCount + bCount, cCount);
        ArrayList<RexNode> newTopList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relA).visitList(intersecting, newTopList);
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relA).visitList(bottomIntersecting, newTopList);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, newTopList, false);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, newBottomJoin, relA, topJoin.getJoinType(), topJoin.isSemiJoinDone());
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newTopJoin);
        relBuilder.project(relBuilder.fields(topMapping));
        call.transformTo(relBuilder.build());
    }

    static void split(RexNode condition, ImmutableBitSet bitSet, List<RexNode> intersecting, List<RexNode> nonIntersecting) {
        for (RexNode node : RelOptUtil.conjunctions(condition)) {
            ImmutableBitSet inputBitSet = RelOptUtil.InputFinder.bits(node);
            if (bitSet.intersects(inputBitSet)) {
                intersecting.add(node);
                continue;
            }
            nonIntersecting.add(node);
        }
    }
}

