/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.initialization.jetty;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.servlet.ServletException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import org.apache.hive.druid.com.fasterxml.jackson.jaxrs.smile.JacksonSmileProvider;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.guice.Jerseys;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.annotations.JSR311Resource;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.guice.annotations.Self;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.RE;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.java.util.metrics.AbstractMonitor;
import org.apache.hive.druid.io.druid.java.util.metrics.MonitorUtils;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.StatusResource;
import org.apache.hive.druid.io.druid.server.initialization.ServerConfig;
import org.apache.hive.druid.io.druid.server.initialization.TLSServerConfig;
import org.apache.hive.druid.io.druid.server.initialization.jetty.CustomExceptionMapper;
import org.apache.hive.druid.io.druid.server.initialization.jetty.ForbiddenExceptionMapper;
import org.apache.hive.druid.io.druid.server.initialization.jetty.JettyMonitoringConnectionFactory;
import org.apache.hive.druid.io.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.hive.druid.io.druid.server.initialization.jetty.ServletFilterHolder;
import org.apache.hive.druid.io.druid.server.metrics.DataSourceTaskIdHolder;
import org.apache.hive.druid.io.druid.server.metrics.MetricsModule;
import org.apache.hive.druid.io.druid.server.metrics.MonitorsConfig;
import org.apache.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServerModule
extends JerseyServletModule {
    private static final Logger log = new Logger(JettyServerModule.class);
    private static final AtomicInteger activeConnections = new AtomicInteger();

    protected void configureServlets() {
        Binder binder = this.binder();
        JsonConfigProvider.bind(binder, "druid.server.http", ServerConfig.class);
        JsonConfigProvider.bind(binder, "druid.server.https", TLSServerConfig.class);
        binder.bind(GuiceContainer.class).to(DruidGuiceContainer.class);
        binder.bind(DruidGuiceContainer.class).in(Scopes.SINGLETON);
        binder.bind(CustomExceptionMapper.class).in(Singleton.class);
        binder.bind(ForbiddenExceptionMapper.class).in(Singleton.class);
        this.serve("/*", new String[0]).with(DruidGuiceContainer.class);
        Jerseys.addResource(binder, StatusResource.class);
        binder.bind(StatusResource.class).in(LazySingleton.class);
        Multibinder.newSetBinder((Binder)binder, Handler.class);
        Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class);
        MetricsModule.register(binder, JettyMonitor.class);
    }

    @Provides
    @LazySingleton
    public Server getServer(Injector injector, Lifecycle lifecycle, @Self DruidNode node, ServerConfig config, TLSServerConfig TLSServerConfig2) {
        return JettyServerModule.makeAndInitializeServer(injector, lifecycle, node, config, TLSServerConfig2, (Binding<SslContextFactory>)injector.getExistingBinding(Key.get(SslContextFactory.class)));
    }

    @Provides
    @Singleton
    public JacksonJsonProvider getJacksonJsonProvider(@Json ObjectMapper objectMapper) {
        JacksonJsonProvider provider = new JacksonJsonProvider();
        provider.setMapper(objectMapper);
        return provider;
    }

    @Provides
    @Singleton
    public JacksonSmileProvider getJacksonSmileProvider(@Smile ObjectMapper objectMapper) {
        JacksonSmileProvider provider = new JacksonSmileProvider();
        provider.setMapper(objectMapper);
        return provider;
    }

    static Server makeAndInitializeServer(Injector injector, Lifecycle lifecycle, final DruidNode node, ServerConfig config, final TLSServerConfig tlsServerConfig, Binding<SslContextFactory> sslContextFactoryBinding) {
        SslContextFactory sslContextFactory;
        QueuedThreadPool threadPool;
        int numServerThreads = config.getNumThreads() + JettyServerModule.getMaxJettyAcceptorsSelectorsNum(node);
        if (config.getQueueSize() == Integer.MAX_VALUE) {
            threadPool = new QueuedThreadPool();
            threadPool.setMinThreads(numServerThreads);
            threadPool.setMaxThreads(numServerThreads);
        } else {
            threadPool = new QueuedThreadPool(numServerThreads, numServerThreads, 60000, new LinkedBlockingQueue(config.getQueueSize()));
        }
        threadPool.setDaemon(true);
        final Server server = new Server((ThreadPool)threadPool);
        server.addBean((Object)new ScheduledExecutorScheduler("JettyScheduler", true), true);
        ArrayList<ServerConnector> serverConnectors = new ArrayList<ServerConnector>();
        if (node.isEnablePlaintextPort()) {
            log.info("Creating http connector with port [%d]", node.getPlaintextPort());
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setRequestHeaderSize(config.getMaxRequestHeaderSize());
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
            connector.setPort(node.getPlaintextPort());
            serverConnectors.add(connector);
        }
        if (node.isEnableTlsPort()) {
            log.info("Creating https connector with port [%d]", node.getTlsPort());
            if (sslContextFactoryBinding == null) {
                sslContextFactory = new SslContextFactory(false);
                sslContextFactory.setKeyStorePath(tlsServerConfig.getKeyStorePath());
                sslContextFactory.setKeyStoreType(tlsServerConfig.getKeyStoreType());
                sslContextFactory.setKeyStorePassword(tlsServerConfig.getKeyStorePasswordProvider().getPassword());
                sslContextFactory.setCertAlias(tlsServerConfig.getCertAlias());
                sslContextFactory.setKeyManagerFactoryAlgorithm(tlsServerConfig.getKeyManagerFactoryAlgorithm() == null ? KeyManagerFactory.getDefaultAlgorithm() : tlsServerConfig.getKeyManagerFactoryAlgorithm());
                sslContextFactory.setKeyManagerPassword(tlsServerConfig.getKeyManagerPasswordProvider() == null ? null : tlsServerConfig.getKeyManagerPasswordProvider().getPassword());
                if (tlsServerConfig.getIncludeCipherSuites() != null) {
                    sslContextFactory.setIncludeCipherSuites(tlsServerConfig.getIncludeCipherSuites().toArray(new String[tlsServerConfig.getIncludeCipherSuites().size()]));
                }
                if (tlsServerConfig.getExcludeCipherSuites() != null) {
                    sslContextFactory.setExcludeCipherSuites(tlsServerConfig.getExcludeCipherSuites().toArray(new String[tlsServerConfig.getExcludeCipherSuites().size()]));
                }
                if (tlsServerConfig.getIncludeProtocols() != null) {
                    sslContextFactory.setIncludeProtocols(tlsServerConfig.getIncludeProtocols().toArray(new String[tlsServerConfig.getIncludeProtocols().size()]));
                }
                if (tlsServerConfig.getExcludeProtocols() != null) {
                    sslContextFactory.setExcludeProtocols(tlsServerConfig.getExcludeProtocols().toArray(new String[tlsServerConfig.getExcludeProtocols().size()]));
                }
            } else {
                sslContextFactory = (SslContextFactory)sslContextFactoryBinding.getProvider().get();
            }
            HttpConfiguration httpsConfiguration = new HttpConfiguration();
            httpsConfiguration.setSecureScheme("https");
            httpsConfiguration.setSecurePort(node.getTlsPort());
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            httpsConfiguration.setRequestHeaderSize(config.getMaxRequestHeaderSize());
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.toString()), new HttpConnectionFactory(httpsConfiguration)});
            connector.setPort(node.getTlsPort());
            serverConnectors.add(connector);
        } else {
            sslContextFactory = null;
        }
        ServerConnector[] connectors = new ServerConnector[serverConnectors.size()];
        int index = 0;
        for (ServerConnector connector : serverConnectors) {
            connectors[index++] = connector;
            connector.setIdleTimeout((long)Ints.checkedCast(config.getMaxIdleTime().toStandardDuration().getMillis()));
            connector.setAcceptorPriorityDelta(-1);
            ArrayList<JettyMonitoringConnectionFactory> monitoredConnFactories = new ArrayList<JettyMonitoringConnectionFactory>();
            for (ConnectionFactory cf : connector.getConnectionFactories()) {
                monitoredConnFactories.add(new JettyMonitoringConnectionFactory(cf, activeConnections));
            }
            connector.setConnectionFactories(monitoredConnFactories);
        }
        server.setConnectors((Connector[])connectors);
        JettyServerInitializer initializer = (JettyServerInitializer)injector.getInstance(JettyServerInitializer.class);
        try {
            initializer.initialize(server, injector);
        }
        catch (Exception e) {
            throw new RE(e, "server initialization exception", new Object[0]);
        }
        lifecycle.addHandler(new Lifecycle.Handler(){

            @Override
            public void start() throws Exception {
                log.info("Starting Jetty Server...", new Object[0]);
                server.start();
                if (node.isEnableTlsPort()) {
                    Preconditions.checkNotNull(sslContextFactory);
                    SSLEngine sslEngine = sslContextFactory.newSSLEngine();
                    if (sslEngine.getEnabledCipherSuites() == null || sslEngine.getEnabledCipherSuites().length == 0) {
                        throw new ISE("No supported cipher suites found, supported suites [%s], configured suites include list: [%s] exclude list: [%s]", Arrays.toString(sslEngine.getSupportedCipherSuites()), tlsServerConfig.getIncludeCipherSuites(), tlsServerConfig.getExcludeCipherSuites());
                    }
                    if (sslEngine.getEnabledProtocols() == null || sslEngine.getEnabledProtocols().length == 0) {
                        throw new ISE("No supported protocols found, supported protocols [%s], configured protocols include list: [%s] exclude list: [%s]", Arrays.toString(sslEngine.getSupportedProtocols()), tlsServerConfig.getIncludeProtocols(), tlsServerConfig.getExcludeProtocols());
                    }
                }
            }

            @Override
            public void stop() {
                try {
                    log.info("Stopping Jetty Server...", new Object[0]);
                    server.stop();
                }
                catch (Exception e) {
                    log.warn(e, "Unable to stop Jetty server.", new Object[0]);
                }
            }
        });
        return server;
    }

    private static int getMaxJettyAcceptorsSelectorsNum(DruidNode druidNode) {
        int numServerConnector = (druidNode.isEnablePlaintextPort() ? 1 : 0) + (druidNode.isEnableTlsPort() ? 1 : 0);
        return numServerConnector * 8;
    }

    @Provides
    @Singleton
    public JettyMonitor getJettyMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        return new JettyMonitor(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId());
    }

    public static class JettyMonitor
    extends AbstractMonitor {
        private final Map<String, String[]> dimensions;

        public JettyMonitor(String dataSource, String taskId) {
            this.dimensions = MonitorsConfig.mapOfDatasourceAndTaskID(dataSource, taskId);
        }

        @Override
        public boolean doMonitor(ServiceEmitter emitter) {
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build("jetty/numOpenConnections", activeConnections.get()));
            return true;
        }
    }

    public static class DruidGuiceContainer
    extends GuiceContainer {
        private final Set<Class<?>> resources;

        @Inject
        public DruidGuiceContainer(Injector injector, @JSR311Resource Set<Class<?>> resources) {
            super(injector);
            this.resources = resources;
        }

        protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
            return new DefaultResourceConfig(this.resources);
        }
    }
}

