/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.scan;

import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.scan.ScanQuery;
import org.apache.hive.druid.io.druid.query.scan.ScanQueryEngine;
import org.apache.hive.druid.io.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.scan.ScanResultValue;
import org.apache.hive.druid.io.druid.segment.Segment;

public class ScanQueryRunnerFactory
implements QueryRunnerFactory<ScanResultValue, ScanQuery> {
    public static final String CTX_TIMEOUT_AT = "timeoutAt";
    public static final String CTX_COUNT = "count";
    private final ScanQueryQueryToolChest toolChest;
    private final ScanQueryEngine engine;

    @Inject
    public ScanQueryRunnerFactory(ScanQueryQueryToolChest toolChest, ScanQueryEngine engine) {
        this.toolChest = toolChest;
        this.engine = engine;
    }

    @Override
    public QueryRunner<ScanResultValue> createRunner(Segment segment) {
        return new ScanQueryRunner(this.engine, segment);
    }

    @Override
    public QueryRunner<ScanResultValue> mergeRunners(ExecutorService queryExecutor, final Iterable<QueryRunner<ScanResultValue>> queryRunners) {
        return new QueryRunner<ScanResultValue>(){

            @Override
            public Sequence<ScanResultValue> run(final QueryPlus<ScanResultValue> queryPlus, final Map<String, Object> responseContext) {
                long timeoutAt = System.currentTimeMillis() + QueryContexts.getTimeout(queryPlus.getQuery());
                responseContext.put(ScanQueryRunnerFactory.CTX_TIMEOUT_AT, timeoutAt);
                return Sequences.concat(Sequences.map(Sequences.simple(queryRunners), new Function<QueryRunner<ScanResultValue>, Sequence<ScanResultValue>>(){

                    @Override
                    public Sequence<ScanResultValue> apply(QueryRunner<ScanResultValue> input) {
                        return input.run(queryPlus, responseContext);
                    }
                }));
            }
        };
    }

    @Override
    public QueryToolChest<ScanResultValue, ScanQuery> getToolchest() {
        return this.toolChest;
    }

    private static class ScanQueryRunner
    implements QueryRunner<ScanResultValue> {
        private final ScanQueryEngine engine;
        private final Segment segment;

        public ScanQueryRunner(ScanQueryEngine engine, Segment segment) {
            this.engine = engine;
            this.segment = segment;
        }

        @Override
        public Sequence<ScanResultValue> run(QueryPlus<ScanResultValue> queryPlus, Map<String, Object> responseContext) {
            Query<ScanResultValue> query = queryPlus.getQuery();
            if (!(query instanceof ScanQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", query.getClass(), ScanQuery.class);
            }
            Number timeoutAt = (Number)responseContext.get(ScanQueryRunnerFactory.CTX_TIMEOUT_AT);
            if (timeoutAt == null || timeoutAt.longValue() == 0L) {
                responseContext.put(ScanQueryRunnerFactory.CTX_TIMEOUT_AT, 0x3FFFFFFFFFFFFFFFL);
            }
            return this.engine.process((ScanQuery)query, this.segment, responseContext);
        }
    }
}

