/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.fun;

import java.util.Arrays;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCallBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlUtil;
import org.apache.hive.druid.org.apache.calcite.sql.SqlWriter;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.hive.druid.org.apache.calcite.sql.util.SqlVisitor;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.hive.druid.org.apache.calcite.util.Static;

public class SqlDotOperator
extends SqlSpecialOperator {
    SqlDotOperator() {
        super("DOT", SqlKind.DOT, 100, true, null, null, null);
    }

    @Override
    public SqlSpecialOperator.ReduceResult reduceExpr(int ordinal, SqlSpecialOperator.TokenSequence list) {
        SqlNode left = list.node(ordinal - 1);
        SqlNode right = list.node(ordinal + 1);
        return new SqlSpecialOperator.ReduceResult(this, ordinal - 1, ordinal + 2, this.createCall(SqlParserPos.sum(Arrays.asList(left.getParserPosition(), right.getParserPosition(), list.pos(ordinal))), left, right));
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, 0);
        writer.sep(".");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(frame);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            argHandler.visitChild(visitor, call, 0, (SqlNode)call.operand(0));
        } else {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType nodeType = validator.deriveType(scope, call.getOperandList().get(0));
        assert (nodeType != null);
        String fieldName = call.getOperandList().get(1).toString();
        RelDataTypeField field = nodeType.getField(fieldName, false, false);
        if (field == null) {
            throw SqlUtil.newContextException(SqlParserPos.ZERO, Static.RESOURCE.unknownField(fieldName));
        }
        RelDataType type = field.getType();
        type = this.adjustType(validator, call, type);
        SqlValidatorUtil.checkCharsetAndCollateConsistentIfCharType(type);
        return type;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        call.getOperandList().get(0).validateExpr(validator, operandScope);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), left);
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            return false;
        }
        RelDataType operandType = callBinding.getOperandType(0);
        SqlSingleOperandTypeChecker checker = this.getChecker(operandType);
        return checker.checkSingleOperandType(callBinding, right, 0, throwOnFailure);
    }

    private SqlSingleOperandTypeChecker getChecker(RelDataType operandType) {
        switch (operandType.getSqlTypeName()) {
            case ROW: {
                return OperandTypes.family(SqlTypeFamily.STRING);
            }
        }
        throw new AssertionError((Object)operandType.getSqlTypeName());
    }

    @Override
    public String getAllowedSignatures(String name) {
        return "<A>.<B>";
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType recordType = opBinding.getOperandType(0);
        switch (recordType.getSqlTypeName()) {
            case ROW: {
                String fieldName = opBinding.getOperandLiteralValue(1, String.class);
                RelDataType type = opBinding.getOperandType(0).getField(fieldName, false, false).getType();
                if (recordType.isNullable()) {
                    return typeFactory.createTypeWithNullability(type, true);
                }
                return type;
            }
        }
        throw new AssertionError();
    }
}

