/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.server.RequestLogLine;
import org.apache.hive.druid.io.druid.server.log.RequestLogger;
import org.apache.hive.druid.io.druid.server.log.RequestLoggerProvider;

@JsonTypeName(value="composing")
public class ComposingRequestLoggerProvider
implements RequestLoggerProvider {
    private static final Logger log = new Logger(ComposingRequestLoggerProvider.class);
    @JsonProperty
    @NotNull
    private final List<RequestLoggerProvider> loggerProviders = Lists.newArrayList();

    public RequestLogger get() {
        ArrayList<RequestLogger> loggers = new ArrayList<RequestLogger>();
        for (RequestLoggerProvider loggerProvider : this.loggerProviders) {
            loggers.add((RequestLogger)loggerProvider.get());
        }
        ComposingRequestLogger logger = new ComposingRequestLogger(loggers);
        log.debug(new Exception("Stack trace"), "Creating %s at", logger);
        return logger;
    }

    public static class ComposingRequestLogger
    implements RequestLogger {
        private final List<RequestLogger> loggers;

        public ComposingRequestLogger(List<RequestLogger> loggers) {
            this.loggers = loggers;
        }

        @Override
        public void log(RequestLogLine requestLogLine) throws IOException {
            Exception exception = null;
            for (RequestLogger logger : this.loggers) {
                try {
                    logger.log(requestLogLine);
                }
                catch (Exception e) {
                    if (exception == null) {
                        exception = e;
                        continue;
                    }
                    exception.addSuppressed(e);
                }
            }
            if (exception != null) {
                Throwables.propagateIfInstanceOf(exception, IOException.class);
                throw Throwables.propagate(exception);
            }
        }

        public String toString() {
            return "ComposingRequestLogger{loggers=" + this.loggers + '}';
        }
    }
}

