/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.metrics;

import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.java.util.metrics.Monitor;

public abstract class CompoundMonitor
implements Monitor {
    private final List<Monitor> monitors;

    public CompoundMonitor(List<Monitor> monitors) {
        this.monitors = monitors;
    }

    public CompoundMonitor(Monitor ... monitors) {
        this(Arrays.asList(monitors));
    }

    @Override
    public void start() {
        for (Monitor monitor : this.monitors) {
            monitor.start();
        }
    }

    @Override
    public void stop() {
        for (Monitor monitor : this.monitors) {
            monitor.stop();
        }
    }

    @Override
    public boolean monitor(final ServiceEmitter emitter) {
        return this.shouldReschedule(Lists.transform(this.monitors, new Function<Monitor, Boolean>(){

            @Override
            public Boolean apply(Monitor monitor) {
                return monitor.monitor(emitter);
            }
        }));
    }

    public abstract boolean shouldReschedule(List<Boolean> var1);
}

