/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import java.util.concurrent.atomic.AtomicInteger;
import org.asynchttpclient.netty.channel.NonBlockingSemaphoreLike;

class NonBlockingSemaphore
implements NonBlockingSemaphoreLike {
    private final AtomicInteger permits;

    public NonBlockingSemaphore(int permits) {
        this.permits = new AtomicInteger(permits);
    }

    @Override
    public void release() {
        this.permits.incrementAndGet();
    }

    @Override
    public boolean tryAcquire() {
        int count;
        do {
            if ((count = this.permits.get()) > 0) continue;
            return false;
        } while (!this.permits.compareAndSet(count, count - 1));
        return true;
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.permits + "]";
    }
}

