/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.virtual;

import java.util.List;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.cache.CacheKeyBuilder;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.VirtualColumn;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.virtual.ExpressionSelectors;

public class ExpressionVirtualColumn
implements VirtualColumn {
    private final String name;
    private final String expression;
    private final ValueType outputType;
    private final Expr parsedExpression;

    @JsonCreator
    public ExpressionVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression, @JsonProperty(value="outputType") ValueType outputType, @JacksonInject ExprMacroTable macroTable) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.expression = Preconditions.checkNotNull(expression, "expression");
        this.outputType = outputType != null ? outputType : ValueType.FLOAT;
        this.parsedExpression = Parser.parse(expression, macroTable);
    }

    @Override
    @JsonProperty(value="name")
    public String getOutputName() {
        return this.name;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty
    public ValueType getOutputType() {
        return this.outputType;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory columnSelectorFactory) {
        return dimensionSpec.decorate(ExpressionSelectors.makeDimensionSelector(columnSelectorFactory, this.parsedExpression, dimensionSpec.getExtractionFn()));
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        return ExpressionSelectors.makeColumnValueSelector(factory, this.parsedExpression);
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        return new ColumnCapabilitiesImpl().setType(this.outputType);
    }

    @Override
    public List<String> requiredColumns() {
        return Parser.findRequiredBindings(this.parsedExpression);
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(1).appendString(this.name).appendString(this.expression).appendString(this.outputType.toString()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionVirtualColumn that = (ExpressionVirtualColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression) && this.outputType == that.outputType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.expression, this.outputType});
    }

    public String toString() {
        return "ExpressionVirtualColumn{name='" + this.name + '\'' + ", expression='" + this.expression + '\'' + ", outputType=" + (Object)((Object)this.outputType) + '}';
    }
}

