/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.transform;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.io.druid.segment.transform.TransformSpec;
import org.apache.hive.druid.io.druid.segment.transform.Transformer;

public class TransformingStringInputRowParser
extends StringInputRowParser {
    private final TransformSpec transformSpec;
    private final Transformer transformer;

    public TransformingStringInputRowParser(ParseSpec parseSpec, String encoding, TransformSpec transformSpec) {
        super(parseSpec, encoding);
        this.transformSpec = transformSpec;
        this.transformer = transformSpec.toTransformer();
    }

    @Override
    public List<InputRow> parseBatch(ByteBuffer input) {
        return super.parseBatch(input).stream().map(this.transformer::transform).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public InputRow parse(@Nullable String input) {
        return this.transformer.transform(super.parse(input));
    }

    @Override
    public StringInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new TransformingStringInputRowParser(parseSpec, this.getEncoding(), this.transformSpec);
    }

    public TransformSpec getTransformSpec() {
        return this.transformSpec;
    }
}

