/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentPublisher;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataSegmentPublisher
implements MetadataSegmentPublisher {
    private static final Logger log = new Logger(SQLMetadataSegmentPublisher.class);
    private final ObjectMapper jsonMapper;
    private final MetadataStorageTablesConfig config;
    private final SQLMetadataConnector connector;
    private final String statement;

    @Inject
    public SQLMetadataSegmentPublisher(ObjectMapper jsonMapper, MetadataStorageTablesConfig config, SQLMetadataConnector connector) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.connector = connector;
        this.statement = StringUtils.format("INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", config.getSegmentsTable(), connector.getQuoteString());
    }

    @Override
    public void publishSegment(DataSegment segment) throws IOException {
        this.publishSegment(segment.getIdentifier(), segment.getDataSource(), DateTimes.nowUtc().toString(), segment.getInterval().getStart().toString(), segment.getInterval().getEnd().toString(), !(segment.getShardSpec() instanceof NoneShardSpec), segment.getVersion(), true, this.jsonMapper.writeValueAsBytes(segment));
    }

    @VisibleForTesting
    void publishSegment(final String identifier, final String dataSource, final String createdDate, final String start, final String end, final boolean partitioned, final String version, final boolean used, final byte[] payload) {
        try {
            DBI dbi = this.connector.getDBI();
            List<Map<String, Object>> exists = dbi.withHandle(new HandleCallback<List<Map<String, Object>>>(){

                @Override
                public List<Map<String, Object>> withHandle(Handle handle) throws Exception {
                    return ((Query)handle.createQuery(StringUtils.format("SELECT id FROM %s WHERE id=:id", SQLMetadataSegmentPublisher.this.config.getSegmentsTable())).bind("id", identifier)).list();
                }
            });
            if (!exists.isEmpty()) {
                log.info("Found [%s] in DB, not updating DB", identifier);
                return;
            }
            dbi.withHandle(new HandleCallback<Void>(){

                @Override
                public Void withHandle(Handle handle) throws Exception {
                    ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(SQLMetadataSegmentPublisher.this.statement).bind("id", identifier)).bind("dataSource", dataSource)).bind("created_date", createdDate)).bind("start", start)).bind("end", end)).bind("partitioned", partitioned)).bind("version", version)).bind("used", used)).bind("payload", payload)).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error(e, "Exception inserting into DB", new Object[0]);
            throw new RuntimeException(e);
        }
    }
}

