/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;

public class PolyBind {
    public static <T> ScopedBindingBuilder createChoice(Binder binder, String property, Key<T> interfaceKey, @Nullable Key<? extends T> defaultKey) {
        ConfiggedProvider<? extends T> provider = new ConfiggedProvider<T>(interfaceKey, property, defaultKey, null);
        return binder.bind(interfaceKey).toProvider(provider);
    }

    @Deprecated
    public static <T> ScopedBindingBuilder createChoiceWithDefault(Binder binder, String property, Key<T> interfaceKey, Key<? extends T> defaultKey, String defaultPropertyValue) {
        return PolyBind.createChoiceWithDefault(binder, property, interfaceKey, defaultPropertyValue);
    }

    public static <T> ScopedBindingBuilder createChoiceWithDefault(Binder binder, String property, Key<T> interfaceKey, String defaultPropertyValue) {
        Preconditions.checkNotNull(defaultPropertyValue);
        ConfiggedProvider<T> provider = new ConfiggedProvider<T>(interfaceKey, property, null, defaultPropertyValue);
        return binder.bind(interfaceKey).toProvider(provider);
    }

    public static <T> MapBinder<String, T> optionBinder(Binder binder, Key<T> interfaceKey) {
        TypeLiteral interfaceType = interfaceKey.getTypeLiteral();
        if (interfaceKey.getAnnotation() != null) {
            return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)interfaceType, (Annotation)interfaceKey.getAnnotation());
        }
        if (interfaceKey.getAnnotationType() != null) {
            return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)interfaceType, (Class)interfaceKey.getAnnotationType());
        }
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)interfaceType);
    }

    static class ConfiggedProvider<T>
    implements Provider<T> {
        private final Key<T> key;
        private final String property;
        @Nullable
        private final Key<? extends T> defaultKey;
        @Nullable
        private final String defaultPropertyValue;
        private Injector injector;
        private Properties props;

        ConfiggedProvider(Key<T> key, String property, @Nullable Key<? extends T> defaultKey, @Nullable String defaultPropertyValue) {
            this.key = key;
            this.property = property;
            this.defaultKey = defaultKey;
            this.defaultPropertyValue = defaultPropertyValue;
        }

        @Inject
        void configure(Injector injector, Properties props) {
            this.injector = injector;
            this.props = props;
        }

        public T get() {
            Provider provider;
            ParameterizedType mapType = Types.mapOf(String.class, (Type)Types.newParameterizedType(Provider.class, (Type[])new Type[]{this.key.getTypeLiteral().getType()}));
            Map implsMap = this.key.getAnnotation() != null ? (Map)this.injector.getInstance(Key.get((Type)mapType, (Annotation)this.key.getAnnotation())) : (this.key.getAnnotationType() != null ? (Map)this.injector.getInstance(Key.get((Type)mapType, (Annotation)this.key.getAnnotation())) : (Map)this.injector.getInstance(Key.get((Type)mapType)));
            String implName = this.props.getProperty(this.property);
            if (implName == null) {
                if (this.defaultPropertyValue == null) {
                    if (this.defaultKey == null) {
                        throw new ProvisionException(StringUtils.format("Some value must be configured for [%s]", this.key));
                    }
                    return (T)this.injector.getInstance(this.defaultKey);
                }
                implName = this.defaultPropertyValue;
            }
            if ((provider = (Provider)implsMap.get(implName)) == null) {
                throw new ProvisionException(StringUtils.format("Unknown provider[%s] of %s, known options[%s]", implName, this.key, implsMap.keySet()));
            }
            return (T)provider.get();
        }
    }
}

