/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.guava;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;

public class ExecutorExecutingSequence<T>
implements Sequence<T> {
    private final Sequence<T> sequence;
    private final ExecutorService exec;

    public ExecutorExecutingSequence(Sequence<T> sequence, ExecutorService exec) {
        this.sequence = sequence;
        this.exec = exec;
    }

    @Override
    public <OutType> OutType accumulate(final OutType initValue, final Accumulator<OutType, T> accumulator) {
        Future future = this.exec.submit(new Callable<OutType>(){

            @Override
            public OutType call() throws Exception {
                return ExecutorExecutingSequence.this.sequence.accumulate(initValue, accumulator);
            }
        });
        try {
            return (OutType)future.get();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(final OutType initValue, final YieldingAccumulator<OutType, T> accumulator) {
        Future future = this.exec.submit(new Callable<Yielder<OutType>>(){

            @Override
            public Yielder<OutType> call() throws Exception {
                return ExecutorExecutingSequence.this.makeYielder(ExecutorExecutingSequence.this.sequence.toYielder(initValue, accumulator));
            }
        });
        try {
            return (Yielder)future.get();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate(e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate(e);
        }
    }

    private <OutType> Yielder<OutType> makeYielder(final Yielder<OutType> yielder) {
        return new Yielder<OutType>(){

            @Override
            public OutType get() {
                return yielder.get();
            }

            @Override
            public Yielder<OutType> next(final OutType initValue) {
                Future future = ExecutorExecutingSequence.this.exec.submit(new Callable<Yielder<OutType>>(){

                    @Override
                    public Yielder<OutType> call() throws Exception {
                        return ExecutorExecutingSequence.this.makeYielder(yielder.next(initValue));
                    }
                });
                try {
                    return (Yielder)future.get();
                }
                catch (InterruptedException e) {
                    throw Throwables.propagate(e);
                }
                catch (ExecutionException e) {
                    throw Throwables.propagate(e);
                }
            }

            @Override
            public boolean isDone() {
                return yielder.isDone();
            }

            @Override
            public void close() throws IOException {
                yielder.close();
            }
        };
    }
}

