/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.emitter;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.initialization.DruidModule;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.emitter.core.ComposingEmitter;
import org.apache.hive.druid.io.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.io.druid.server.emitter.ComposingEmitterConfig;

public class ComposingEmitterModule
implements DruidModule {
    private static Logger log = new Logger(ComposingEmitterModule.class);

    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.emitter.composing", ComposingEmitterConfig.class);
    }

    @Override
    public List<? extends Module> getJacksonModules() {
        return Collections.EMPTY_LIST;
    }

    @Provides
    @ManageLifecycle
    @Named(value="composing")
    public Emitter getEmitter(ComposingEmitterConfig config, final Injector injector) {
        log.info("Creating Composing Emitter with %s", config.getEmitters());
        List<Emitter> emitters = Lists.transform(config.getEmitters(), new Function<String, Emitter>(){

            @Override
            public Emitter apply(String s) {
                return (Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)s)));
            }
        });
        return new ComposingEmitter(emitters);
    }
}

