/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.plumber;

import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.guice.annotations.Processing;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMergerV9;
import org.apache.hive.druid.io.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.io.druid.segment.realtime.SegmentPublisher;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.Plumber;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.PlumberSchool;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.RealtimePlumber;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentAnnouncer;

public class RealtimePlumberSchool
implements PlumberSchool {
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentPusher dataSegmentPusher;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final SegmentPublisher segmentPublisher;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final ExecutorService queryExecutorService;
    private final IndexMergerV9 indexMergerV9;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final ObjectMapper objectMapper;

    @JsonCreator
    public RealtimePlumberSchool(@JacksonInject ServiceEmitter emitter, @JacksonInject QueryRunnerFactoryConglomerate conglomerate, @JacksonInject DataSegmentPusher dataSegmentPusher, @JacksonInject DataSegmentAnnouncer segmentAnnouncer, @JacksonInject SegmentPublisher segmentPublisher, @JacksonInject SegmentHandoffNotifierFactory handoffNotifierFactory, @JacksonInject @Processing ExecutorService executorService, @JacksonInject IndexMergerV9 indexMergerV9, @JacksonInject IndexIO indexIO, @JacksonInject Cache cache, @JacksonInject CacheConfig cacheConfig, @JacksonInject ObjectMapper objectMapper) {
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.dataSegmentPusher = dataSegmentPusher;
        this.segmentAnnouncer = segmentAnnouncer;
        this.segmentPublisher = segmentPublisher;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.queryExecutorService = executorService;
        this.indexMergerV9 = Preconditions.checkNotNull(indexMergerV9, "Null IndexMergerV9");
        this.indexIO = Preconditions.checkNotNull(indexIO, "Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.objectMapper = objectMapper;
    }

    @Override
    public Plumber findPlumber(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        this.verifyState();
        return new RealtimePlumber(schema, config, metrics, this.emitter, this.conglomerate, this.segmentAnnouncer, this.queryExecutorService, this.dataSegmentPusher, this.segmentPublisher, this.handoffNotifierFactory.createSegmentHandoffNotifier(schema.getDataSource()), this.indexMergerV9, this.indexIO, this.cache, this.cacheConfig, this.objectMapper);
    }

    private void verifyState() {
        Preconditions.checkNotNull(this.conglomerate, "must specify a queryRunnerFactoryConglomerate to do this action.");
        Preconditions.checkNotNull(this.dataSegmentPusher, "must specify a segmentPusher to do this action.");
        Preconditions.checkNotNull(this.segmentAnnouncer, "must specify a segmentAnnouncer to do this action.");
        Preconditions.checkNotNull(this.segmentPublisher, "must specify a segmentPublisher to do this action.");
        Preconditions.checkNotNull(this.handoffNotifierFactory, "must specify a handoffNotifierFactory to do this action.");
        Preconditions.checkNotNull(this.emitter, "must specify a serviceEmitter to do this action.");
    }
}

