/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client.cache;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaNodeLocator;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.metrics.MetricCollector;
import net.spy.memcached.metrics.MetricType;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.util.DefaultKetamaNodeLocatorConfiguration;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;

class MemcachedCustomConnectionFactoryBuilder
extends ConnectionFactoryBuilder {
    private int repetitions = new DefaultKetamaNodeLocatorConfiguration().getNodeRepetitions();

    MemcachedCustomConnectionFactoryBuilder() {
    }

    public MemcachedCustomConnectionFactoryBuilder setKetamaNodeRepetitions(int repetitions) {
        this.repetitions = repetitions;
        return this;
    }

    public ConnectionFactory build() {
        return new DefaultConnectionFactory(){

            public NodeLocator createLocator(List<MemcachedNode> nodes) {
                switch (MemcachedCustomConnectionFactoryBuilder.this.locator) {
                    case ARRAY_MOD: {
                        return new ArrayModNodeLocator(nodes, this.getHashAlg());
                    }
                    case CONSISTENT: {
                        return new KetamaNodeLocator(nodes, this.getHashAlg(), (KetamaNodeLocatorConfiguration)new DefaultKetamaNodeLocatorConfiguration(){

                            public int getNodeRepetitions() {
                                return MemcachedCustomConnectionFactoryBuilder.this.repetitions;
                            }
                        });
                    }
                }
                throw new IllegalStateException("Unhandled locator type: " + MemcachedCustomConnectionFactoryBuilder.this.locator);
            }

            public BlockingQueue<Operation> createOperationQueue() {
                return MemcachedCustomConnectionFactoryBuilder.this.opQueueFactory == null ? super.createOperationQueue() : MemcachedCustomConnectionFactoryBuilder.this.opQueueFactory.create();
            }

            public BlockingQueue<Operation> createReadOperationQueue() {
                return MemcachedCustomConnectionFactoryBuilder.this.readQueueFactory == null ? super.createReadOperationQueue() : MemcachedCustomConnectionFactoryBuilder.this.readQueueFactory.create();
            }

            public BlockingQueue<Operation> createWriteOperationQueue() {
                return MemcachedCustomConnectionFactoryBuilder.this.writeQueueFactory == null ? super.createReadOperationQueue() : MemcachedCustomConnectionFactoryBuilder.this.writeQueueFactory.create();
            }

            public Transcoder<Object> getDefaultTranscoder() {
                return MemcachedCustomConnectionFactoryBuilder.this.transcoder == null ? super.getDefaultTranscoder() : MemcachedCustomConnectionFactoryBuilder.this.transcoder;
            }

            public FailureMode getFailureMode() {
                return MemcachedCustomConnectionFactoryBuilder.this.failureMode == null ? super.getFailureMode() : MemcachedCustomConnectionFactoryBuilder.this.failureMode;
            }

            public HashAlgorithm getHashAlg() {
                return MemcachedCustomConnectionFactoryBuilder.this.hashAlg == null ? super.getHashAlg() : MemcachedCustomConnectionFactoryBuilder.this.hashAlg;
            }

            public Collection<ConnectionObserver> getInitialObservers() {
                return MemcachedCustomConnectionFactoryBuilder.this.initialObservers;
            }

            public OperationFactory getOperationFactory() {
                return MemcachedCustomConnectionFactoryBuilder.this.opFact == null ? super.getOperationFactory() : MemcachedCustomConnectionFactoryBuilder.this.opFact;
            }

            public long getOperationTimeout() {
                return MemcachedCustomConnectionFactoryBuilder.this.opTimeout == -1L ? super.getOperationTimeout() : MemcachedCustomConnectionFactoryBuilder.this.opTimeout;
            }

            public int getReadBufSize() {
                return MemcachedCustomConnectionFactoryBuilder.this.readBufSize == -1 ? super.getReadBufSize() : MemcachedCustomConnectionFactoryBuilder.this.readBufSize;
            }

            public boolean isDaemon() {
                return MemcachedCustomConnectionFactoryBuilder.this.isDaemon;
            }

            public boolean shouldOptimize() {
                return MemcachedCustomConnectionFactoryBuilder.this.shouldOptimize;
            }

            public boolean useNagleAlgorithm() {
                return MemcachedCustomConnectionFactoryBuilder.this.useNagle;
            }

            public long getMaxReconnectDelay() {
                return MemcachedCustomConnectionFactoryBuilder.this.maxReconnectDelay;
            }

            public AuthDescriptor getAuthDescriptor() {
                return MemcachedCustomConnectionFactoryBuilder.this.authDescriptor;
            }

            public long getOpQueueMaxBlockTime() {
                return MemcachedCustomConnectionFactoryBuilder.this.opQueueMaxBlockTime > -1L ? MemcachedCustomConnectionFactoryBuilder.this.opQueueMaxBlockTime : super.getOpQueueMaxBlockTime();
            }

            public int getTimeoutExceptionThreshold() {
                return MemcachedCustomConnectionFactoryBuilder.this.timeoutExceptionThreshold;
            }

            public MetricType enableMetrics() {
                return MemcachedCustomConnectionFactoryBuilder.this.metricType == null ? super.enableMetrics() : MemcachedCustomConnectionFactoryBuilder.this.metricType;
            }

            public MetricCollector getMetricCollector() {
                return MemcachedCustomConnectionFactoryBuilder.this.collector == null ? super.getMetricCollector() : MemcachedCustomConnectionFactoryBuilder.this.collector;
            }

            public ExecutorService getListenerExecutorService() {
                return MemcachedCustomConnectionFactoryBuilder.this.executorService == null ? super.getListenerExecutorService() : MemcachedCustomConnectionFactoryBuilder.this.executorService;
            }

            public boolean isDefaultExecutorService() {
                return MemcachedCustomConnectionFactoryBuilder.this.executorService == null;
            }

            public long getAuthWaitTime() {
                return MemcachedCustomConnectionFactoryBuilder.this.authWaitTime;
            }
        };
    }
}

