/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonToken;
import org.apache.hive.druid.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hive.druid.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import org.apache.hive.druid.com.google.common.net.HostAndPort;

public class HostAndPortDeserializer
extends FromStringDeserializer<HostAndPort> {
    private static final long serialVersionUID = 1L;
    public static final HostAndPortDeserializer std = new HostAndPortDeserializer();

    public HostAndPortDeserializer() {
        super(HostAndPort.class);
    }

    @Override
    public HostAndPort deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            JsonNode root = (JsonNode)jp.readValueAsTree();
            String host = root.path("hostText").asText();
            JsonNode n = root.get("port");
            if (n == null) {
                return HostAndPort.fromString(host);
            }
            return HostAndPort.fromParts(host, n.asInt());
        }
        return (HostAndPort)super.deserialize(jp, ctxt);
    }

    @Override
    protected HostAndPort _deserialize(String value, DeserializationContext ctxt) throws IOException {
        return HostAndPort.fromString(value);
    }
}

