/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelId;
import org.apache.hive.druid.io.netty.channel.DefaultChannelId;
import org.apache.hive.druid.io.netty.util.Attribute;
import org.apache.hive.druid.io.netty.util.AttributeKey;
import org.asynchttpclient.netty.DiscardEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channels {
    private static final Logger LOGGER = LoggerFactory.getLogger(Channels.class);
    private static final AttributeKey<Object> DEFAULT_ATTRIBUTE = AttributeKey.valueOf("default");
    private static final AttributeKey<ChannelId> CHANNEL_ID_ATTRIBUTE = AttributeKey.valueOf("channelId");
    private static final AttributeKey<Inactive> INACTIVE_TOKEN_ATTRIBUTE = AttributeKey.valueOf("inactiveToken");

    public static Object getAttribute(Channel channel) {
        Attribute<Object> attr = channel.attr(DEFAULT_ATTRIBUTE);
        return attr != null ? attr.get() : null;
    }

    public static void setAttribute(Channel channel, Object o) {
        channel.attr(DEFAULT_ATTRIBUTE).set(o);
    }

    public static void setDiscard(Channel channel) {
        Channels.setAttribute(channel, (Object)DiscardEvent.INSTANCE);
    }

    public static boolean isChannelValid(Channel channel) {
        return channel != null && channel.isActive();
    }

    public static void setInactiveToken(Channel channel) {
        channel.attr(INACTIVE_TOKEN_ATTRIBUTE).set(Inactive.INSTANCE);
    }

    public static boolean getInactiveToken(Channel channel) {
        return channel != null && channel.attr(INACTIVE_TOKEN_ATTRIBUTE).getAndSet(null) != null;
    }

    public static ChannelId getChannelId(Channel channel) {
        Attribute<ChannelId> attr = channel.attr(CHANNEL_ID_ATTRIBUTE);
        return attr != null ? attr.get() : null;
    }

    public static void initChannelId(Channel channel) {
        channel.attr(CHANNEL_ID_ATTRIBUTE).set(new DefaultChannelId());
    }

    public static void silentlyCloseChannel(Channel channel) {
        try {
            if (channel != null && channel.isActive()) {
                channel.close();
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Failed to close channel", t);
        }
    }

    private static enum Inactive {
        INSTANCE;

    }
}

