/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql2rel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.AggregateCall;
import org.apache.hive.druid.org.apache.calcite.rel.core.CorrelationId;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.core.SemiJoin;
import org.apache.hive.druid.org.apache.calcite.rel.core.SetOp;
import org.apache.hive.druid.org.apache.calcite.rel.core.Sort;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableScan;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalValues;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexCorrelVariable;
import org.apache.hive.druid.org.apache.calcite.rex.RexDynamicParam;
import org.apache.hive.druid.org.apache.calcite.rex.RexFieldAccess;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.hive.druid.org.apache.calcite.rex.RexUtil;
import org.apache.hive.druid.org.apache.calcite.sql.SqlExplainFormat;
import org.apache.hive.druid.org.apache.calcite.sql.SqlExplainLevel;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql2rel.CorrelationReferenceFinder;
import org.apache.hive.druid.org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.ReflectUtil;
import org.apache.hive.druid.org.apache.calcite.util.ReflectiveVisitor;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.apache.hive.druid.org.apache.calcite.util.mapping.IntPair;
import org.apache.hive.druid.org.apache.calcite.util.mapping.Mapping;
import org.apache.hive.druid.org.apache.calcite.util.mapping.MappingType;
import org.apache.hive.druid.org.apache.calcite.util.mapping.Mappings;

public class RelFieldTrimmer
implements ReflectiveVisitor {
    private final ReflectUtil.MethodDispatcher<TrimResult> trimFieldsDispatcher;
    private final RelBuilder relBuilder;

    public RelFieldTrimmer(SqlValidator validator, RelBuilder relBuilder) {
        Util.discard(validator);
        this.relBuilder = relBuilder;
        this.trimFieldsDispatcher = ReflectUtil.createMethodDispatcher(TrimResult.class, this, "trimFields", RelNode.class, ImmutableBitSet.class, Set.class);
    }

    @Deprecated
    public RelFieldTrimmer(SqlValidator validator, RelOptCluster cluster, RelFactories.ProjectFactory projectFactory, RelFactories.FilterFactory filterFactory, RelFactories.JoinFactory joinFactory, RelFactories.SemiJoinFactory semiJoinFactory, RelFactories.SortFactory sortFactory, RelFactories.AggregateFactory aggregateFactory, RelFactories.SetOpFactory setOpFactory) {
        this(validator, RelBuilder.proto(projectFactory, filterFactory, joinFactory, semiJoinFactory, sortFactory, aggregateFactory, setOpFactory).create(cluster, null));
    }

    public RelNode trim(RelNode root) {
        int fieldCount = root.getRowType().getFieldCount();
        ImmutableBitSet fieldsUsed = ImmutableBitSet.range(fieldCount);
        Set<RelDataTypeField> extraFields = Collections.emptySet();
        TrimResult trimResult = this.dispatchTrimFields(root, fieldsUsed, extraFields);
        if (!((Mapping)trimResult.right).isIdentity()) {
            throw new IllegalArgumentException();
        }
        if (SqlToRelConverter.SQL2REL_LOGGER.isDebugEnabled()) {
            SqlToRelConverter.SQL2REL_LOGGER.debug(RelOptUtil.dumpPlan("Plan after trimming unused fields", (RelNode)trimResult.left, SqlExplainFormat.TEXT, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        return (RelNode)trimResult.left;
    }

    protected TrimResult trimChild(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        final ImmutableBitSet.Builder fieldsUsedBuilder = fieldsUsed.rebuild();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        ImmutableList<RelCollation> collations = mq.collations(input);
        for (RelCollation collation : collations) {
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                fieldsUsedBuilder.set(fieldCollation.getFieldIndex());
            }
        }
        for (final CorrelationId correlation : rel.getVariablesSet()) {
            rel.accept(new CorrelationReferenceFinder(){

                @Override
                protected RexNode handle(RexFieldAccess fieldAccess) {
                    RexCorrelVariable v = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                    if (v.id.equals(correlation)) {
                        fieldsUsedBuilder.set(fieldAccess.getField().getIndex());
                    }
                    return fieldAccess;
                }
            });
        }
        return this.dispatchTrimFields(input, fieldsUsedBuilder.build(), extraFields);
    }

    protected TrimResult trimChildRestore(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = this.trimChild(rel, input, fieldsUsed, extraFields);
        if (((Mapping)trimResult.right).isIdentity()) {
            return trimResult;
        }
        RelDataType rowType = input.getRowType();
        List<RelDataTypeField> fieldList = rowType.getFieldList();
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        List<String> nameList = rowType.getFieldNames();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        assert (((Mapping)trimResult.right).getSourceCount() == fieldList.size());
        for (int i = 0; i < fieldList.size(); ++i) {
            int source = ((Mapping)trimResult.right).getTargetOpt(i);
            RelDataTypeField field = fieldList.get(i);
            exprList.add(source < 0 ? rexBuilder.makeZeroLiteral(field.getType()) : rexBuilder.makeInputRef(field.getType(), source));
        }
        this.relBuilder.push((RelNode)trimResult.left).project(exprList, nameList);
        return this.result(this.relBuilder.build(), Mappings.createIdentity(fieldList.size()));
    }

    protected final TrimResult dispatchTrimFields(RelNode rel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = this.trimFieldsDispatcher.invoke(rel, fieldsUsed, extraFields);
        RelNode newRel = (RelNode)trimResult.left;
        Mapping mapping = (Mapping)trimResult.right;
        int fieldCount = rel.getRowType().getFieldCount();
        assert (mapping.getSourceCount() == fieldCount) : "source: " + mapping.getSourceCount() + " != " + fieldCount;
        int newFieldCount = newRel.getRowType().getFieldCount();
        assert (mapping.getTargetCount() + extraFields.size() == newFieldCount) : "target: " + mapping.getTargetCount() + " + " + extraFields.size() + " != " + newFieldCount;
        if (newRel.equals(rel)) {
            return this.result(rel, mapping);
        }
        return trimResult;
    }

    protected TrimResult result(RelNode r, final Mapping mapping) {
        final RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        for (final CorrelationId correlation : r.getVariablesSet()) {
            r = r.accept(new CorrelationReferenceFinder(){

                @Override
                protected RexNode handle(RexFieldAccess fieldAccess) {
                    RexCorrelVariable v = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                    if (v.id.equals(correlation) && v.getType().getFieldCount() == mapping.getSourceCount()) {
                        int old = fieldAccess.getField().getIndex();
                        int new_ = mapping.getTarget(old);
                        RelDataTypeFactory.FieldInfoBuilder typeBuilder = RelFieldTrimmer.this.relBuilder.getTypeFactory().builder();
                        for (int target : Util.range(mapping.getTargetCount())) {
                            ((RelDataTypeFactory.Builder)typeBuilder).add(v.getType().getFieldList().get(mapping.getSource(target)));
                        }
                        RexNode newV = rexBuilder.makeCorrel(typeBuilder.build(), v.id);
                        if (old != new_) {
                            return rexBuilder.makeFieldAccess(newV, new_);
                        }
                    }
                    return fieldAccess;
                }
            });
        }
        return new TrimResult(r, mapping);
    }

    public TrimResult trimFields(RelNode rel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(fieldsUsed);
        return this.result(rel, Mappings.createIdentity(rel.getRowType().getFieldCount()));
    }

    public TrimResult trimFields(Project project, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = project.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = project.getInput();
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields);
        for (Ord<RexNode> ord : Ord.zip(project.getProjects())) {
            if (!fieldsUsed.get(ord.i)) continue;
            ((RexNode)ord.e).accept(inputFinder);
        }
        ImmutableBitSet inputFieldsUsed = inputFinder.inputBitSet.build();
        TrimResult trimResult = this.trimChild(project, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return this.result(project, Mappings.createIdentity(fieldCount));
        }
        if (fieldsUsed.cardinality() == 0) {
            return this.dummyProject(fieldCount, newInput);
        }
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, newInput);
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, fieldsUsed.cardinality());
        for (Ord<RexNode> ord : Ord.zip(project.getProjects())) {
            if (!fieldsUsed.get(ord.i)) continue;
            mapping.set(ord.i, newProjects.size());
            RexNode newProjectExpr = ((RexNode)ord.e).accept(shuttle);
            newProjects.add(newProjectExpr);
        }
        RelDataType newRowType = RelOptUtil.permute(project.getCluster().getTypeFactory(), rowType, mapping);
        this.relBuilder.push(newInput);
        this.relBuilder.project(newProjects, newRowType.getFieldNames());
        return this.result(this.relBuilder.build(), mapping);
    }

    protected TrimResult dummyProject(int fieldCount, RelNode input) {
        RelOptCluster cluster = input.getCluster();
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, 1);
        if (input.getRowType().getFieldCount() == 1) {
            return this.result(input, mapping);
        }
        RexLiteral expr = cluster.getRexBuilder().makeExactLiteral(BigDecimal.ZERO);
        this.relBuilder.push(input);
        this.relBuilder.project(ImmutableList.of(expr), ImmutableList.of("DUMMY"));
        return this.result(this.relBuilder.build(), mapping);
    }

    public TrimResult trimFields(Filter filter, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = filter.getRowType();
        int fieldCount = rowType.getFieldCount();
        RexNode conditionExpr = filter.getCondition();
        RelNode input = filter.getInput();
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields);
        inputFinder.inputBitSet.addAll(fieldsUsed);
        conditionExpr.accept(inputFinder);
        ImmutableBitSet inputFieldsUsed = inputFinder.inputBitSet.build();
        TrimResult trimResult = this.trimChild(filter, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return this.result(filter, Mappings.createIdentity(fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, newInput);
        RexNode newConditionExpr = conditionExpr.accept(shuttle);
        this.relBuilder.push(filter.copy(filter.getTraitSet(), newInput, newConditionExpr));
        return this.result(this.relBuilder.build(), inputMapping);
    }

    public TrimResult trimFields(Sort sort, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = sort.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelCollation collation = sort.getCollation();
        RelNode input = sort.getInput();
        ImmutableBitSet.Builder inputFieldsUsed = fieldsUsed.rebuild();
        for (RelFieldCollation field : collation.getFieldCollations()) {
            inputFieldsUsed.set(field.getFieldIndex());
        }
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(sort, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && inputMapping.isIdentity() && fieldsUsed.cardinality() == fieldCount) {
            return this.result(sort, Mappings.createIdentity(fieldCount));
        }
        if (sort.offset instanceof RexDynamicParam || sort.fetch instanceof RexDynamicParam) {
            return this.result(sort, inputMapping);
        }
        this.relBuilder.push(newInput);
        int offset = sort.offset == null ? 0 : RexLiteral.intValue(sort.offset);
        int fetch = sort.fetch == null ? -1 : RexLiteral.intValue(sort.fetch);
        ImmutableList<RexNode> fields = this.relBuilder.fields(RexUtil.apply((Mappings.TargetMapping)inputMapping, collation));
        this.relBuilder.sortLimit(offset, fetch, fields);
        return this.result(this.relBuilder.build(), inputMapping);
    }

    public TrimResult trimFields(Join join, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = join.getSystemFieldList().size() + join.getLeft().getRowType().getFieldCount() + join.getRight().getRowType().getFieldCount();
        RexNode conditionExpr = join.getCondition();
        int systemFieldCount = join.getSystemFieldList().size();
        LinkedHashSet<RelDataTypeField> combinedInputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(combinedInputExtraFields);
        inputFinder.inputBitSet.addAll(fieldsUsed);
        conditionExpr.accept(inputFinder);
        ImmutableBitSet fieldsUsedPlus = inputFinder.inputBitSet.build();
        int systemFieldUsedCount = 0;
        for (int i = 0; i < systemFieldCount; ++i) {
            if (!fieldsUsed.get(i)) continue;
            ++systemFieldUsedCount;
        }
        int newSystemFieldCount = systemFieldUsedCount == 0 ? 0 : systemFieldCount;
        int offset = systemFieldCount;
        int changeCount = 0;
        int newFieldCount = newSystemFieldCount;
        ArrayList<Object> newInputs = new ArrayList<Object>(2);
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        ArrayList<Integer> inputExtraFieldCounts = new ArrayList<Integer>();
        for (RelNode input : join.getInputs()) {
            RelDataType inputRowType = input.getRowType();
            int inputFieldCount = inputRowType.getFieldCount();
            ImmutableBitSet.Builder inputFieldsUsed = ImmutableBitSet.builder();
            for (int bit : fieldsUsedPlus) {
                if (bit < offset || bit >= offset + inputFieldCount) continue;
                inputFieldsUsed.set(bit - offset);
            }
            inputFieldsUsed.set(0, newSystemFieldCount);
            Set<RelDataTypeField> inputExtraFields = RelDataTypeImpl.extra(inputRowType) == null ? Collections.emptySet() : combinedInputExtraFields;
            inputExtraFieldCounts.add(inputExtraFields.size());
            TrimResult trimResult = this.trimChild(join, input, inputFieldsUsed.build(), inputExtraFields);
            newInputs.add(trimResult.left);
            if (trimResult.left != input) {
                ++changeCount;
            }
            Mapping inputMapping = (Mapping)trimResult.right;
            inputMappings.add(inputMapping);
            offset += inputFieldCount;
            newFieldCount += inputMapping.getTargetCount() + inputExtraFields.size();
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, newFieldCount);
        for (int i = 0; i < newSystemFieldCount; ++i) {
            mapping.set(i, i);
        }
        offset = systemFieldCount;
        int newOffset = newSystemFieldCount;
        for (int i = 0; i < inputMappings.size(); ++i) {
            Mapping inputMapping = (Mapping)inputMappings.get(i);
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source + offset, pair.target + newOffset);
            }
            offset += inputMapping.getSourceCount();
            newOffset += inputMapping.getTargetCount() + (Integer)inputExtraFieldCounts.get(i);
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            return this.result(join, Mappings.createIdentity(fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)mapping, (RelNode)newInputs.get(0), (RelNode)newInputs.get(1));
        RexNode newConditionExpr = conditionExpr.accept(shuttle);
        this.relBuilder.push((RelNode)newInputs.get(0));
        this.relBuilder.push((RelNode)newInputs.get(1));
        if (join instanceof SemiJoin) {
            this.relBuilder.semiJoin(newConditionExpr);
            Mapping inputMapping = (Mapping)inputMappings.get(0);
            mapping = Mappings.create(MappingType.INVERSE_SURJECTION, join.getRowType().getFieldCount(), newSystemFieldCount + inputMapping.getTargetCount());
            for (int i = 0; i < newSystemFieldCount; ++i) {
                mapping.set(i, i);
            }
            offset = systemFieldCount;
            newOffset = newSystemFieldCount;
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source + offset, pair.target + newOffset);
            }
        } else {
            this.relBuilder.join(join.getJoinType(), newConditionExpr);
        }
        return this.result(this.relBuilder.build(), mapping);
    }

    public TrimResult trimFields(SetOp setOp, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = setOp.getRowType();
        int fieldCount = rowType.getFieldCount();
        int changeCount = 0;
        if (fieldsUsed.isEmpty()) {
            fieldsUsed = ImmutableBitSet.of(rowType.getFieldCount() - 1);
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        for (RelNode input : setOp.getInputs()) {
            TrimResult trimResult = this.trimChild(setOp, input, fieldsUsed, extraFields);
            Mapping remaining = Mappings.divide(mapping, (Mapping)trimResult.right);
            this.relBuilder.push((RelNode)trimResult.left);
            this.relBuilder.permute(remaining);
            if (input == this.relBuilder.peek()) continue;
            ++changeCount;
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            for (RelNode input : setOp.getInputs()) {
                this.relBuilder.build();
            }
            return this.result(setOp, mapping);
        }
        switch (setOp.kind) {
            case UNION: {
                this.relBuilder.union(setOp.all, setOp.getInputs().size());
                break;
            }
            case INTERSECT: {
                this.relBuilder.intersect(setOp.all, setOp.getInputs().size());
                break;
            }
            case EXCEPT: {
                assert (setOp.getInputs().size() == 2);
                this.relBuilder.minus(setOp.all);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown setOp " + setOp));
            }
        }
        return this.result(this.relBuilder.build(), mapping);
    }

    public TrimResult trimFields(Aggregate aggregate, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = aggregate.getRowType();
        ImmutableBitSet.Builder inputFieldsUsed = aggregate.getGroupSet().rebuild();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            for (int i : aggCall.getArgList()) {
                inputFieldsUsed.set(i);
            }
            if (aggCall.filterArg < 0) continue;
            inputFieldsUsed.set(aggCall.filterArg);
        }
        RelNode input = aggregate.getInput();
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(aggregate, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        final Mapping inputMapping = (Mapping)trimResult.right;
        int groupCount = aggregate.getGroupSet().cardinality();
        int indicatorCount = aggregate.getIndicatorCount();
        fieldsUsed = fieldsUsed.union(ImmutableBitSet.range(groupCount + indicatorCount));
        if (input == newInput && fieldsUsed.equals(ImmutableBitSet.range(rowType.getFieldCount()))) {
            return this.result(aggregate, Mappings.createIdentity(rowType.getFieldCount()));
        }
        int j = groupCount + indicatorCount;
        int usedAggCallCount = 0;
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            if (!fieldsUsed.get(j++)) continue;
            ++usedAggCallCount;
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, rowType.getFieldCount(), groupCount + indicatorCount + usedAggCallCount);
        ImmutableBitSet newGroupSet = Mappings.apply(inputMapping, aggregate.getGroupSet());
        ImmutableList<ImmutableBitSet> newGroupSets = ImmutableList.copyOf(Iterables.transform(aggregate.getGroupSets(), new Function<ImmutableBitSet, ImmutableBitSet>(){

            @Override
            public ImmutableBitSet apply(ImmutableBitSet input) {
                return Mappings.apply(inputMapping, input);
            }
        }));
        for (j = 0; j < groupCount + indicatorCount; ++j) {
            mapping.set(j, j);
        }
        this.relBuilder.push(newInput);
        ArrayList<RelBuilder.AggCall> newAggCallList = new ArrayList<RelBuilder.AggCall>();
        j = groupCount + indicatorCount;
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (fieldsUsed.get(j)) {
                ImmutableList<RexNode> args = this.relBuilder.fields(Mappings.apply2(inputMapping, aggCall.getArgList()));
                RexInputRef filterArg = aggCall.filterArg < 0 ? null : this.relBuilder.field(Mappings.apply((Mappings.TargetMapping)inputMapping, aggCall.filterArg));
                RelBuilder.AggCall newAggCall = this.relBuilder.aggregateCall(aggCall.getAggregation(), aggCall.isDistinct(), aggCall.isApproximate(), (RexNode)filterArg, aggCall.name, args);
                mapping.set(j, groupCount + indicatorCount + newAggCallList.size());
                newAggCallList.add(newAggCall);
            }
            ++j;
        }
        RelBuilder.GroupKey groupKey = this.relBuilder.groupKey(newGroupSet, newGroupSets);
        this.relBuilder.aggregate(groupKey, (Iterable<RelBuilder.AggCall>)newAggCallList);
        return this.result(this.relBuilder.build(), mapping);
    }

    public TrimResult trimFields(LogicalTableModify modifier, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard(fieldsUsed);
        RelDataType rowType = modifier.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = modifier.getInput();
        int inputFieldCount = input.getRowType().getFieldCount();
        ImmutableBitSet inputFieldsUsed = ImmutableBitSet.range(inputFieldCount);
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild(modifier, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (!inputMapping.isIdentity()) {
            throw new AssertionError((Object)("Expected identity mapping, got " + inputMapping));
        }
        RelNode newModifier = modifier;
        if (newInput != input) {
            newModifier = modifier.copy(modifier.getTraitSet(), (List)Collections.singletonList(newInput));
        }
        assert (newModifier.getClass() == modifier.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
        return this.result(newModifier, mapping);
    }

    public TrimResult trimFields(LogicalTableFunctionScan tabFun, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = tabFun.getRowType();
        int fieldCount = rowType.getFieldCount();
        ArrayList<Object> newInputs = new ArrayList<Object>();
        for (RelNode input : tabFun.getInputs()) {
            int inputFieldCount = input.getRowType().getFieldCount();
            ImmutableBitSet inputFieldsUsed = ImmutableBitSet.range(inputFieldCount);
            Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
            TrimResult trimResult = this.trimChildRestore(tabFun, input, inputFieldsUsed, inputExtraFields);
            assert (((Mapping)trimResult.right).isIdentity());
            newInputs.add(trimResult.left);
        }
        TableFunctionScan newTabFun = tabFun;
        if (!tabFun.getInputs().equals(newInputs)) {
            newTabFun = tabFun.copy(tabFun.getTraitSet(), newInputs, tabFun.getCall(), tabFun.getElementType(), tabFun.getRowType(), (Set)tabFun.getColumnMappings());
        }
        assert (newTabFun.getClass() == tabFun.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
        return this.result(newTabFun, mapping);
    }

    public TrimResult trimFields(LogicalValues values, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = values.getRowType();
        int fieldCount = rowType.getFieldCount();
        if (fieldsUsed.isEmpty()) {
            fieldsUsed = ImmutableBitSet.range(fieldCount - 1, fieldCount);
        }
        if (fieldsUsed.equals(ImmutableBitSet.range(fieldCount))) {
            Mappings.IdentityMapping mapping = Mappings.createIdentity(fieldCount);
            return this.result(values, mapping);
        }
        ImmutableList.Builder newTuples = ImmutableList.builder();
        for (ImmutableList immutableList : values.getTuples()) {
            ImmutableList.Builder newTuple = ImmutableList.builder();
            for (int field : fieldsUsed) {
                newTuple.add(immutableList.get(field));
            }
            newTuples.add(newTuple.build());
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        RelDataType relDataType = RelOptUtil.permute(values.getCluster().getTypeFactory(), rowType, mapping);
        LogicalValues newValues = LogicalValues.create(values.getCluster(), relDataType, (ImmutableList<ImmutableList<RexLiteral>>)newTuples.build());
        return this.result(newValues, mapping);
    }

    protected Mapping createMapping(ImmutableBitSet fieldsUsed, int fieldCount) {
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, fieldCount, fieldsUsed.cardinality());
        int i = 0;
        for (int field : fieldsUsed) {
            mapping.set(field, i++);
        }
        return mapping;
    }

    public TrimResult trimFields(TableScan tableAccessRel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = tableAccessRel.getRowType().getFieldCount();
        if (fieldsUsed.equals(ImmutableBitSet.range(fieldCount)) && extraFields.isEmpty()) {
            return this.trimFields((RelNode)tableAccessRel, fieldsUsed, extraFields);
        }
        RelNode newTableAccessRel = tableAccessRel.project(fieldsUsed, extraFields, this.relBuilder);
        if (fieldsUsed.cardinality() == 0) {
            Project project;
            RelNode input = newTableAccessRel;
            if (input instanceof Project && (project = (Project)input).getRowType().getFieldCount() == 0) {
                input = project.getInput();
            }
            return this.dummyProject(fieldCount, input);
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        return this.result(newTableAccessRel, mapping);
    }

    protected static class TrimResult
    extends Pair<RelNode, Mapping> {
        public TrimResult(RelNode left, Mapping right) {
            super(left, right);
            assert (right.getTargetCount() == left.getRowType().getFieldCount()) : "rowType: " + left.getRowType() + ", mapping: " + right;
        }
    }
}

