/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.type;

import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;

public abstract class RelDataTypeSystemImpl
implements RelDataTypeSystem {
    @Override
    public int getMaxScale(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericScale();
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 9;
            }
        }
        return -1;
    }

    @Override
    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case CHAR: 
            case BINARY: {
                return 1;
            }
            case VARCHAR: 
            case VARBINARY: {
                return -1;
            }
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 2;
            }
            case BOOLEAN: {
                return 1;
            }
            case TINYINT: {
                return 3;
            }
            case SMALLINT: {
                return 5;
            }
            case INTEGER: {
                return 10;
            }
            case BIGINT: {
                return 19;
            }
            case REAL: {
                return 7;
            }
            case FLOAT: 
            case DOUBLE: {
                return 15;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case DATE: {
                return 0;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return this.getMaxNumericPrecision();
            }
            case CHAR: 
            case VARCHAR: {
                return 65536;
            }
            case BINARY: 
            case VARBINARY: {
                return 65536;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 3;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 10;
            }
        }
        return this.getDefaultPrecision(typeName);
    }

    @Override
    public int getMaxNumericScale() {
        return 19;
    }

    @Override
    public int getMaxNumericPrecision() {
        return 19;
    }

    @Override
    public String getLiteral(SqlTypeName typeName, boolean isPrefix) {
        switch (typeName) {
            case CHAR: 
            case VARCHAR: 
            case VARBINARY: {
                return "'";
            }
            case BINARY: {
                return isPrefix ? "x'" : "'";
            }
            case TIMESTAMP: {
                return isPrefix ? "TIMESTAMP '" : "'";
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return isPrefix ? "TIMESTAMP WITH LOCAL TIME ZONE '" : "'";
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return isPrefix ? "INTERVAL '" : "' DAY";
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                return isPrefix ? "INTERVAL '" : "' YEAR TO MONTH";
            }
            case TIME: {
                return isPrefix ? "TIME '" : "'";
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return isPrefix ? "TIME WITH LOCAL TIME ZONE '" : "'";
            }
            case DATE: {
                return isPrefix ? "DATE '" : "'";
            }
            case ARRAY: {
                return isPrefix ? "(" : ")";
            }
        }
        return null;
    }

    @Override
    public boolean isCaseSensitive(SqlTypeName typeName) {
        switch (typeName) {
            case CHAR: 
            case VARCHAR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAutoincrement(SqlTypeName typeName) {
        return false;
    }

    @Override
    public int getNumTypeRadix(SqlTypeName typeName) {
        if (typeName.getFamily() == SqlTypeFamily.NUMERIC && this.getDefaultPrecision(typeName) != -1) {
            return 10;
        }
        return 0;
    }

    @Override
    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        return argumentType;
    }

    @Override
    public RelDataType deriveAvgAggType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        return argumentType;
    }

    @Override
    public RelDataType deriveCovarType(RelDataTypeFactory typeFactory, RelDataType arg0Type, RelDataType arg1Type) {
        return arg0Type;
    }

    @Override
    public RelDataType deriveFractionalRankType(RelDataTypeFactory typeFactory) {
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), false);
    }

    @Override
    public RelDataType deriveRankType(RelDataTypeFactory typeFactory) {
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), false);
    }

    @Override
    public boolean isSchemaCaseSensitive() {
        return true;
    }
}

