/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.hive.druid.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.hive.druid.org.apache.calcite.interpreter.Row;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.IndexExpression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Types;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.runtime.FlatLists;
import org.apache.hive.druid.org.apache.calcite.runtime.Unit;
import org.apache.hive.druid.org.apache.calcite.util.BuiltInMethod;

public enum JavaRowFormat {
    CUSTOM{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            assert (type.getFieldCount() > 1);
            return typeFactory.getJavaClass(type);
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return typeFactory.getJavaClass(type.getFieldList().get(index).getType());
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            switch (expressions.size()) {
                case 0: {
                    assert (javaRowClass == Unit.class);
                    return Expressions.field(null, javaRowClass, "INSTANCE");
                }
            }
            return Expressions.new_(javaRowClass, expressions);
        }

        @Override
        public MemberExpression field(Expression expression, int field, Type fromType, Type fieldType) {
            Type type = expression.getType();
            if (type instanceof Types.RecordType) {
                Types.RecordType recordType = (Types.RecordType)type;
                Types.RecordField recordField = recordType.getRecordFields().get(field);
                return Expressions.field(expression, recordField.getDeclaringClass(), recordField.getName());
            }
            return Expressions.field(expression, Types.nthField(field, type));
        }
    }
    ,
    SCALAR{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            assert (type.getFieldCount() == 1);
            return typeFactory.getJavaClass(type.getFieldList().get(0).getType());
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return this.javaRowClass(typeFactory, type);
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            assert (expressions.size() == 1);
            return expressions.get(0);
        }

        @Override
        public Expression field(Expression expression, int field, Type fromType, Type fieldType) {
            assert (field == 0);
            return expression;
        }
    }
    ,
    LIST{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            return FlatLists.ComparableList.class;
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return Object.class;
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            switch (expressions.size()) {
                case 0: {
                    return Expressions.field(null, FlatLists.class, "COMPARABLE_EMPTY_LIST");
                }
                case 2: {
                    return Expressions.convert_(Expressions.call(List.class, null, BuiltInMethod.LIST2.method, expressions), List.class);
                }
                case 3: {
                    return Expressions.convert_(Expressions.call(List.class, null, BuiltInMethod.LIST3.method, expressions), List.class);
                }
                case 4: {
                    return Expressions.convert_(Expressions.call(List.class, null, BuiltInMethod.LIST4.method, expressions), List.class);
                }
                case 5: {
                    return Expressions.convert_(Expressions.call(List.class, null, BuiltInMethod.LIST5.method, expressions), List.class);
                }
                case 6: {
                    return Expressions.convert_(Expressions.call(List.class, null, BuiltInMethod.LIST6.method, expressions), List.class);
                }
            }
            return Expressions.convert_(Expressions.call(List.class, null, BuiltInMethod.LIST_N.method, new Expression[]{Expressions.newArrayInit(Comparable.class, expressions)}), List.class);
        }

        @Override
        public Expression field(Expression expression, int field, Type fromType, Type fieldType) {
            MethodCallExpression e = Expressions.call(expression, BuiltInMethod.LIST_GET.method, Expressions.constant(field));
            if (fromType == null) {
                fromType = e.getType();
            }
            return RexToLixTranslator.convert(e, fromType, fieldType);
        }
    }
    ,
    ROW{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            return Row.class;
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return Object.class;
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            return Expressions.call(BuiltInMethod.ROW_AS_COPY.method, expressions);
        }

        @Override
        public Expression field(Expression expression, int field, Type fromType, Type fieldType) {
            MethodCallExpression e = Expressions.call(expression, BuiltInMethod.ROW_VALUE.method, Expressions.constant(field));
            if (fromType == null) {
                fromType = e.getType();
            }
            return RexToLixTranslator.convert(e, fromType, fieldType);
        }
    }
    ,
    ARRAY{

        @Override
        Type javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            return Object[].class;
        }

        @Override
        Type javaFieldClass(JavaTypeFactory typeFactory, RelDataType type, int index) {
            return Object.class;
        }

        @Override
        public Expression record(Type javaRowClass, List<Expression> expressions) {
            return Expressions.newArrayInit(Object.class, expressions);
        }

        @Override
        public Expression comparer() {
            return Expressions.call(BuiltInMethod.ARRAY_COMPARER.method, new Expression[0]);
        }

        @Override
        public Expression field(Expression expression, int field, Type fromType, Type fieldType) {
            IndexExpression e = Expressions.arrayIndex(expression, Expressions.constant(field));
            if (fromType == null) {
                fromType = e.getType();
            }
            return RexToLixTranslator.convert(e, fromType, fieldType);
        }
    };


    public JavaRowFormat optimize(RelDataType rowType) {
        switch (rowType.getFieldCount()) {
            case 0: {
                return LIST;
            }
            case 1: {
                return SCALAR;
            }
        }
        if (this == SCALAR) {
            return LIST;
        }
        return this;
    }

    abstract Type javaRowClass(JavaTypeFactory var1, RelDataType var2);

    abstract Type javaFieldClass(JavaTypeFactory var1, RelDataType var2, int var3);

    public abstract Expression record(Type var1, List<Expression> var2);

    public Expression comparer() {
        return null;
    }

    public abstract Expression field(Expression var1, int var2, Type var3, Type var4);
}

