/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.TimeZone;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.joda.time.Period;

public class DruidSqlCastConverter
implements DruidSqlOperatorConverter {
    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.CAST;
    }

    @Override
    public String toDruidExpression(RexNode rexNode, RelDataType topRel, DruidQuery druidQuery) {
        RexNode operand = ((RexCall)rexNode).getOperands().get(0);
        String operandExpression = DruidExpressions.toDruidExpression(operand, topRel, druidQuery);
        if (operandExpression == null) {
            return null;
        }
        SqlTypeName fromType = operand.getType().getSqlTypeName();
        SqlTypeName toType = rexNode.getType().getSqlTypeName();
        String timeZoneConf = druidQuery.getConnectionConfig().timeZone();
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneConf == null ? "UTC" : timeZoneConf);
        if (SqlTypeName.CHAR_TYPES.contains((Object)fromType) && SqlTypeName.DATETIME_TYPES.contains((Object)toType)) {
            return DruidSqlCastConverter.castCharToDateTime(timeZone, operandExpression, toType);
        }
        if (SqlTypeName.DATETIME_TYPES.contains((Object)fromType) && SqlTypeName.CHAR_TYPES.contains((Object)toType)) {
            return DruidSqlCastConverter.castDateTimeToChar(timeZone, operandExpression, fromType);
        }
        DruidType fromExprType = DruidExpressions.EXPRESSION_TYPES.get((Object)fromType);
        DruidType toExprType = DruidExpressions.EXPRESSION_TYPES.get((Object)toType);
        if (fromExprType == null || toExprType == null) {
            return null;
        }
        String typeCastExpression = fromExprType != toExprType ? DruidQuery.format("CAST(%s, '%s')", operandExpression, toExprType.toString()) : operandExpression;
        if (toType == SqlTypeName.DATE) {
            return DruidExpressions.applyTimestampFloor(typeCastExpression, Period.days((int)1).toString(), "", TimeZone.getTimeZone(druidQuery.getConnectionConfig().timeZone()));
        }
        return typeCastExpression;
    }

    private static String castCharToDateTime(TimeZone timeZone, String operand, SqlTypeName toType) {
        String timestampExpression = DruidExpressions.functionCall("timestamp_parse", ImmutableList.of(operand, DruidExpressions.stringLiteral(""), DruidExpressions.stringLiteral(timeZone.getID())));
        if (toType == SqlTypeName.DATE) {
            return DruidExpressions.applyTimestampFloor(timestampExpression, Period.days((int)1).toString(), "", timeZone);
        }
        if (toType == SqlTypeName.TIMESTAMP || toType == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return timestampExpression;
        }
        throw new IllegalStateException(DruidQuery.format("Unsupported DateTime type[%s]", new Object[]{toType}));
    }

    private static String castDateTimeToChar(TimeZone timeZone, String operand, SqlTypeName fromType) {
        return DruidExpressions.functionCall("timestamp_format", ImmutableList.of(operand, DruidExpressions.stringLiteral(DruidSqlCastConverter.dateTimeFormatString(fromType)), DruidExpressions.stringLiteral(timeZone.getID())));
    }

    public static String dateTimeFormatString(SqlTypeName sqlTypeName) {
        if (sqlTypeName == SqlTypeName.DATE) {
            return "yyyy-MM-dd";
        }
        if (sqlTypeName == SqlTypeName.TIMESTAMP) {
            return "yyyy-MM-dd HH:mm:ss";
        }
        if (sqlTypeName == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        }
        return null;
    }
}

