/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.cache.CacheBuilder;
import org.apache.hive.druid.com.google.common.cache.CacheLoader;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.ComplexMetric;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidTable;
import org.apache.hive.druid.org.apache.calcite.schema.Table;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.util.Compatible;

public class DruidSchema
extends AbstractSchema {
    final String url;
    final String coordinatorUrl;
    private final boolean discoverTables;
    private Map<String, Table> tableMap = null;

    public DruidSchema(String url, String coordinatorUrl, boolean discoverTables) {
        this.url = Preconditions.checkNotNull(url);
        this.coordinatorUrl = Preconditions.checkNotNull(coordinatorUrl);
        this.discoverTables = discoverTables;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        if (!this.discoverTables) {
            return ImmutableMap.of();
        }
        if (this.tableMap == null) {
            final DruidConnectionImpl connection = new DruidConnectionImpl(this.url, this.coordinatorUrl);
            Set<String> tableNames = connection.tableNames();
            this.tableMap = Compatible.INSTANCE.asMap(ImmutableSet.copyOf(tableNames), CacheBuilder.newBuilder().build(new CacheLoader<String, Table>(){

                @Override
                public Table load(@Nonnull String tableName) throws Exception {
                    LinkedHashMap<String, SqlTypeName> fieldMap = new LinkedHashMap<String, SqlTypeName>();
                    LinkedHashSet<String> metricNameSet = new LinkedHashSet<String>();
                    HashMap<String, List<ComplexMetric>> complexMetrics = new HashMap<String, List<ComplexMetric>>();
                    connection.metadata(tableName, "__time", null, fieldMap, metricNameSet, complexMetrics);
                    return DruidTable.create(DruidSchema.this, tableName, null, fieldMap, metricNameSet, "__time", complexMetrics);
                }
            }));
        }
        return this.tableMap;
    }
}

