/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.Granularity;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class CeilOperatorConversion
implements DruidSqlOperatorConverter {
    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.CEIL;
    }

    @Override
    @Nullable
    public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
        RexCall call = (RexCall)rexNode;
        RexNode arg = call.getOperands().get(0);
        String druidExpression = DruidExpressions.toDruidExpression(arg, rowType, query);
        if (druidExpression == null) {
            return null;
        }
        if (call.getOperands().size() == 1) {
            return DruidQuery.format("ceil(%s)", druidExpression);
        }
        if (call.getOperands().size() == 2) {
            RexLiteral flag = (RexLiteral)call.getOperands().get(1);
            TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
            Granularity.Type type = DruidDateTimeUtils.toDruidGranularity(timeUnit);
            if (type == null) {
                return null;
            }
            String isoPeriodFormat = DruidDateTimeUtils.toISOPeriodFormat(type);
            if (isoPeriodFormat == null) {
                return null;
            }
            return DruidExpressions.applyTimestampCeil(druidExpression, isoPeriodFormat, "", TimeZone.getTimeZone(query.getConnectionConfig().timeZone()));
        }
        return null;
    }
}

