/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.resolver.dns;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.hive.druid.io.netty.resolver.dns.DefaultDnsServerAddresses;
import org.apache.hive.druid.io.netty.resolver.dns.DnsServerAddressStream;
import org.apache.hive.druid.io.netty.resolver.dns.SequentialDnsServerAddressStream;

final class RotationalDnsServerAddresses
extends DefaultDnsServerAddresses {
    private static final AtomicIntegerFieldUpdater<RotationalDnsServerAddresses> startIdxUpdater;
    private volatile int startIdx;

    RotationalDnsServerAddresses(InetSocketAddress[] addresses) {
        super("rotational", addresses);
    }

    @Override
    public DnsServerAddressStream stream() {
        int nextStartIdx;
        int curStartIdx;
        do {
            if ((nextStartIdx = (curStartIdx = this.startIdx) + 1) < this.addresses.length) continue;
            nextStartIdx = 0;
        } while (!startIdxUpdater.compareAndSet(this, curStartIdx, nextStartIdx));
        return new SequentialDnsServerAddressStream(this.addresses, curStartIdx);
    }

    static {
        AtomicIntegerFieldUpdater<RotationalDnsServerAddresses> updater = AtomicIntegerFieldUpdater.newUpdater(RotationalDnsServerAddresses.class, "startIdx");
        if (updater == null) {
            updater = AtomicIntegerFieldUpdater.newUpdater(RotationalDnsServerAddresses.class, "startIdx");
        }
        startIdxUpdater = updater;
    }
}

