/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.ssl;

import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.handler.ssl.PemEncoded;
import org.apache.hive.druid.io.netty.handler.ssl.SslUtils;
import org.apache.hive.druid.io.netty.util.AbstractReferenceCounted;
import org.apache.hive.druid.io.netty.util.IllegalReferenceCountException;
import org.apache.hive.druid.io.netty.util.internal.ObjectUtil;

class PemValue
extends AbstractReferenceCounted
implements PemEncoded {
    private final ByteBuf content;
    private final boolean sensitive;

    public PemValue(ByteBuf content, boolean sensitive) {
        this.content = ObjectUtil.checkNotNull(content, "content");
        this.sensitive = sensitive;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    @Override
    public ByteBuf content() {
        int count = this.refCnt();
        if (count <= 0) {
            throw new IllegalReferenceCountException(count);
        }
        return this.content;
    }

    @Override
    public PemValue copy() {
        return new PemValue(this.content.copy(), this.sensitive);
    }

    @Override
    public PemValue duplicate() {
        return new PemValue(this.content.duplicate(), this.sensitive);
    }

    @Override
    public PemValue retain() {
        return (PemValue)super.retain();
    }

    @Override
    public PemValue retain(int increment) {
        return (PemValue)super.retain(increment);
    }

    @Override
    protected void deallocate() {
        if (this.sensitive) {
            SslUtils.zeroout(this.content);
        }
        this.content.release();
    }
}

