/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.smtp;

import java.util.HashMap;
import java.util.Map;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.ByteBufUtil;
import org.apache.hive.druid.io.netty.util.AsciiString;
import org.apache.hive.druid.io.netty.util.internal.ObjectUtil;

public final class SmtpCommand {
    public static final SmtpCommand EHLO = new SmtpCommand(AsciiString.cached((String)"EHLO"));
    public static final SmtpCommand HELO = new SmtpCommand(AsciiString.cached((String)"HELO"));
    public static final SmtpCommand AUTH = new SmtpCommand(AsciiString.cached((String)"AUTH"));
    public static final SmtpCommand MAIL = new SmtpCommand(AsciiString.cached((String)"MAIL"));
    public static final SmtpCommand RCPT = new SmtpCommand(AsciiString.cached((String)"RCPT"));
    public static final SmtpCommand DATA = new SmtpCommand(AsciiString.cached((String)"DATA"));
    public static final SmtpCommand NOOP = new SmtpCommand(AsciiString.cached((String)"NOOP"));
    public static final SmtpCommand RSET = new SmtpCommand(AsciiString.cached((String)"RSET"));
    public static final SmtpCommand EXPN = new SmtpCommand(AsciiString.cached((String)"EXPN"));
    public static final SmtpCommand VRFY = new SmtpCommand(AsciiString.cached((String)"VRFY"));
    public static final SmtpCommand HELP = new SmtpCommand(AsciiString.cached((String)"HELP"));
    public static final SmtpCommand QUIT = new SmtpCommand(AsciiString.cached((String)"QUIT"));
    public static final SmtpCommand EMPTY = new SmtpCommand(AsciiString.cached((String)""));
    private static final Map<String, SmtpCommand> COMMANDS = new HashMap<String, SmtpCommand>();
    private final AsciiString name;

    public static SmtpCommand valueOf(CharSequence commandName) {
        ObjectUtil.checkNotNull(commandName, "commandName");
        SmtpCommand command = COMMANDS.get(commandName.toString());
        return command != null ? command : new SmtpCommand(AsciiString.of((CharSequence)commandName));
    }

    private SmtpCommand(AsciiString name) {
        this.name = name;
    }

    public AsciiString name() {
        return this.name;
    }

    void encode(ByteBuf buffer) {
        ByteBufUtil.writeAscii(buffer, (CharSequence)this.name);
    }

    boolean isContentExpected() {
        return this.equals(DATA);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SmtpCommand)) {
            return false;
        }
        return this.name.contentEqualsIgnoreCase((CharSequence)((SmtpCommand)obj).name());
    }

    public String toString() {
        return "SmtpCommand{name=" + this.name + '}';
    }

    static {
        COMMANDS.put(EHLO.name().toString(), EHLO);
        COMMANDS.put(HELO.name().toString(), HELO);
        COMMANDS.put(AUTH.name().toString(), AUTH);
        COMMANDS.put(MAIL.name().toString(), MAIL);
        COMMANDS.put(RCPT.name().toString(), RCPT);
        COMMANDS.put(DATA.name().toString(), DATA);
        COMMANDS.put(NOOP.name().toString(), NOOP);
        COMMANDS.put(RSET.name().toString(), RSET);
        COMMANDS.put(EXPN.name().toString(), EXPN);
        COMMANDS.put(VRFY.name().toString(), VRFY);
        COMMANDS.put(HELP.name().toString(), HELP);
        COMMANDS.put(QUIT.name().toString(), QUIT);
        COMMANDS.put(EMPTY.name().toString(), EMPTY);
    }
}

