/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.router;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.discovery.DruidLeaderClient;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.http.client.response.FullResponseHolder;
import org.apache.hive.druid.io.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerConfig;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Duration;

@ManageLifecycle
public class CoordinatorRuleManager {
    private static final Logger log = new Logger(CoordinatorRuleManager.class);
    private final ObjectMapper jsonMapper;
    private final Supplier<TieredBrokerConfig> config;
    private final AtomicReference<ConcurrentHashMap<String, List<Rule>>> rules;
    private final DruidLeaderClient druidLeaderClient;
    private volatile ScheduledExecutorService exec;
    private final Object lock = new Object();
    private volatile boolean started = false;

    @Inject
    public CoordinatorRuleManager(@Json ObjectMapper jsonMapper, Supplier<TieredBrokerConfig> config, DruidLeaderClient druidLeaderClient) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.druidLeaderClient = druidLeaderClient;
        this.rules = new AtomicReference(new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.exec = Execs.scheduledSingleThreaded("CoordinatorRuleManager-Exec--%d");
            ScheduledExecutors.scheduleWithFixedDelay(this.exec, new Duration(0L), this.config.get().getPollPeriod().toStandardDuration(), new Runnable(){

                @Override
                public void run() {
                    CoordinatorRuleManager.this.poll();
                }
            });
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.rules.set(new ConcurrentHashMap());
            this.started = false;
            this.exec.shutdownNow();
            this.exec = null;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void poll() {
        try {
            FullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, this.config.get().getRulesEndpoint()));
            if (!response.getStatus().equals(HttpResponseStatus.OK)) {
                throw new ISE("Error while polling rules, status[%s] content[%s]", response.getStatus(), response.getContent());
            }
            ConcurrentHashMap<String, List<Rule>> newRules = new ConcurrentHashMap<String, List<Rule>>(this.jsonMapper.readValue(response.getContent(), new TypeReference<Map<String, List<Rule>>>(){}));
            log.info("Got [%,d] rules", newRules.size());
            this.rules.set(newRules);
        }
        catch (Exception e) {
            log.error(e, "Exception while polling for rules", new Object[0]);
        }
    }

    public List<Rule> getRulesWithDefault(String dataSource) {
        ArrayList<Rule> retVal = Lists.newArrayList();
        Map theRules = this.rules.get();
        if (theRules.get(dataSource) != null) {
            retVal.addAll((Collection)theRules.get(dataSource));
        }
        if (theRules.get(this.config.get().getDefaultRule()) != null) {
            retVal.addAll((Collection)theRules.get(this.config.get().getDefaultRule()));
        }
        return retVal;
    }
}

