/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.HashMap;
import java.util.HashSet;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.HashBasedTable;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.InventoryView;
import org.apache.hive.druid.io.druid.java.util.common.MapUtils;
import org.apache.hive.druid.io.druid.server.http.security.StateResourceFilter;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.Interval;

@Path(value="/druid/coordinator/v1/tiers")
@ResourceFilters(value={StateResourceFilter.class})
public class TiersResource {
    private final InventoryView serverInventoryView;

    @Inject
    public TiersResource(InventoryView serverInventoryView) {
        this.serverInventoryView = serverInventoryView;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTiers(@QueryParam(value="simple") String simple) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (simple != null) {
            HashMap metadata = Maps.newHashMap();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                Long currSize;
                HashMap<String, Long> tierMetadata = (HashMap<String, Long>)metadata.get(druidServer.getTier());
                if (tierMetadata == null) {
                    tierMetadata = Maps.newHashMap();
                    metadata.put(druidServer.getTier(), tierMetadata);
                }
                tierMetadata.put("currSize", ((currSize = (Long)tierMetadata.get("currSize")) == null ? 0L : currSize) + druidServer.getCurrSize());
                Long maxSize = (Long)tierMetadata.get("maxSize");
                tierMetadata.put("maxSize", (maxSize == null ? 0L : maxSize) + druidServer.getMaxSize());
            }
            return builder.entity(metadata).build();
        }
        HashSet<String> tiers = Sets.newHashSet();
        for (DruidServer server : this.serverInventoryView.getInventory()) {
            tiers.add(server.getTier());
        }
        return builder.entity(tiers).build();
    }

    @GET
    @Path(value="/{tierName}")
    @Produces(value={"application/json"})
    public Response getTierDatasources(@PathParam(value="tierName") String tierName, @QueryParam(value="simple") String simple) {
        if (simple != null) {
            HashBasedTable<String, Interval, HashMap<String, Object>> retVal = HashBasedTable.create();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                if (!druidServer.getTier().equalsIgnoreCase(tierName)) continue;
                for (DataSegment dataSegment : druidServer.getSegments().values()) {
                    HashMap<String, Object> properties = (HashMap<String, Object>)retVal.get(dataSegment.getDataSource(), dataSegment.getInterval());
                    if (properties == null) {
                        properties = Maps.newHashMap();
                        retVal.put(dataSegment.getDataSource(), dataSegment.getInterval(), properties);
                    }
                    properties.put("size", MapUtils.getLong(properties, "size", 0L) + dataSegment.getSize());
                    properties.put("count", MapUtils.getInt(properties, "count", 0) + 1);
                }
            }
            return Response.ok(retVal.rowMap()).build();
        }
        HashSet<String> retVal = Sets.newHashSet();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            if (!druidServer.getTier().equalsIgnoreCase(tierName)) continue;
            retVal.addAll(Lists.newArrayList(Iterables.transform(druidServer.getDataSources(), new Function<DruidDataSource, String>(){

                @Override
                public String apply(DruidDataSource input) {
                    return input.getName();
                }
            })));
        }
        return Response.ok(retVal).build();
    }
}

