/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import com.google.inject.Inject;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.InventoryView;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.MapUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.server.http.InventoryViewUtils;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

@Path(value="/druid/coordinator/v1/intervals")
public class IntervalsResource {
    private final InventoryView serverInventoryView;
    private final AuthConfig authConfig;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public IntervalsResource(InventoryView serverInventoryView, AuthConfig authConfig, AuthorizerMapper authorizerMapper) {
        this.serverInventoryView = serverInventoryView;
        this.authConfig = authConfig;
        this.authorizerMapper = authorizerMapper;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getIntervals(@Context HttpServletRequest req) {
        Comparator<Interval> comparator = Comparators.inverse(Comparators.intervalsByStartThenEnd());
        SortedSet<ImmutableDruidDataSource> datasources = InventoryViewUtils.getSecuredDataSources(req, this.serverInventoryView, this.authorizerMapper);
        TreeMap<Interval, Map<String, Map<String, Object>>> retVal = Maps.newTreeMap(comparator);
        for (ImmutableDruidDataSource dataSource : datasources) {
            for (DataSegment dataSegment : dataSource.getSegments()) {
                Map interval = (Map)retVal.get(dataSegment.getInterval());
                if (interval == null) {
                    HashMap tmp = Maps.newHashMap();
                    retVal.put(dataSegment.getInterval(), tmp);
                }
                this.setProperties(retVal, dataSource, dataSegment);
            }
        }
        return Response.ok(retVal).build();
    }

    @GET
    @Path(value="/{interval}")
    @Produces(value={"application/json"})
    public Response getSpecificIntervals(@PathParam(value="interval") String interval, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full, @Context HttpServletRequest req) {
        Interval theInterval = Intervals.of(interval.replace("_", "/"));
        SortedSet<ImmutableDruidDataSource> datasources = InventoryViewUtils.getSecuredDataSources(req, this.serverInventoryView, this.authorizerMapper);
        Comparator<Interval> comparator = Comparators.inverse(Comparators.intervalsByStartThenEnd());
        if (full != null) {
            TreeMap<Interval, Map<String, Map<String, Object>>> retVal = Maps.newTreeMap(comparator);
            for (ImmutableDruidDataSource dataSource : datasources) {
                for (DataSegment dataSegment : dataSource.getSegments()) {
                    if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                    Map dataSourceInterval = (Map)retVal.get(dataSegment.getInterval());
                    if (dataSourceInterval == null) {
                        HashMap tmp = Maps.newHashMap();
                        retVal.put(dataSegment.getInterval(), tmp);
                    }
                    this.setProperties(retVal, dataSource, dataSegment);
                }
            }
            return Response.ok(retVal).build();
        }
        if (simple != null) {
            HashMap<Interval, HashMap<String, Object>> retVal = Maps.newHashMap();
            for (ImmutableDruidDataSource dataSource : datasources) {
                for (DataSegment dataSegment : dataSource.getSegments()) {
                    if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                    HashMap<String, Object> properties = (HashMap<String, Object>)retVal.get(dataSegment.getInterval());
                    if (properties == null) {
                        properties = Maps.newHashMap();
                        properties.put("size", dataSegment.getSize());
                        properties.put("count", 1);
                        retVal.put(dataSegment.getInterval(), properties);
                        continue;
                    }
                    properties.put("size", MapUtils.getLong(properties, "size", 0L) + dataSegment.getSize());
                    properties.put("count", MapUtils.getInt(properties, "count", 0) + 1);
                }
            }
            return Response.ok(retVal).build();
        }
        HashMap<String, Object> retVal = Maps.newHashMap();
        for (ImmutableDruidDataSource dataSource : datasources) {
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                retVal.put("size", MapUtils.getLong(retVal, "size", 0L) + dataSegment.getSize());
                retVal.put("count", MapUtils.getInt(retVal, "count", 0) + 1);
            }
        }
        return Response.ok(retVal).build();
    }

    private void setProperties(Map<Interval, Map<String, Map<String, Object>>> retVal, ImmutableDruidDataSource dataSource, DataSegment dataSegment) {
        Map<String, Object> properties = retVal.get(dataSegment.getInterval()).get(dataSource.getName());
        if (properties == null) {
            properties = Maps.newHashMap();
            properties.put("size", dataSegment.getSize());
            properties.put("count", 1);
            retVal.get(dataSegment.getInterval()).put(dataSource.getName(), properties);
        } else {
            properties.put("size", MapUtils.getLong(properties, "size", 0L) + dataSegment.getSize());
            properties.put("count", MapUtils.getInt(properties, "count", 0) + 1);
        }
    }
}

