/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.Map;
import java.util.SortedSet;
import org.apache.hive.druid.com.google.common.collect.HashBasedTable;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Table;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class SegmentReplicantLookup {
    private final Table<String, String, Integer> segmentsInCluster;

    public static SegmentReplicantLookup make(DruidCluster cluster) {
        HashBasedTable<String, String, Integer> segmentsInCluster = HashBasedTable.create();
        for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : sortedSet) {
                ImmutableDruidServer server = serverHolder.getServer();
                for (DataSegment segment : server.getSegments().values()) {
                    Integer numReplicants = (Integer)segmentsInCluster.get(segment.getIdentifier(), server.getTier());
                    if (numReplicants == null) {
                        numReplicants = 0;
                    }
                    numReplicants = numReplicants + 1;
                    segmentsInCluster.put(segment.getIdentifier(), server.getTier(), numReplicants);
                }
            }
        }
        return new SegmentReplicantLookup(segmentsInCluster);
    }

    private SegmentReplicantLookup(Table<String, String, Integer> segmentsInCluster) {
        this.segmentsInCluster = segmentsInCluster;
    }

    public Map<String, Integer> getClusterTiers(String segmentId) {
        Map<String, Integer> retVal = this.segmentsInCluster.row(segmentId);
        return retVal == null ? Maps.newHashMap() : retVal;
    }

    public int getLoadedReplicants(String segmentId) {
        Map<String, Integer> allTiers = this.segmentsInCluster.row(segmentId);
        int retVal = 0;
        for (Integer replicants : allTiers.values()) {
            retVal += replicants.intValue();
        }
        return retVal;
    }

    public int getLoadedReplicants(String segmentId, String tier) {
        Integer retVal = this.segmentsInCluster.get(segmentId, tier);
        return retVal == null ? 0 : retVal;
    }
}

