/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.ReplicationThrottler;
import org.apache.hive.druid.io.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.DateTime;

public class DruidCoordinatorRuntimeParams {
    private final long startTime;
    private final DruidCluster druidCluster;
    private final MetadataRuleManager databaseRuleManager;
    private final SegmentReplicantLookup segmentReplicantLookup;
    private final Set<ImmutableDruidDataSource> dataSources;
    private final Set<DataSegment> availableSegments;
    private final Map<String, LoadQueuePeon> loadManagementPeons;
    private final ReplicationThrottler replicationManager;
    private final ServiceEmitter emitter;
    private final CoordinatorDynamicConfig coordinatorDynamicConfig;
    private final CoordinatorStats stats;
    private final DateTime balancerReferenceTimestamp;
    private final BalancerStrategy balancerStrategy;

    private DruidCoordinatorRuntimeParams(long startTime, DruidCluster druidCluster, MetadataRuleManager databaseRuleManager, SegmentReplicantLookup segmentReplicantLookup, Set<ImmutableDruidDataSource> dataSources, Set<DataSegment> availableSegments, Map<String, LoadQueuePeon> loadManagementPeons, ReplicationThrottler replicationManager, ServiceEmitter emitter, CoordinatorDynamicConfig coordinatorDynamicConfig, CoordinatorStats stats, DateTime balancerReferenceTimestamp, BalancerStrategy balancerStrategy) {
        this.startTime = startTime;
        this.druidCluster = druidCluster;
        this.databaseRuleManager = databaseRuleManager;
        this.segmentReplicantLookup = segmentReplicantLookup;
        this.dataSources = dataSources;
        this.availableSegments = availableSegments;
        this.loadManagementPeons = loadManagementPeons;
        this.replicationManager = replicationManager;
        this.emitter = emitter;
        this.coordinatorDynamicConfig = coordinatorDynamicConfig;
        this.stats = stats;
        this.balancerReferenceTimestamp = balancerReferenceTimestamp;
        this.balancerStrategy = balancerStrategy;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public DruidCluster getDruidCluster() {
        return this.druidCluster;
    }

    public MetadataRuleManager getDatabaseRuleManager() {
        return this.databaseRuleManager;
    }

    public SegmentReplicantLookup getSegmentReplicantLookup() {
        return this.segmentReplicantLookup;
    }

    public Set<ImmutableDruidDataSource> getDataSources() {
        return this.dataSources;
    }

    public Set<DataSegment> getAvailableSegments() {
        return this.availableSegments;
    }

    public Map<String, LoadQueuePeon> getLoadManagementPeons() {
        return this.loadManagementPeons;
    }

    public ReplicationThrottler getReplicationManager() {
        return this.replicationManager;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public CoordinatorDynamicConfig getCoordinatorDynamicConfig() {
        return this.coordinatorDynamicConfig;
    }

    public CoordinatorStats getCoordinatorStats() {
        return this.stats;
    }

    public DateTime getBalancerReferenceTimestamp() {
        return this.balancerReferenceTimestamp;
    }

    public BalancerStrategy getBalancerStrategy() {
        return this.balancerStrategy;
    }

    public boolean hasDeletionWaitTimeElapsed() {
        return System.currentTimeMillis() - this.getStartTime() > this.coordinatorDynamicConfig.getMillisToWaitBeforeDeleting();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder buildFromExisting() {
        return new Builder(this.startTime, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, this.dataSources, this.availableSegments, this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.stats, this.balancerReferenceTimestamp, this.balancerStrategy);
    }

    public Builder buildFromExistingWithoutAvailableSegments() {
        return new Builder(this.startTime, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, this.dataSources, Sets.newTreeSet(DruidCoordinator.SEGMENT_COMPARATOR), this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.stats, this.balancerReferenceTimestamp, this.balancerStrategy);
    }

    public static class Builder {
        private long startTime;
        private DruidCluster druidCluster;
        private MetadataRuleManager databaseRuleManager;
        private SegmentReplicantLookup segmentReplicantLookup;
        private final Set<ImmutableDruidDataSource> dataSources;
        private final Set<DataSegment> availableSegments;
        private final Map<String, LoadQueuePeon> loadManagementPeons;
        private ReplicationThrottler replicationManager;
        private ServiceEmitter emitter;
        private CoordinatorDynamicConfig coordinatorDynamicConfig;
        private CoordinatorStats stats;
        private DateTime balancerReferenceTimestamp;
        private BalancerStrategy balancerStrategy;

        Builder() {
            this.startTime = 0L;
            this.druidCluster = null;
            this.databaseRuleManager = null;
            this.segmentReplicantLookup = null;
            this.dataSources = new HashSet<ImmutableDruidDataSource>();
            this.availableSegments = new TreeSet<DataSegment>(DruidCoordinator.SEGMENT_COMPARATOR);
            this.loadManagementPeons = Maps.newHashMap();
            this.replicationManager = null;
            this.emitter = null;
            this.stats = new CoordinatorStats();
            this.coordinatorDynamicConfig = new CoordinatorDynamicConfig.Builder().build();
            this.balancerReferenceTimestamp = DateTimes.nowUtc();
        }

        Builder(long startTime, DruidCluster cluster, MetadataRuleManager databaseRuleManager, SegmentReplicantLookup segmentReplicantLookup, Set<ImmutableDruidDataSource> dataSources, Set<DataSegment> availableSegments, Map<String, LoadQueuePeon> loadManagementPeons, ReplicationThrottler replicationManager, ServiceEmitter emitter, CoordinatorDynamicConfig coordinatorDynamicConfig, CoordinatorStats stats, DateTime balancerReferenceTimestamp, BalancerStrategy balancerStrategy) {
            this.startTime = startTime;
            this.druidCluster = cluster;
            this.databaseRuleManager = databaseRuleManager;
            this.segmentReplicantLookup = segmentReplicantLookup;
            this.dataSources = dataSources;
            this.availableSegments = availableSegments;
            this.loadManagementPeons = loadManagementPeons;
            this.replicationManager = replicationManager;
            this.emitter = emitter;
            this.coordinatorDynamicConfig = coordinatorDynamicConfig;
            this.stats = stats;
            this.balancerReferenceTimestamp = balancerReferenceTimestamp;
            this.balancerStrategy = balancerStrategy;
        }

        public DruidCoordinatorRuntimeParams build() {
            return new DruidCoordinatorRuntimeParams(this.startTime, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, this.dataSources, this.availableSegments, this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.stats, this.balancerReferenceTimestamp, this.balancerStrategy);
        }

        public Builder withStartTime(long time) {
            this.startTime = time;
            return this;
        }

        public Builder withDruidCluster(DruidCluster cluster) {
            this.druidCluster = cluster;
            return this;
        }

        public Builder withDatabaseRuleManager(MetadataRuleManager databaseRuleManager) {
            this.databaseRuleManager = databaseRuleManager;
            return this;
        }

        public Builder withSegmentReplicantLookup(SegmentReplicantLookup lookup) {
            this.segmentReplicantLookup = lookup;
            return this;
        }

        public Builder withDatasources(Collection<ImmutableDruidDataSource> dataSourcesCollection) {
            this.dataSources.addAll(Collections.unmodifiableCollection(dataSourcesCollection));
            return this;
        }

        public Builder withAvailableSegments(Collection<DataSegment> availableSegmentsCollection) {
            this.availableSegments.addAll(Collections.unmodifiableCollection(availableSegmentsCollection));
            return this;
        }

        public Builder withLoadManagementPeons(Map<String, LoadQueuePeon> loadManagementPeonsCollection) {
            this.loadManagementPeons.putAll(Collections.unmodifiableMap(loadManagementPeonsCollection));
            return this;
        }

        public Builder withReplicationManager(ReplicationThrottler replicationManager) {
            this.replicationManager = replicationManager;
            return this;
        }

        public Builder withEmitter(ServiceEmitter emitter) {
            this.emitter = emitter;
            return this;
        }

        public Builder withCoordinatorStats(CoordinatorStats stats) {
            this.stats.accumulate(stats);
            return this;
        }

        public Builder withDynamicConfigs(CoordinatorDynamicConfig configs) {
            this.coordinatorDynamicConfig = configs;
            return this;
        }

        public Builder withBalancerReferenceTimestamp(DateTime balancerReferenceTimestamp) {
            this.balancerReferenceTimestamp = balancerReferenceTimestamp;
            return this;
        }

        public Builder withBalancerStrategy(BalancerStrategy balancerStrategy) {
            this.balancerStrategy = balancerStrategy;
            return this;
        }
    }
}

