/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.io.druid.client.ServerInventoryView;
import org.apache.hive.druid.io.druid.client.ServerView;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerStrategyFactory;
import org.apache.hive.druid.io.druid.server.coordinator.CachingCostBalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.cost.ClusterCostCache;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class CachingCostBalancerStrategyFactory
implements BalancerStrategyFactory {
    private static final EmittingLogger LOG = new EmittingLogger(CachingCostBalancerStrategyFactory.class);
    private final ExecutorService executor = Execs.singleThreaded("CachingCostBalancerStrategy-executor");
    private final ClusterCostCache.Builder clusterCostCacheBuilder = ClusterCostCache.builder();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    @JsonCreator
    public CachingCostBalancerStrategyFactory(@JacksonInject ServerInventoryView serverInventoryView, @JacksonInject Lifecycle lifecycle) throws Exception {
        lifecycle.addMaybeStartManagedInstance(this);
        serverInventoryView.registerSegmentCallback(this.executor, new ServerView.SegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                CachingCostBalancerStrategyFactory.this.clusterCostCacheBuilder.addSegment(server.getName(), segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                CachingCostBalancerStrategyFactory.this.clusterCostCacheBuilder.removeSegment(server.getName(), segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentViewInitialized() {
                CachingCostBalancerStrategyFactory.this.initialized.set(true);
                return ServerView.CallbackAction.CONTINUE;
            }
        });
        serverInventoryView.registerServerRemovedCallback(this.executor, server -> {
            this.clusterCostCacheBuilder.removeServer(server.getName());
            return ServerView.CallbackAction.CONTINUE;
        });
    }

    @LifecycleStart
    public void start() {
    }

    @LifecycleStop
    public void stop() {
        this.executor.shutdownNow();
    }

    @Override
    public BalancerStrategy createBalancerStrategy(ListeningExecutorService exec) {
        if (this.initialized.compareAndSet(true, true)) {
            try {
                CompletableFuture<CachingCostBalancerStrategy> future = CompletableFuture.supplyAsync(() -> new CachingCostBalancerStrategy(this.clusterCostCacheBuilder.build(), exec), this.executor);
                try {
                    return future.get();
                }
                catch (CancellationException e) {
                    LOG.error("CachingCostBalancerStrategy creation has been cancelled", new Object[0]);
                }
                catch (ExecutionException e) {
                    LOG.error(e, "Failed to create CachingCostBalancerStrategy", new Object[0]);
                }
                catch (InterruptedException e) {
                    LOG.error("CachingCostBalancerStrategy creation has been interrupted", new Object[0]);
                    Thread.currentThread().interrupt();
                }
            }
            catch (RejectedExecutionException e) {
                LOG.error("CachingCostBalancerStrategy creation has been rejected", new Object[0]);
            }
        } else {
            LOG.error("CachingCostBalancerStrategy could not be created as serverView is not initialized yet", new Object[0]);
        }
        LOG.info("Fallback to CostBalancerStrategy", new Object[0]);
        return new CostBalancerStrategy(exec);
    }
}

