/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeHandler;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.hive.druid.io.druid.server.initialization.ZkPathsConfig;

@Deprecated
public class ZkCoordinator {
    private static final EmittingLogger log = new EmittingLogger(ZkCoordinator.class);
    private final Object lock = new Object();
    private final DataSegmentChangeHandler dataSegmentChangeHandler;
    private final ObjectMapper jsonMapper;
    private final ZkPathsConfig zkPaths;
    private final DruidServerMetadata me;
    private final CuratorFramework curator;
    private volatile PathChildrenCache loadQueueCache;
    private volatile boolean started = false;

    @Inject
    public ZkCoordinator(SegmentLoadDropHandler loadDropHandler, ObjectMapper jsonMapper, ZkPathsConfig zkPaths, DruidServerMetadata me, CuratorFramework curator) {
        this.dataSegmentChangeHandler = loadDropHandler;
        this.jsonMapper = jsonMapper;
        this.zkPaths = zkPaths;
        this.me = me;
        this.curator = curator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            log.info("Starting zkCoordinator for server[%s]", this.me.getName());
            String loadQueueLocation = ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)this.me.getName());
            String servedSegmentsLocation = ZKPaths.makePath((String)this.zkPaths.getServedSegmentsPath(), (String)this.me.getName());
            String liveSegmentsLocation = ZKPaths.makePath((String)this.zkPaths.getLiveSegmentsPath(), (String)this.me.getName());
            this.loadQueueCache = new PathChildrenCache(this.curator, loadQueueLocation, true, true, Execs.singleThreaded("ZkCoordinator"));
            try {
                this.curator.newNamespaceAwareEnsurePath(loadQueueLocation).ensure(this.curator.getZookeeperClient());
                this.curator.newNamespaceAwareEnsurePath(servedSegmentsLocation).ensure(this.curator.getZookeeperClient());
                this.curator.newNamespaceAwareEnsurePath(liveSegmentsLocation).ensure(this.curator.getZookeeperClient());
                this.loadQueueCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

                    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                        ChildData child = event.getData();
                        switch (event.getType()) {
                            case CHILD_ADDED: {
                                final String path = child.getPath();
                                final DataSegmentChangeRequest request = ZkCoordinator.this.jsonMapper.readValue(child.getData(), DataSegmentChangeRequest.class);
                                log.info("New request[%s] with zNode[%s].", request.asString(), path);
                                try {
                                    request.go(ZkCoordinator.this.dataSegmentChangeHandler, new DataSegmentChangeCallback(){
                                        boolean hasRun = false;

                                        @Override
                                        public void execute() {
                                            try {
                                                if (!this.hasRun) {
                                                    ((ChildrenDeletable)ZkCoordinator.this.curator.delete().guaranteed()).forPath(path);
                                                    log.info("Completed request [%s]", request.asString());
                                                    this.hasRun = true;
                                                }
                                            }
                                            catch (Exception e) {
                                                try {
                                                    ((ChildrenDeletable)ZkCoordinator.this.curator.delete().guaranteed()).forPath(path);
                                                }
                                                catch (Exception e1) {
                                                    log.error(e1, "Failed to delete zNode[%s], but ignoring exception.", path);
                                                }
                                                log.error(e, "Exception while removing zNode[%s]", path);
                                                throw Throwables.propagate(e);
                                            }
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    try {
                                        ((ChildrenDeletable)ZkCoordinator.this.curator.delete().guaranteed()).forPath(path);
                                    }
                                    catch (Exception e1) {
                                        log.error(e1, "Failed to delete zNode[%s], but ignoring exception.", path);
                                    }
                                    log.makeAlert(e, "Segment load/unload: uncaught exception.", new Object[0]).addData("node", path).addData("nodeProperties", request).emit();
                                }
                                break;
                            }
                            case CHILD_REMOVED: {
                                log.info("zNode[%s] was removed", event.getData().getPath());
                                break;
                            }
                            default: {
                                log.info("Ignoring event[%s]", event);
                            }
                        }
                    }
                });
                this.loadQueueCache.start();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible(e, IOException.class);
                throw Throwables.propagate(e);
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        log.info("Stopping ZkCoordinator for [%s]", this.me);
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            try {
                this.loadQueueCache.close();
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
            finally {
                this.loadQueueCache = null;
                this.started = false;
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }
}

